/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import javax.swing.JComponent;
import jkcemu.base.AbstractScreenDevice;
import jkcemu.base.AbstractScreenFrm;
import jkcemu.base.CharRaster;

public class ScreenFld
extends JComponent
implements MouseMotionListener {
    public static final String PROP_BRIGHTNESS = "jkcemu.brightness";
    public static final int DEFAULT_BRIGHTNESS = 80;
    public static final int DEFAULT_MARGIN = 20;
    private AbstractScreenFrm screenFrm;
    private volatile AbstractScreenDevice screenDevice;
    private volatile CharRaster charRaster;
    private Point dragStart;
    private Point dragEnd;
    private Color markXORColor;
    private boolean textSelected;
    private int selectionCharX1;
    private int selectionCharX2;
    private int selectionCharY1;
    private int selectionCharY2;
    private int scale;
    private int margin;
    private int xOffs;
    private int yOffs;

    public ScreenFld(AbstractScreenFrm abstractScreenFrm) {
        this.screenFrm = abstractScreenFrm;
        this.screenDevice = null;
        this.dragStart = null;
        this.dragEnd = null;
        this.markXORColor = new Color(192, 192, 0);
        this.textSelected = false;
        this.selectionCharX1 = -1;
        this.selectionCharY1 = -1;
        this.selectionCharX2 = -1;
        this.selectionCharY2 = -1;
        this.scale = 1;
        this.margin = 20;
        this.xOffs = 0;
        this.yOffs = 0;
        this.addMouseMotionListener(this);
        this.updPreferredSize();
    }

    public void clearSelection() {
        this.dragStart = null;
        this.dragEnd = null;
        this.selectionCharX1 = -1;
        this.selectionCharY1 = -1;
        this.selectionCharX2 = -1;
        this.selectionCharY2 = -1;
        this.screenFrm.setScreenDirty(true);
    }

    public BufferedImage createBufferedImage() {
        BufferedImage bufferedImage = null;
        int n = this.getWidth();
        int n2 = this.getHeight();
        AbstractScreenDevice abstractScreenDevice = this.screenDevice;
        if (abstractScreenDevice != null && n > 0 && n2 > 0) {
            Object object;
            int n3 = abstractScreenDevice.getColorCount();
            int n4 = n3 - 1;
            int n5 = 0;
            while (n4 > 0) {
                n4 >>= 1;
                ++n5;
            }
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n3];
            byte[] byArray3 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                object = abstractScreenDevice.getColor(i);
                byArray[i] = (byte)((Color)object).getRed();
                byArray2[i] = (byte)((Color)object).getGreen();
                byArray3[i] = (byte)((Color)object).getBlue();
            }
            IndexColorModel indexColorModel = new IndexColorModel(n5, n3, byArray, byArray2, byArray3);
            bufferedImage = new BufferedImage(n, n2, n5 > 4 ? 13 : 12, indexColorModel);
            object = bufferedImage.createGraphics();
            this.paint((Graphics)object, n, n2, false);
            ((Graphics)object).dispose();
        }
        return bufferedImage;
    }

    public int getMargin() {
        return this.margin;
    }

    public AbstractScreenDevice getScreenDevice() {
        return this.screenDevice;
    }

    public int getScreenScale() {
        return this.scale;
    }

    public String getSelectedText() {
        String string = null;
        AbstractScreenDevice abstractScreenDevice = this.screenDevice;
        CharRaster charRaster = this.charRaster;
        if (abstractScreenDevice != null && charRaster != null) {
            string = abstractScreenDevice.getScreenText(charRaster, this.selectionCharX1, this.selectionCharY1, this.selectionCharX2, this.selectionCharY2);
        }
        return this.selectionCharX1 >= 0 && this.selectionCharY1 >= 0 && this.selectionCharX2 >= 0 && this.selectionCharY2 >= 0 ? string : null;
    }

    public void setMargin(int n) {
        this.margin = n;
        this.updPreferredSize();
    }

    public void setScreenDevice(AbstractScreenDevice abstractScreenDevice) {
        this.screenDevice = abstractScreenDevice;
        this.clearSelection();
        this.updPreferredSize();
    }

    public void setScreenScale(int n) {
        if (n > 0 && n != this.scale) {
            this.scale = n;
            this.updPreferredSize();
        }
    }

    public void updPreferredSize() {
        Container container;
        this.clearSelection();
        AbstractScreenDevice abstractScreenDevice = this.screenDevice;
        if (abstractScreenDevice != null) {
            int n = this.margin;
            if (n < 0) {
                n = 0;
            }
            this.setPreferredSize(new Dimension(2 * n + abstractScreenDevice.getScreenWidth() * this.scale, 2 * n + abstractScreenDevice.getScreenHeight() * this.scale));
        }
        if ((container = this.getParent()) != null) {
            container.invalidate();
        } else {
            this.invalidate();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        AbstractScreenDevice abstractScreenDevice = this.screenDevice;
        if (mouseEvent.getComponent() == this && abstractScreenDevice != null) {
            if (this.dragStart == null) {
                this.charRaster = abstractScreenDevice.getCurScreenCharRaster();
                if (this.charRaster != null) {
                    this.dragStart = new Point(mouseEvent.getX(), mouseEvent.getY());
                    this.dragEnd = null;
                    this.screenFrm.setScreenDirty(true);
                }
            } else {
                if (this.charRaster != null) {
                    this.dragEnd = new Point(mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.dragEnd = null;
                    this.dragStart = null;
                }
                this.screenFrm.setScreenDirty(true);
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
        this.screenFrm.setScreenDirty(false);
        this.paint(graphics, this.getWidth(), this.getHeight(), true);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void paint(Graphics graphics, int n, int n2, boolean bl) {
        boolean bl2 = false;
        AbstractScreenDevice abstractScreenDevice = this.screenDevice;
        if (n > 0 && n2 > 0 && abstractScreenDevice != null) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = abstractScreenDevice.getScreenWidth();
            int n9 = abstractScreenDevice.getScreenHeight();
            this.xOffs = (n - n8 * this.scale) / 2;
            if (this.xOffs < 0) {
                this.xOffs = 0;
            }
            this.yOffs = (n2 - n9 * this.scale) / 2;
            if (this.yOffs < 0) {
                this.yOffs = 0;
            }
            int n10 = abstractScreenDevice.getBorderColorIndex();
            if (abstractScreenDevice.supportsBorderColorByLine()) {
                n7 = this.scale;
                if (n7 > 1) {
                    n6 = -this.yOffs / n7;
                    for (n5 = 0; n5 < n2; n5 += n7) {
                        n10 = abstractScreenDevice.getBorderColorIndexByLine(n6++);
                        graphics.setColor(abstractScreenDevice.getColor(n10));
                        graphics.fillRect(0, n5, n, n5 + n7);
                    }
                } else {
                    n6 = -this.yOffs;
                    for (n5 = 0; n5 < n2; ++n5) {
                        n10 = abstractScreenDevice.getBorderColorIndexByLine(n6++);
                        graphics.setColor(abstractScreenDevice.getColor(n10));
                        graphics.drawLine(0, n5, n, n5);
                    }
                }
                n10 = -1;
            } else {
                graphics.setColor(abstractScreenDevice.getColor(n10));
                graphics.fillRect(0, 0, n, n2);
            }
            if (!abstractScreenDevice.paintScreen(graphics, this.xOffs, this.yOffs, this.scale)) {
                if (this.xOffs > 0 || this.yOffs > 0) {
                    graphics.translate(this.xOffs, this.yOffs);
                }
                for (n7 = 0; n7 < n8; ++n7) {
                    n6 = -1;
                    n5 = -1;
                    for (n4 = 0; n4 < n9; ++n4) {
                        n3 = abstractScreenDevice.getColorIndex(n7, n4);
                        if (n3 == n6) continue;
                        if (n6 >= 0 && n6 != n10 && n5 >= 0) {
                            graphics.setColor(abstractScreenDevice.getColor(n6));
                            graphics.fillRect(n7 * this.scale, n5 * this.scale, this.scale, (n4 - n5) * this.scale);
                        }
                        n5 = n4;
                        n6 = n3;
                    }
                    if (n6 < 0 || n6 == n10 || n5 < 0) continue;
                    graphics.setColor(abstractScreenDevice.getColor(n6));
                    graphics.fillRect(n7 * this.scale, n5 * this.scale, this.scale, (n9 - n5) * this.scale);
                }
                if (this.xOffs > 0 || this.yOffs > 0) {
                    graphics.translate(-this.xOffs, -this.yOffs);
                }
            }
            if (bl) {
                CharRaster charRaster = this.charRaster;
                Point point = this.dragStart;
                Point point2 = this.dragEnd;
                n4 = this.scale;
                if (charRaster != null && point != null && point2 != null && n4 > 0) {
                    n3 = this.charRaster.getTopLine();
                    int n11 = this.charRaster.getColCount();
                    int n12 = this.charRaster.getRowCount();
                    int n13 = this.charRaster.getRowHeight();
                    int n14 = this.charRaster.getCharHeight();
                    int n15 = this.charRaster.getCharWidth();
                    if (n11 > 0 && n12 > 0 && n13 > 0 && n14 > 0 && n15 > 0) {
                        int n16 = point.x;
                        int n17 = point.y;
                        int n18 = point2.x;
                        int n19 = point2.y;
                        int n20 = this.yOffs + n3 * n4;
                        this.selectionCharX1 = Math.max((n16 - this.xOffs) / n4, 0) / n15;
                        this.selectionCharY1 = Math.max((n17 - n20) / n4, 0) / n13;
                        this.selectionCharX2 = Math.max((n18 - this.xOffs) / n4, 0) / n15;
                        this.selectionCharY2 = Math.max((n19 - n20) / n4, 0) / n13;
                        if (this.selectionCharX1 >= n11) {
                            this.selectionCharX1 = n11 - 1;
                        }
                        if (this.selectionCharY1 >= n12) {
                            this.selectionCharY1 = n12 - 1;
                        }
                        if (this.selectionCharX2 >= n11) {
                            this.selectionCharX2 = n11 - 1;
                        }
                        if (this.selectionCharY2 >= n12) {
                            this.selectionCharY2 = n12 - 1;
                        }
                        if (this.selectionCharY1 > this.selectionCharY2 || this.selectionCharY1 == this.selectionCharY2 && this.selectionCharX1 > this.selectionCharX2) {
                            int n21 = this.selectionCharX1;
                            this.selectionCharX1 = this.selectionCharX2;
                            this.selectionCharX2 = n21;
                            n21 = this.selectionCharY1;
                            this.selectionCharY1 = this.selectionCharY2;
                            this.selectionCharY2 = n21;
                            n21 = n16;
                            n16 = n18;
                            n18 = n21;
                            n21 = n17;
                            n17 = n19;
                            n19 = n21;
                        }
                        if (n17 < n20) {
                            this.selectionCharX1 = 0;
                            this.selectionCharY1 = 0;
                        } else if (n16 > this.xOffs + n4 * n11 * n15) {
                            this.selectionCharX1 = 0;
                            ++this.selectionCharY1;
                        }
                        if (n19 > n20 + n4 * ((n12 - 1) * n13 + n14)) {
                            this.selectionCharX2 = n11 - 1;
                            this.selectionCharY2 = n12 - 1;
                        } else if (n18 < this.xOffs) {
                            this.selectionCharX2 = n11 - 1;
                            --this.selectionCharY2;
                        }
                        graphics.setColor(Color.white);
                        graphics.setXORMode(this.markXORColor);
                        if (this.selectionCharY1 == this.selectionCharY2) {
                            graphics.fillRect(this.xOffs + n4 * this.selectionCharX1 * n15, n20 + n4 * this.selectionCharY1 * n13, n4 * (this.selectionCharX2 - this.selectionCharX1 + 1) * n15, n4 * n14);
                        } else {
                            graphics.fillRect(this.xOffs + n4 * this.selectionCharX1 * n15, n20 + n4 * this.selectionCharY1 * n13, n4 * (n11 - this.selectionCharX1) * n15, n4 * n13);
                            if (this.selectionCharY1 + 1 < this.selectionCharY2) {
                                graphics.fillRect(this.xOffs, n20 + n4 * (this.selectionCharY1 + 1) * n13, n4 * n11 * n15, n4 * (this.selectionCharY2 - this.selectionCharY1 - 1) * n13);
                            }
                            graphics.fillRect(this.xOffs, n20 + n4 * this.selectionCharY2 * n13, n4 * (this.selectionCharX2 + 1) * n15, n4 * n14);
                        }
                        bl2 = true;
                    }
                }
            }
        }
        if (bl && bl2 != this.textSelected) {
            this.textSelected = bl2;
            this.screenFrm.setScreenTextSelected(bl2);
        }
    }
}

