/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jkcemu.base.BaseDlg;

public class ReplyBytesDlg
extends BaseDlg {
    private byte[] approvedBytes = null;
    private String approvedText = null;
    private InputFormat approvedInputFmt = null;
    private boolean approvedBigEndian = false;
    private JRadioButton btnHex8;
    private JRadioButton btnDec8;
    private JRadioButton btnDec16;
    private JRadioButton btnDec32;
    private JRadioButton btnString;
    private JRadioButton btnLittleEndian;
    private JRadioButton btnBigEndian;
    private JLabel labelByteOrder;
    private JTextField fldInput;
    private JButton btnPaste;
    private JButton btnOK;
    private JButton btnCancel;

    public ReplyBytesDlg(Window window, String string, InputFormat inputFormat, boolean bl, String string2) {
        super(window, string != null ? string : "Eingabe");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Bytes eingeben als:"), gridBagConstraints);
        this.labelByteOrder = new JLabel("Byte-Anordnung:");
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelByteOrder, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnHex8 = new JRadioButton("8-Bit hexadezimale Zahlen", true);
        this.btnHex8.setMnemonic(72);
        this.btnHex8.addActionListener(this);
        buttonGroup.add(this.btnHex8);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnHex8, gridBagConstraints);
        this.btnLittleEndian = new JRadioButton("Little Endian", !bl);
        this.btnLittleEndian.setMnemonic(76);
        this.btnLittleEndian.addActionListener(this);
        buttonGroup2.add(this.btnLittleEndian);
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnLittleEndian, gridBagConstraints);
        this.btnDec8 = new JRadioButton("8-Bit Dezimalzahlen", false);
        this.btnDec8.setMnemonic(56);
        this.btnDec8.addActionListener(this);
        buttonGroup.add(this.btnDec8);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnDec8, gridBagConstraints);
        this.btnBigEndian = new JRadioButton("Big Endian", bl);
        this.btnBigEndian.setMnemonic(66);
        this.btnBigEndian.addActionListener(this);
        buttonGroup2.add(this.btnBigEndian);
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnBigEndian, gridBagConstraints);
        this.btnDec16 = new JRadioButton("16-Bit Dezimalzahlen", false);
        this.btnDec16.setMnemonic(54);
        this.btnDec16.addActionListener(this);
        buttonGroup.add(this.btnDec16);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnDec16, gridBagConstraints);
        this.btnDec32 = new JRadioButton("32-Bit Dezimalzahlen", false);
        this.btnDec32.setMnemonic(51);
        this.btnDec32.addActionListener(this);
        buttonGroup.add(this.btnDec32);
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnDec32, gridBagConstraints);
        this.btnString = new JRadioButton("ASCII-Zeichenkette", false);
        this.btnString.setMnemonic(65);
        this.btnString.addActionListener(this);
        buttonGroup.add(this.btnString);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnString, gridBagConstraints);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Eingabe:"), gridBagConstraints);
        if (inputFormat != null) {
            switch (inputFormat) {
                case HEX8: {
                    this.btnHex8.setSelected(true);
                    break;
                }
                case DEC8: {
                    this.btnDec8.setSelected(true);
                    break;
                }
                case DEC16: {
                    this.btnDec16.setSelected(true);
                    break;
                }
                case DEC32: {
                    this.btnHex8.setSelected(true);
                    break;
                }
                case STRING: {
                    this.btnString.setSelected(true);
                }
            }
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.fldInput = new JTextField();
        if (string2 != null) {
            this.fldInput.setText(string2);
        }
        this.fldInput.addActionListener(this);
        jPanel.add((Component)this.fldInput, gridBagConstraints2);
        this.btnPaste = this.createImageButton("/images/edit/paste.png", "Einf\u00fcgen");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnPaste, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        jPanel2.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        jPanel2.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.updByteOrderFields();
    }

    public boolean getApprovedBigEndian() {
        return this.approvedBigEndian;
    }

    public byte[] getApprovedBytes() {
        return this.approvedBytes;
    }

    public InputFormat getApprovedInputFormat() {
        return this.approvedInputFmt;
    }

    public String getApprovedText() {
        return this.approvedText;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnHex8 || object == this.btnDec8 || object == this.btnDec16 || object == this.btnDec32 || object == this.btnString) {
                bl = true;
                this.updByteOrderFields();
                this.fldInput.requestFocus();
            } else if (object == this.btnLittleEndian || object == this.btnBigEndian) {
                bl = true;
                this.fldInput.requestFocus();
            } else if (object == this.fldInput || object == this.btnOK) {
                bl = true;
                this.doApprove();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (object == this.btnPaste) {
                bl = true;
                this.fldInput.paste();
            }
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.fldInput.requestFocus();
    }

    private void doApprove() {
        byte[] byArray = null;
        try {
            int n;
            InputFormat inputFormat = null;
            boolean bl = this.btnBigEndian.isSelected();
            String string = this.fldInput.getText();
            if (string != null && (n = string.length()) > 0) {
                if (this.btnString.isSelected()) {
                    inputFormat = InputFormat.STRING;
                    byArray = new byte[n];
                    for (int i = 0; i < n; ++i) {
                        char c = string.charAt(i);
                        if (c < ' ' || c > '~') {
                            throw new ParseException(String.format("Das Zeichen '%c' ist kein ASCII-Zeichen.", Character.valueOf(c)), i);
                        }
                        byArray[i] = (byte)c;
                    }
                } else {
                    inputFormat = InputFormat.HEX8;
                    int n2 = 1;
                    int n3 = 16;
                    if (this.btnDec8.isSelected()) {
                        inputFormat = InputFormat.DEC8;
                        n3 = 10;
                    } else if (this.btnDec16.isSelected()) {
                        inputFormat = InputFormat.DEC16;
                        n2 = 2;
                        n3 = 10;
                    } else if (this.btnDec32.isSelected()) {
                        inputFormat = InputFormat.DEC32;
                        n2 = 4;
                        n3 = 10;
                    }
                    String[] stringArray = string.toUpperCase().split("[\\s,:;]");
                    if (stringArray != null && stringArray.length > 0) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(stringArray.length * n2);
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string2 = stringArray[i];
                            if (string2 == null || string2.length() <= 0) continue;
                            try {
                                int n4;
                                int n5 = Integer.parseInt(stringArray[i], n3);
                                int n6 = i * n2;
                                if (this.btnBigEndian.isSelected()) {
                                    for (n4 = n2 - 1; n4 >= 0; --n4) {
                                        if (n4 > 0) {
                                            byteArrayOutputStream.write(n5 >> n4 * 8 & 0xFF);
                                            continue;
                                        }
                                        byteArrayOutputStream.write(n5 & 0xFF);
                                    }
                                    continue;
                                }
                                for (n4 = 0; n4 < n2; ++n4) {
                                    byteArrayOutputStream.write(n5 & 0xFF);
                                    n5 >>= 8;
                                }
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new ParseException(String.format("%s: ung\u00fcltiges Format", stringArray[i]), i);
                            }
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                }
            }
            if (byArray != null) {
                this.approvedBytes = byArray;
                this.approvedText = string;
                this.approvedInputFmt = inputFormat;
                this.approvedBigEndian = false;
                this.doClose();
            }
        }
        catch (Exception exception) {
            ReplyBytesDlg.showErrorDlg((Component)this, exception.getMessage());
        }
    }

    private void updByteOrderFields() {
        boolean bl = this.btnDec16.isSelected() || this.btnDec32.isSelected();
        this.labelByteOrder.setEnabled(bl);
        this.btnLittleEndian.setEnabled(bl);
        this.btnBigEndian.setEnabled(bl);
    }

    public static enum InputFormat {
        HEX8,
        DEC8,
        DEC16,
        DEC32,
        STRING;

    }
}

