/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.EventObject;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HTMLViewFrm;

public class HelpFrm
extends HTMLViewFrm
implements HyperlinkListener {
    private static HelpFrm instance = null;
    private Timer timer;
    private Double posToScroll;
    private URL urlHome;
    private Stack<URLStackEntry> urlStack;
    private JMenuItem mnuNavBack;
    private JMenuItem mnuNavHome;
    private JButton btnBack;
    private JButton btnHome;
    private JButton btnPrint;

    public static void open(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpFrm.openInternal(string);
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setUrl(true, hyperlinkEvent.getURL(), null);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnPrint) {
                bl = true;
                this.doPrint();
            } else if (object == this.mnuNavBack || object == this.btnBack) {
                bl = true;
                this.doBack();
            } else if (object == this.mnuNavHome || object == this.btnHome) {
                bl = true;
                this.setUrl(true, null, null);
            } else if (object == this.timer) {
                bl = true;
                this.timer.stop();
                this.doScrollTo(this.posToScroll);
                this.posToScroll = null;
            }
        }
        if (!bl) {
            super.doAction(eventObject);
        }
        return bl;
    }

    private HelpFrm() {
        this.setTitle("JKCEMU Hilfe");
        Main.updIcon(this);
        this.timer = new Timer(500, this);
        this.urlStack = new Stack();
        this.urlHome = this.getClass().getResource("/help/home.htm");
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        JMenu jMenu2 = new JMenu("Navigation");
        jMenu2.setMnemonic(78);
        this.mnuNavBack = this.createJMenuItem("Zur\u00fcck", KeyStroke.getKeyStroke(66, 2));
        jMenu2.add(this.mnuNavBack);
        this.mnuNavHome = this.createJMenuItem("Startseite", KeyStroke.getKeyStroke(72, 2));
        jMenu2.add(this.mnuNavHome);
        this.createMenuBar(jMenu, jMenu2, null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        this.btnBack = this.createImageButton("/images/nav/back.png", "Zur\u00fcck");
        jToolBar.add(this.btnBack);
        this.btnHome = this.createImageButton("/images/nav/home.png", "Startseite");
        jToolBar.add(this.btnHome);
        jToolBar.addSeparator();
        this.btnPrint = this.createImageButton("/images/file/print.png", "Drucken");
        jToolBar.add(this.btnPrint);
        this.add((Component)jToolBar, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        this.createEditorPane(gridBagConstraints);
        this.editorPane.addCaretListener(this);
        this.editorPane.addHyperlinkListener(this);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.setBoundsToDefaults();
        }
        this.setResizable(true);
    }

    private void doBack() {
        if (this.urlStack.size() > 1) {
            try {
                this.urlStack.pop();
                URLStackEntry uRLStackEntry = this.urlStack.pop();
                this.setUrl(false, uRLStackEntry.url, uRLStackEntry.viewPos);
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
    }

    private void doScrollTo(Double d) {
        if (d != null) {
            JViewport jViewport;
            double d2 = d;
            int n = this.editorPane.getHeight();
            if (d2 > 0.0 && d2 <= 1.0 && n > 0 && (jViewport = this.scrollPane.getViewport()) != null) {
                jViewport.setViewPosition(new Point(0, (int)Math.round(d2 * (double)n)));
            }
        }
    }

    private static void openInternal(String string) {
        if (instance == null) {
            instance = new HelpFrm();
        }
        EmuUtil.showFrame(instance);
        instance.setPage(string);
    }

    private void setPage(String string) {
        this.setUrl(true, string != null ? this.getClass().getResource(string) : null, null);
    }

    private void setUrl(boolean bl, URL uRL, Double d) {
        if (uRL == null) {
            this.urlStack.clear();
            uRL = this.urlHome;
        }
        if (uRL != null) {
            boolean bl2 = false;
            URLStackEntry uRLStackEntry = null;
            if (this.urlStack.size() > 0) {
                uRLStackEntry = this.urlStack.peek();
                if (uRLStackEntry.url.equals(uRL)) {
                    bl2 = true;
                }
            }
            if (!bl2) {
                try {
                    int n;
                    if (bl && uRLStackEntry != null) {
                        double d2;
                        Point point;
                        JViewport jViewport;
                        uRLStackEntry.viewPos = null;
                        n = this.editorPane.getHeight();
                        if (n > 0 && (jViewport = this.scrollPane.getViewport()) != null && (point = jViewport.getViewPosition()) != null && (d2 = (double)point.y / (double)n) > 0.0 && d2 <= 1.0) {
                            uRLStackEntry.viewPos = d2;
                        }
                    }
                    this.editorPane.setPage(uRL);
                    this.urlStack.push(new URLStackEntry(uRL, null));
                    if (d != null) {
                        this.posToScroll = d;
                        this.timer.restart();
                    }
                    n = this.urlStack.size() > 1 ? 1 : 0;
                    this.mnuNavBack.setEnabled(n != 0);
                    this.btnBack.setEnabled(n != 0);
                    boolean bl3 = n != 0 || !uRL.equals(this.urlHome);
                    this.mnuNavHome.setEnabled(bl3);
                    this.btnHome.setEnabled(bl3);
                }
                catch (Exception exception) {
                    BaseDlg.showErrorDlg((Component)this, "Die Hilfeseite kann nicht angezeigt werden.\n\n" + exception.getMessage());
                }
            }
        }
    }

    private static class URLStackEntry {
        public URL url;
        public Double viewPos;

        public URLStackEntry(URL uRL, Double d) {
            this.url = uRL;
            this.viewPos = d;
        }
    }
}

