/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.File;
import java.util.Comparator;
import jkcemu.base.FileComparator;
import jkcemu.base.FileTreeNode;

public class FileTreeNodeComparator
implements Comparator<FileTreeNode> {
    private static FileTreeNodeComparator caseSensitiveInstance = null;
    private static FileTreeNodeComparator ignoreCaseInstance = null;
    private boolean caseSensitive;
    private boolean forFileSystemRoots;

    public static FileTreeNodeComparator getCaseSensitiveInstance() {
        if (caseSensitiveInstance == null) {
            caseSensitiveInstance = new FileTreeNodeComparator(true);
        }
        return caseSensitiveInstance;
    }

    public static FileTreeNodeComparator getIgnoreCaseInstance() {
        if (ignoreCaseInstance == null) {
            ignoreCaseInstance = new FileTreeNodeComparator(false);
        }
        return ignoreCaseInstance;
    }

    public void setForFileSystemRoots(boolean bl) {
        this.forFileSystemRoots = bl;
    }

    @Override
    public int compare(FileTreeNode fileTreeNode, FileTreeNode fileTreeNode2) {
        int n = -1;
        if (fileTreeNode != null && fileTreeNode2 != null) {
            File file = fileTreeNode.getFile();
            File file2 = fileTreeNode2.getFile();
            if (file != null && file2 != null) {
                if (this.forFileSystemRoots) {
                    String string = file.getPath();
                    String string2 = file2.getPath();
                    if (string == null) {
                        string = "";
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                    n = this.caseSensitive ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
                } else {
                    n = FileComparator.compare(file, file2, this.caseSensitive);
                }
            }
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    private FileTreeNodeComparator(boolean bl) {
        this.caseSensitive = bl;
        this.forFileSystemRoots = false;
    }
}

