/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeNode;
import jkcemu.base.FileTreeNodeComparator;

public class FileTreeNode
implements TreeNode {
    protected Path path;
    protected File file;
    protected boolean fileSystemRoot;
    protected boolean childrenLoaded;
    protected FileSystemView fsv;
    protected Vector<FileTreeNode> vChildren;
    private TreeNode parent;
    private boolean allowsChildren;
    private boolean leaf;
    private String nodeName;

    public FileTreeNode(TreeNode treeNode, Path path, File file, boolean bl, FileSystemView fileSystemView) {
        this.parent = treeNode;
        this.path = path;
        this.file = file;
        this.fileSystemRoot = bl;
        this.fsv = fileSystemView;
        this.allowsChildren = bl;
        this.leaf = !bl;
        this.childrenLoaded = false;
        this.vChildren = null;
        this.updNode();
    }

    public void add(FileTreeNode fileTreeNode) {
        if (this.vChildren == null) {
            this.vChildren = new Vector();
        }
        this.vChildren.add(fileTreeNode);
        this.allowsChildren = true;
        this.leaf = false;
    }

    public synchronized File getFile() {
        if (this.file == null && this.path != null) {
            try {
                this.file = this.path.toFile();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return this.file;
    }

    public FileSystemView getFileSystemView() {
        return this.fsv;
    }

    public Path getPath() {
        if (this.path == null && this.file != null) {
            try {
                this.path = this.file.toPath();
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return this.path;
    }

    public boolean hasChildrenLoaded() {
        return this.childrenLoaded;
    }

    public boolean isFileSystemRoot() {
        return this.fileSystemRoot;
    }

    public void removeAllChildren() {
        if (this.vChildren != null) {
            this.vChildren.clear();
        }
    }

    public void removeFromParent() {
        if (this.parent != null && this.parent instanceof FileTreeNode) {
            FileTreeNode fileTreeNode = (FileTreeNode)this.parent;
            if (fileTreeNode.vChildren != null) {
                fileTreeNode.vChildren.remove(this);
            }
        }
    }

    public void setChildrenLoaded(boolean bl) {
        this.childrenLoaded = bl;
    }

    public void setFile(File file) {
        this.path = null;
        this.file = file;
        if (file != null) {
            try {
                this.path = file.toPath();
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        this.updNode();
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        this.fsv = fileSystemView;
    }

    public void sort(FileTreeNodeComparator fileTreeNodeComparator) {
        if (this.vChildren != null && fileTreeNodeComparator != null) {
            try {
                Collections.sort(this.vChildren, fileTreeNodeComparator);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected void updNode() {
        Comparable<File> comparable;
        this.nodeName = null;
        if (this.fsv != null && (comparable = this.getFile()) != null) {
            this.nodeName = this.fsv.getSystemDisplayName((File)comparable);
            if (this.nodeName != null && this.nodeName.isEmpty()) {
                this.nodeName = null;
            }
        }
        if ((comparable = this.getPath()) != null) {
            if (this.fileSystemRoot) {
                if (this.nodeName == null) {
                    this.nodeName = this.path.toString();
                }
            } else {
                Comparable<Path> comparable2;
                if (this.nodeName == null && (comparable2 = comparable.getFileName()) != null) {
                    this.nodeName = comparable2.toString();
                }
                if (Files.isDirectory(comparable, new LinkOption[0])) {
                    this.allowsChildren = true;
                    this.leaf = false;
                } else {
                    this.allowsChildren = false;
                    this.leaf = true;
                }
                try {
                    if (Files.isSymbolicLink(comparable)) {
                        String string;
                        comparable2 = new StringBuilder(256);
                        if (this.nodeName != null) {
                            ((StringBuilder)comparable2).append(this.nodeName);
                        }
                        ((StringBuilder)comparable2).append(" \u2192");
                        Path path = Files.readSymbolicLink(comparable);
                        if (path != null && (string = path.toString()) != null && !string.isEmpty()) {
                            ((StringBuilder)comparable2).append(' ');
                            ((StringBuilder)comparable2).append(string);
                        }
                        this.allowsChildren = false;
                        this.nodeName = ((StringBuilder)comparable2).toString();
                    }
                }
                catch (Exception exception) {
                    this.allowsChildren = false;
                }
            }
        } else {
            File file = this.getFile();
            if (file != null) {
                if (this.fileSystemRoot) {
                    if (this.nodeName == null) {
                        this.nodeName = this.file.getPath();
                    }
                } else {
                    if (this.nodeName == null) {
                        this.nodeName = file.getName();
                    }
                    if (this.file.isDirectory()) {
                        this.allowsChildren = true;
                        this.leaf = false;
                    } else {
                        this.allowsChildren = false;
                        this.leaf = true;
                    }
                }
            }
        }
        if (this.nodeName == null) {
            this.nodeName = "?";
        }
    }

    public Enumeration children() {
        if (this.vChildren == null) {
            this.vChildren = new Vector();
        }
        return this.vChildren.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public TreeNode getChildAt(int n) {
        TreeNode treeNode = null;
        if (this.vChildren != null && n >= 0 && n < this.vChildren.size()) {
            treeNode = this.vChildren.get(n);
        }
        return treeNode;
    }

    @Override
    public int getChildCount() {
        return this.vChildren != null ? this.vChildren.size() : 0;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.vChildren != null ? this.vChildren.indexOf(treeNode) : -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public String toString() {
        return this.nodeName;
    }
}

