/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Window;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import jkcemu.base.AbstractFileWorker;
import jkcemu.base.BaseDlg;

public class FileRemover
extends AbstractFileWorker {
    public static void startRemove(Window window, List<Path> list, AbstractFileWorker.PathListener pathListener, Collection<AbstractFileWorker> collection) {
        int n;
        if (list != null && (n = list.size()) > 0) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("M\u00f6chten Sie ");
            if (n == 1) {
                Path path = list.get(0);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    stringBuilder.append("das Verzeichnis");
                } else if (Files.isSymbolicLink(path)) {
                    stringBuilder.append("den symbolischen Link");
                } else {
                    stringBuilder.append("die Datei");
                }
                stringBuilder.append("\n'");
                stringBuilder.append(path);
                stringBuilder.append("'\n");
            } else {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (Path path : list) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        ++n2;
                        continue;
                    }
                    if (Files.isSymbolicLink(path)) {
                        ++n4;
                        continue;
                    }
                    ++n3;
                }
                if (n2 == 1) {
                    stringBuilder.append("das Verzeichnis");
                } else if (n2 > 1) {
                    stringBuilder.append(n2);
                    stringBuilder.append(" Verzeichnisse");
                }
                if (n3 > 0) {
                    if (n2 > 0) {
                        if (n4 > 0) {
                            stringBuilder.append(", ");
                        } else {
                            stringBuilder.append(" und ");
                        }
                    }
                    if (n3 == 1) {
                        stringBuilder.append("die Datei");
                    } else if (n3 > 1) {
                        stringBuilder.append(n3);
                        stringBuilder.append(" Dateien");
                    }
                }
                if (n4 > 0) {
                    if (n2 > 0 && n3 > 0) {
                        stringBuilder.append(" und ");
                    }
                    if (n4 == 1) {
                        stringBuilder.append("den symbolischen Link");
                    } else if (n4 > 1) {
                        stringBuilder.append(n4);
                        stringBuilder.append(" symbolische Links");
                    }
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append("l\u00f6schen?");
            if (BaseDlg.showYesNoDlg(window, stringBuilder.toString())) {
                new FileRemover(window, list, pathListener, collection).startWork();
            }
        }
    }

    @Override
    public String getFileFailedMsg(String string) {
        return string + "\nkann nicht gel\u00f6scht werden.";
    }

    @Override
    public String getProgressDlgTitle() {
        return "L\u00f6schen";
    }

    @Override
    public String getUncompletedWorkMsg() {
        return "Es konnten nicht alle Dateien, Verzeichnisse bzw.\nsymbolische Links gel\u00f6scht werden.";
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        if (!this.cancelled) {
            this.curPath = path;
            try {
                Files.delete(path);
                this.pathRemoved(path);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException iOException2) {
                this.handleError(path, iOException2);
            }
        }
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        if (!this.cancelled) {
            this.curPath = path;
            try {
                Files.delete(path);
                this.pathRemoved(path);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException iOException) {
                this.handleError(path, iOException);
            }
        }
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    private FileRemover(Window window, List<Path> list, AbstractFileWorker.PathListener pathListener, Collection<AbstractFileWorker> collection) {
        super(window, list, pathListener, collection);
    }
}

