/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JTextField;

public class FileNameFld
extends JTextField {
    private File file;
    private String[] filePathElems = null;

    public FileNameFld() {
        this.setEditable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                FileNameFld.this.updView();
            }
        });
    }

    public File getFile() {
        return this.file;
    }

    public boolean setFile(File file) {
        boolean bl = true;
        if (file != null && this.file != null) {
            if (file.getPath().equals(this.file.getPath())) {
                bl = false;
            }
        } else if (file == null && this.file == null) {
            bl = false;
        }
        if (bl) {
            this.file = file;
            this.filePathElems = null;
            this.updView();
        }
        return bl;
    }

    public void setFileName(String string) {
        File file = null;
        if (string != null && !string.isEmpty()) {
            file = new File(string);
        }
        this.setFile(file);
    }

    @Override
    public void setText(String string) {
        this.file = null;
        this.filePathElems = null;
        super.setText(string);
        this.setToolTipText(null);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updView();
    }

    private void updView() {
        this.setToolTipText(null);
        String string = null;
        if (this.file != null) {
            string = this.file.getPath();
        }
        super.setText(string);
        if (string != null) {
            int n = this.getWidth();
            if (this.getPrefWidth() > n) {
                int n2;
                Object object;
                if (this.filePathElems == null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    object = this.file;
                    while (object != null) {
                        String string2 = ((File)object).getName();
                        if (string2 != null) {
                            if (string2.isEmpty()) {
                                arrayList.add(((File)object).getPath());
                                object = null;
                                continue;
                            }
                            arrayList.add(string2);
                            object = ((File)object).getParentFile();
                            continue;
                        }
                        arrayList.add(((File)object).getPath());
                        object = null;
                    }
                    int n3 = arrayList.size();
                    if (n3 > 2) {
                        this.filePathElems = new String[n3];
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.filePathElems[n2] = (String)arrayList.get(n3 - n2 - 1);
                        }
                    }
                }
                if (this.filePathElems != null) {
                    int n4 = this.filePathElems.length / 2;
                    if (n4 * 2 == this.filePathElems.length) {
                        --n4;
                    }
                    if ((object = File.separator) == null) {
                        object = Character.toString(File.separatorChar);
                    }
                    StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
                    while (n4 > 0) {
                        stringBuilder.setLength(0);
                        for (n2 = 0; n2 < n4; ++n2) {
                            String string3 = this.filePathElems[n2];
                            stringBuilder.append(string3);
                            if (string3.endsWith((String)object)) continue;
                            stringBuilder.append((String)object);
                        }
                        stringBuilder.append("...");
                        for (n2 = this.filePathElems.length - n4; n2 < this.filePathElems.length; ++n2) {
                            stringBuilder.append(File.separatorChar);
                            stringBuilder.append(this.filePathElems[n2]);
                        }
                        super.setText(stringBuilder.toString());
                        if (this.getPrefWidth() <= n) break;
                        --n4;
                    }
                    this.setToolTipText(string);
                }
            }
        }
    }

    private int getPrefWidth() {
        Dimension dimension = this.getPreferredSize();
        return dimension != null ? dimension.width : -1;
    }
}

