/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.File;

public class FileEntry {
    private String name = null;
    private Long size = null;
    private Long lastModified = null;
    private File file = null;
    private Integer userNum = null;
    private Object value = null;
    private boolean readOnly = false;
    private boolean sysFile = false;
    private boolean archive = false;
    private boolean dir = false;
    private boolean marked = false;

    public FileEntry() {
    }

    public FileEntry(String string) {
        this();
        this.name = string;
    }

    public File getFile() {
        return this.file;
    }

    public Object getInfo() {
        return this.dir ? "Verzeichnis" : this.size;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public Long getSize() {
        return this.size;
    }

    public Integer getUserNum() {
        return this.userNum;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isDirectory() {
        return this.dir;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSystemFile() {
        return this.sysFile;
    }

    public void setArchive(boolean bl) {
        this.archive = bl;
    }

    public void setDirectory(boolean bl) {
        this.dir = bl;
    }

    public void setFile(File file) {
        this.file = file;
        if (file != null) {
            this.dir = file.isDirectory();
            this.lastModified = file.lastModified();
            this.size = file.length();
        }
    }

    public void setLastModified(Long l) {
        this.lastModified = l;
    }

    public void setLastModified(long l) {
        this.lastModified = l > 0L ? Long.valueOf(l) : null;
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setSize(Long l) {
        this.size = l;
    }

    public void setSystemFile(boolean bl) {
        this.sysFile = bl;
    }

    public void setUserNum(Integer n) {
        this.userNum = n;
    }

    public void setValue(Object object) {
        this.value = object;
    }
}

