/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuThread;
import jkcemu.base.FileSelectDlg;
import jkcemu.base.ObjectByStringComparator;
import jkcemu.base.ReplyDirDlg;
import jkcemu.base.ReplyTextDlg;
import jkcemu.base.ScreenFrm;
import jkcemu.text.TextUtil;

public class EmuUtil {
    public static String[] headersaveFileTypeItems = new String[]{"", "A - Assemblerquelltext", "B - BASIC-Programm", "b - Tiny-BASIC-Programm", "C - MC-Programm, selbststartend", "M - MC-Programm", "E - EPROM-Inhalt", "I - Information (Text)", "T - Text"};
    public static final String[] archiveFileExtensions = new String[]{".jar", ".tar.gz", ".tar", ".tgz", ".zip"};
    public static final String[] textFileExtensions = new String[]{".asc", ".asm", ".bas", ".bat", ".c", ".cc", ".cmd", ".cpp", ".csh", ".h", ".java", ".log", ".sh", ".txt"};
    public static final String PROP_SHOW_PHYS_FILESYS = "jkcemu.show_phys_filesys";
    public static final String PROP_FILEDIALOG = "jkcemu.filedialog";
    public static final String VALUE_FILEDIALOG_NATIVE = "native";
    public static final String VALUE_FILEDIALOG_JKCEMU = "jkcemu";
    public static final String VALUE_FILEDIALOG_SWING = "swing";
    public static final String VALUE_FALSE = Boolean.FALSE.toString();
    public static final String VALUE_TRUE = Boolean.TRUE.toString();
    public static final String TEXT_ON = "ein";
    public static final String TEXT_OFF = "aus";
    public static final String TEXT_DONT_SHOW_MSG_AGAIN = "Diese Meldung zuk\u00fcnftig nicht mehr anzeigen";
    private static DecimalFormat decFmtFix1 = null;
    private static DecimalFormat decFmtMax1 = null;
    private static NumberFormat intFmt = null;
    private static Random random = null;
    private static Map<String, FileFilter> fmt2FileFilter = null;

    public static boolean accept(File file, String ... stringArray) {
        String string;
        boolean bl = false;
        if (file != null && stringArray != null && (string = file.getName()) != null) {
            string = string.toLowerCase();
            for (String string2 : stringArray) {
                if (string2 == null || string2.isEmpty()) continue;
                if (!string2.startsWith(".")) {
                    string2 = "." + string2;
                }
                if (!string.endsWith(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static void addHeadersaveFileTypeItemsTo(JComboBox<String> jComboBox) {
        for (String string : headersaveFileTypeItems) {
            jComboBox.addItem(string);
        }
    }

    public static void appendHTML(StringBuilder stringBuilder, String string) {
        if (string != null) {
            int n = string.length();
            block13: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block13;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block13;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                        continue block13;
                    }
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block13;
                    }
                    case '\u00c4': {
                        stringBuilder.append("&Auml;");
                        continue block13;
                    }
                    case '\u00d6': {
                        stringBuilder.append("&Ouml;");
                        continue block13;
                    }
                    case '\u00dc': {
                        stringBuilder.append("&Uuml;");
                        continue block13;
                    }
                    case '\u00e4': {
                        stringBuilder.append("&auml;");
                        continue block13;
                    }
                    case '\u00f6': {
                        stringBuilder.append("&ouml;");
                        continue block13;
                    }
                    case '\u00fc': {
                        stringBuilder.append("&uuml;");
                        continue block13;
                    }
                    case '\u00df': {
                        stringBuilder.append("&szlig;");
                        continue block13;
                    }
                    default: {
                        if (c < ' ') {
                            stringBuilder.append(' ');
                            continue block13;
                        }
                        if (c > '~') {
                            stringBuilder.append("&#");
                            stringBuilder.append(String.valueOf(c));
                            stringBuilder.append(';');
                            continue block13;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
        }
    }

    public static void appendOnOffText(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(bl ? TEXT_ON : TEXT_OFF);
    }

    public static void appendSizeText(StringBuilder stringBuilder, long l, boolean bl, boolean bl2) {
        DecimalFormat decimalFormat;
        DecimalFormat decimalFormat2 = decimalFormat = bl ? EmuUtil.getDecimalFormatFix1() : EmuUtil.getDecimalFormatMax1();
        if (l >= 0x40000000L) {
            stringBuilder.append(decimalFormat.format((double)l / 1.073741824E9));
            stringBuilder.append(" GByte");
        } else if (l >= 0x100000L) {
            stringBuilder.append(decimalFormat.format((double)l / 1048576.0));
            stringBuilder.append(" MByte");
        } else if (l >= 1024L) {
            stringBuilder.append(decimalFormat.format((double)l / 1024.0));
            stringBuilder.append(" KByte");
        }
        if (stringBuilder.length() > 0) {
            if (bl2) {
                if (l == 1L) {
                    stringBuilder.append("1 Byte");
                } else {
                    stringBuilder.append(" (");
                    stringBuilder.append(EmuUtil.getIntegerFormat().format(l));
                    stringBuilder.append(" Bytes");
                    stringBuilder.append(')');
                }
            }
        } else if (l == 1L) {
            stringBuilder.append("1 Byte");
        } else {
            stringBuilder.append(EmuUtil.getIntegerFormat().format(l));
            stringBuilder.append(" Bytes");
        }
    }

    public static File askForOutputDir(Window window, File file, String string, String string2, String string3) {
        String string4;
        File file2 = null;
        if (file != null && string != null && !string.isEmpty()) {
            string = new File(file, string).getPath();
        }
        if ((string4 = ReplyDirDlg.showReplyDirDlg(window, string2, string3, string)) != null && !string4.isEmpty()) {
            file2 = new File(string4);
            if (file != null && !file2.isAbsolute()) {
                file2 = new File(file, string4);
            }
            if (file2 != null && file2.exists()) {
                if (file2.isDirectory()) {
                    StringBuilder stringBuilder = new StringBuilder(256);
                    stringBuilder.append(file2.getPath());
                    stringBuilder.append("\nexistiert bereits");
                    File[] fileArray = file2.listFiles();
                    if (fileArray != null && fileArray.length > 0) {
                        stringBuilder.append(" und enth\u00e4lt Dateien,\ndie m\u00f6glicherweise \u00fcberschrieben werden");
                    }
                    stringBuilder.append(".\nM\u00f6chten Sie das Verzeichnis verwenden?");
                    if (!BaseDlg.showYesNoDlg(window, stringBuilder.toString())) {
                        file2 = null;
                    }
                } else {
                    BaseDlg.showErrorDlg((Component)window, file2.getPath() + " existiert bereits\n" + "und kann nicht als Verzeichnis angelegt werden.");
                    file2 = null;
                }
            }
        }
        return file2;
    }

    public static File askForOutputDir(Window window, File file, String string, String string2) {
        String string3 = null;
        File file2 = null;
        if (file != null) {
            String string4 = file.getName();
            if (string4 != null && !string4.isEmpty()) {
                int n = string4.lastIndexOf(".");
                string3 = n > 0 ? string4.substring(0, n) : string4 + ".d";
            }
            file2 = file.getParentFile();
        }
        return EmuUtil.askForOutputDir(window, file2, string3, string, string2);
    }

    public static void closeSilent(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int compare(String string, String string2) {
        if (string == null) {
            string = "";
        }
        return string.compareTo(string2 != null ? string2 : "");
    }

    public static Pattern compileFileNameMask(String string) throws PatternSyntaxException {
        int n;
        Pattern pattern = null;
        if (string != null && (n = string.length()) > 0) {
            StringBuilder stringBuilder = new StringBuilder(n + 10);
            block4: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '*': {
                        stringBuilder.append(".*");
                        continue block4;
                    }
                    case '?': {
                        stringBuilder.append('.');
                        continue block4;
                    }
                    default: {
                        if ("\\.[]()^$".indexOf(c) >= 0) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            pattern = Pattern.compile(stringBuilder.toString(), 34);
        }
        return pattern;
    }

    public static File completeFileExtension(File file, FileFilter fileFilter) {
        if (file != null && fileFilter != null && fileFilter instanceof FileNameExtensionFilter) {
            String[] stringArray = ((FileNameExtensionFilter)fileFilter).getExtensions();
            String string = file.getName();
            if (stringArray != null && string != null) {
                int n = string.indexOf(46);
                if (stringArray.length == 1 && (n < 0 || n == string.length() - 1)) {
                    if (n < 0) {
                        string = string + ".";
                    }
                    string = string + stringArray[0];
                    File file2 = file.getParentFile();
                    file = file2 != null ? new File(file2, string) : new File(string);
                }
            }
        }
        return file;
    }

    public static boolean confirmFileOverwrite(Component component, File file) {
        boolean bl = false;
        if (file != null) {
            bl = file.exists() ? BaseDlg.showYesNoWarningDlg(component, "Die Datei '" + file.getName() + "' existiert bereits.\n" + "M\u00f6chten Sie die Datei \u00fcberschreiben?", "Best\u00e4tigung") : true;
        }
        return bl;
    }

    public static void copyToClipboard(Component component, String string) {
        try {
            Clipboard clipboard;
            Toolkit toolkit;
            if (string != null && !string.isEmpty() && (toolkit = component.getToolkit()) != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static File createDir(Component component, File file) {
        String string;
        File file2 = null;
        if (file != null && (string = ReplyTextDlg.showReplyTextDlg(component, "Verzeichnisname:", "Verzeichnis erstellen", null)) != null && (string = string.trim()).length() > 0) {
            File file3 = new File(string);
            if (!file3.isAbsolute()) {
                file3 = new File(file, string);
            }
            if (file3.mkdirs()) {
                file2 = file3;
            } else {
                BaseDlg.showErrorDlg(component, "Verzeichnis konnte nicht erstellt werden.");
            }
        }
        return file2;
    }

    public static JButton createImageButton(Window window, String string, String string2) {
        JButton jButton = null;
        Image image = Main.getImage(window, string);
        if (image != null) {
            jButton = new JButton(new ImageIcon(image));
            jButton.setToolTipText(string2);
        } else {
            jButton = new JButton(string2);
        }
        return jButton;
    }

    public static InputStream createInputStream(final RandomAccessFile randomAccessFile) {
        return new InputStream(){

            @Override
            public void close() throws IOException {
                randomAccessFile.close();
            }

            @Override
            public int read() throws IOException {
                return randomAccessFile.read();
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return randomAccessFile.read(byArray);
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                return randomAccessFile.read(byArray, n, n2);
            }

            @Override
            public long skip(long l) throws IOException {
                long l2 = 0L;
                if (l > Integer.MAX_VALUE) {
                    long l3;
                    long l4 = randomAccessFile.getFilePointer();
                    if (l4 + l > (l3 = randomAccessFile.length())) {
                        randomAccessFile.seek(l3);
                        l2 = l3 - l4;
                    } else {
                        randomAccessFile.seek(l4 + l);
                        l2 = l;
                    }
                } else {
                    l2 = randomAccessFile.skipBytes((int)l);
                }
                return l2;
            }
        };
    }

    public static OutputStream createOptionalGZipOutputStream(File file) throws IOException {
        boolean bl = EmuUtil.isGZipFile(file);
        OutputStream outputStream = new FileOutputStream(file);
        if (bl) {
            try {
                outputStream = new GZIPOutputStream(outputStream);
            }
            catch (IOException iOException) {
                EmuUtil.closeSilent(outputStream);
                throw iOException;
            }
        }
        return outputStream;
    }

    public static Set<Path> createPathSet() {
        return new TreeSet<Path>(EmuUtil.createPathComparator());
    }

    public static boolean equals(File file, File file2) {
        boolean bl = false;
        if (file != null && file2 != null) {
            bl = TextUtil.equals(file.getPath(), file2.getPath());
        } else if (file == null && file2 == null) {
            bl = true;
        }
        return bl;
    }

    public static boolean equalsLookAndFeel(String string) {
        LookAndFeel lookAndFeel;
        boolean bl = false;
        if (string != null && string.length() > 0 && (lookAndFeel = UIManager.getLookAndFeel()) != null) {
            bl = string.equals(lookAndFeel.getClass().getName());
        }
        return bl;
    }

    public static boolean equalsRegion(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        boolean bl = false;
        if (byArray != null && byArray2 != null && n >= 0 && n2 >= 0 && n + n3 <= byArray.length && n2 + n3 <= byArray2.length) {
            bl = true;
            for (int i = 0; i < n3; ++i) {
                if (byArray[n++] == byArray2[n2++]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitSysError(Component component, String string, Exception exception) {
        Object object;
        ScreenFrm screenFrm = Main.getScreenFrm();
        if (screenFrm != null && (object = screenFrm.getEmuThread()) != null) {
            ((EmuThread)object).stopEmulator();
        }
        object = null;
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("Es ist ein interner Applikationsfehler aufgetreten.");
        try (PrintWriter printWriter = null;){
            Properties properties;
            String string2 = "jkcemu_err.log";
            File file = EmuUtil.getHomeDirFile();
            object = file != null ? new File(file, string2) : new File(string2);
            printWriter = new PrintWriter(new FileWriter((File)object));
            printWriter.println("Bitte senden Sie diese Datei an info@jens-mueller.org");
            printWriter.println("Please send this file to info@jens-mueller.org");
            printWriter.println();
            printWriter.println("--- Program ---");
            printWriter.write("JKCEMU Version 0.9.7");
            printWriter.println();
            if (string != null) {
                printWriter.println();
                printWriter.println("--- Fehlermeldung ---");
                printWriter.println(string);
                printWriter.println();
            }
            if (exception != null) {
                printWriter.println();
                printWriter.println("--- Stack Trace ---");
                exception.printStackTrace(printWriter);
                printWriter.println();
            }
            if ((properties = System.getProperties()) != null) {
                printWriter.println();
                printWriter.println("--- Properties ---");
                properties.list(printWriter);
                printWriter.println();
            }
            if (printWriter.checkError()) {
                object = null;
            }
            printWriter.close();
            printWriter = null;
        }
        if (object != null) {
            stringBuilder.append("\nEin Protokoll des Fehlers wurde in die Textdatei\n'");
            stringBuilder.append(((File)object).getPath());
            stringBuilder.append("' geschrieben.\nBitte senden Sie diese Textdatei");
        } else {
            stringBuilder.append("\nBitte melden Sie diesen Fehler");
        }
        stringBuilder.append(" einschlie\u00dflich einer\nkurzen Beschreibung Ihrer letzten Aktionen per E-Mail an:\ninfo@jens-mueller.org\n\nVielen Dank!");
        BaseDlg.showErrorDlg(component != null ? component : new Frame(), stringBuilder.toString(), "Applikationsfehler");
        Main.exitFailure();
    }

    public static int[] extractAddressesFromFileName(String string) {
        int[] nArray = null;
        if (string != null) {
            long l = 0L;
            int n = 0;
            int n2 = string.length();
            int n3 = string.indexOf(95);
            while (n < 3 && n3 >= 0 && n3 + 4 < n2) {
                long l2 = EmuUtil.getHex4(string, ++n3);
                if (n3 + 4 < n2 && EmuUtil.isHexChar(string.charAt(n3 + 4))) {
                    l2 = -1L;
                }
                if (l2 >= 0L) {
                    l = l << 16 | l2;
                    ++n;
                    n3 += 4;
                }
                if (n3 >= n2) break;
                n3 = string.indexOf(95, n3);
            }
            if (n > 0) {
                nArray = new int[n];
                for (int i = n - 1; i >= 0; --i) {
                    nArray[i] = (int)(l & 0xFFFFL);
                    l >>= 16;
                }
            }
        }
        return nArray;
    }

    public static String extractSingleAsciiLine(byte[] byArray, int n, int n2) {
        String string = null;
        if (byArray != null) {
            int n3;
            StringBuilder stringBuilder = null;
            int n4 = 0;
            for (int i = n2; n < byArray.length && i > 0 && (n3 = byArray[n++] & 0xFF) != 0 && n3 != 13 && n3 != 10; --i) {
                if (n3 <= 32) {
                    ++n4;
                    continue;
                }
                if (n3 > 126) {
                    n3 = 95;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2);
                } else {
                    for (int j = 0; j < n4; ++j) {
                        stringBuilder.append(' ');
                    }
                }
                stringBuilder.append((char)n3);
                n4 = 0;
            }
            if (stringBuilder != null) {
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    public static File fileDrop(Component component, DropTargetDropEvent dropTargetDropEvent) {
        File file = null;
        if (EmuUtil.isFileDrop(dropTargetDropEvent)) {
            block7: {
                dropTargetDropEvent.acceptDrop(1);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable != null) {
                    try {
                        Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        if (object == null || !(object instanceof Collection)) break block7;
                        for (Object e : (Collection)object) {
                            if (e == null || !(e instanceof File)) continue;
                            if (file == null) {
                                file = (File)e;
                                continue;
                            }
                            BaseDlg.showErrorDlg(component, "Bitte nur eine Datei hier hineinziehen!");
                            file = null;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            dropTargetDropEvent.dropComplete(file != null);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        return file;
    }

    public static void fillRandom(byte[] byArray, int n) {
        if (byArray != null) {
            Random random = EmuUtil.getRandom();
            for (int i = n; i < byArray.length; ++i) {
                byArray[i] = (byte)(random.nextInt() & 0xFF);
            }
        }
    }

    public static void fireSelectRow(final JList jList, final Object object) {
        if (object != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jList.setSelectedValue(object, true);
                }
            });
        }
    }

    public static void fireSelectRow(final JList jList, final int n) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jList.setSelectedIndex(n);
            }
        });
    }

    public static void fireSelectRow(final JTable jTable, final int n) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (n >= 0 && n < jTable.getRowCount()) {
                    jTable.clearSelection();
                    jTable.setRowSelectionInterval(n, n);
                }
            }
        });
    }

    public static void fireSelectRows(final JList jList, final int[] nArray) {
        if (nArray != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        jList.setSelectedIndices(nArray);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public static void fireShowError(final Component component, final String string, final Exception exception) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseDlg.showErrorDlg(component, string, exception);
            }
        });
    }

    public static void fireShowInfo(final Component component, final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseDlg.showInfoDlg(component, string);
            }
        });
    }

    public static String formatInt(int n) {
        return EmuUtil.getIntegerFormat().format(n);
    }

    public static String formatSize(long l, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        EmuUtil.appendSizeText(stringBuilder, l, bl, bl2);
        return stringBuilder.toString();
    }

    public static void frameToFront(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                EmuUtil.showFrame((Frame)component);
                break;
            }
            component = component.getParent();
        }
    }

    public static int getBasicMemWord(EmuMemView emuMemView, int n) {
        return emuMemView.getBasicMemByte(n + 1) << 8 | emuMemView.getBasicMemByte(n);
    }

    public static boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        String string2;
        boolean bl2 = bl;
        if (properties != null && (string2 = properties.getProperty(string)) != null) {
            if ((string2 = string2.trim()).equals("1") || string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase(VALUE_TRUE) || Boolean.parseBoolean(string2)) {
                bl2 = true;
            }
            if (string2.equals("0") || string2.equals("N") || string2.equals(VALUE_FALSE)) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static String getClipboardText(Component component) {
        String string = null;
        try {
            Object object;
            Clipboard clipboard;
            Toolkit toolkit = component.getToolkit();
            if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null && clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) && (object = clipboard.getData(DataFlavor.stringFlavor)) != null && (string = object.toString()) != null && string.isEmpty()) {
                string = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static DecimalFormat getDecimalFormatFix1() {
        if (decFmtFix1 == null) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            decFmtFix1 = numberFormat instanceof DecimalFormat ? (DecimalFormat)numberFormat : new DecimalFormat();
            decFmtFix1.applyPattern("###,##0.0");
        }
        return decFmtFix1;
    }

    public static DecimalFormat getDecimalFormatMax1() {
        if (decFmtMax1 == null) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            decFmtMax1 = numberFormat instanceof DecimalFormat ? (DecimalFormat)numberFormat : new DecimalFormat();
            decFmtMax1.setMaximumFractionDigits(1);
        }
        return decFmtMax1;
    }

    public static File getDestFile(File file, String string, File file2) {
        File file3 = null;
        if (file != null) {
            int n;
            String string2;
            if (file2 != null && !file2.isDirectory()) {
                file2 = file2.getParentFile();
            }
            if (file2 == null) {
                file2 = file.getParentFile();
            }
            if ((string2 = file.getName()) != null && (n = string2.lastIndexOf(46)) > 0) {
                string2 = string2.substring(0, n) + string;
                file3 = file2 != null ? new File(file2, string2) : new File(string2);
            }
        }
        return file3;
    }

    public static FileSystemView getDifferentLogicalFileSystemView() {
        FileSystemView fileSystemView = null;
        FileSystemView fileSystemView2 = FileSystemView.getFileSystemView();
        if (fileSystemView2 != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (File file : fileSystemView2.getRoots()) {
                treeSet.add(file.getPath());
            }
            for (File file : File.listRoots()) {
                treeSet2.add(file.getPath());
            }
            if (!((Object)treeSet).equals(treeSet2)) {
                fileSystemView = fileSystemView2;
            }
        }
        return fileSystemView;
    }

    public static int getHex4(String string, int n) {
        int n2 = -1;
        if (string != null && n + 3 < string.length()) {
            boolean bl = true;
            int n3 = 0;
            for (int i = 0; i < 4; ++i) {
                char c = string.charAt(n + i);
                if (c >= '0' && c <= '9') {
                    n3 = n3 << 4 | c - 48;
                    continue;
                }
                if (c >= 'A' && c <= 'F') {
                    n3 = n3 << 4 | c - 65 + 10;
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    n3 = n3 << 4 | c - 97 + 10;
                    continue;
                }
                bl = false;
                break;
            }
            if (bl) {
                n2 = n3;
            }
        }
        return n2;
    }

    public static File getHomeDirFile() {
        String string;
        File file = null;
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (fileSystemView != null) {
            file = fileSystemView.getHomeDirectory();
        }
        if (file == null && (string = System.getProperty("user.home")) != null) {
            file = new File(string);
        }
        return file;
    }

    public static float getFloat(JSpinner jSpinner) {
        float f = 0.0f;
        Object object = jSpinner.getValue();
        if (object != null && object instanceof Number) {
            f = ((Number)object).floatValue();
        }
        return f;
    }

    public static int getInt(JComboBox jComboBox) {
        int n = 0;
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            if (object instanceof Number) {
                n = ((Number)object).intValue();
            } else {
                String string = object.toString();
                if (string != null) {
                    try {
                        n = Integer.parseInt(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return n;
    }

    public static int getInt(JSpinner jSpinner) {
        int n = 0;
        Object object = jSpinner.getValue();
        if (object != null && object instanceof Number) {
            n = ((Number)object).intValue();
        }
        return n;
    }

    public static NumberFormat getIntegerFormat() {
        if (intFmt == null) {
            intFmt = NumberFormat.getIntegerInstance();
            intFmt.setGroupingUsed(true);
        }
        return intFmt;
    }

    public static int getIntProperty(Properties properties, String string, int n) {
        String string2;
        int n2 = n;
        if (properties != null && (string2 = properties.getProperty(string)) != null && !(string2 = string2.trim()).isEmpty()) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static char getHexChar(int n) {
        return (n &= 0xF) <= 9 ? (char)(n + 48) : (char)(n - 10 + 65);
    }

    public static FileFilter getAC1Basic6FileFilter() {
        return EmuUtil.getFileFilter("AC1-BASIC6-Dateien (*.abc)", "abc");
    }

    public static FileFilter getAnaDiskFileFilter() {
        return EmuUtil.getFileFilter("AnaDisk-Dateien (*.dump)", "dump");
    }

    public static FileFilter getBasicFileFilter() {
        return EmuUtil.getFileFilter("BASIC-/RBASIC-Dateien (*.bas)", "bas");
    }

    public static FileFilter getBinaryFileFilter() {
        return EmuUtil.getFileFilter("Einfache Speicherabbilddateien (*.bin)", "bin");
    }

    public static FileFilter getCdtFileFilter() {
        return EmuUtil.getFileFilter("CPC-Tape-Dateien (*.cdt)", "cdt");
    }

    public static FileFilter getCswFileFilter() {
        return EmuUtil.getFileFilter("CSW-Dateien (*.csw)", "csw");
    }

    public static FileFilter getComFileFilter() {
        return EmuUtil.getFileFilter("CP/M-Programmdateien (*.com)", "com");
    }

    public static FileFilter getCopyQMFileFilter() {
        return EmuUtil.getFileFilter("CopyQM-Dateien (*.cqm; *.qm)", "cqm", "qm");
    }

    public static FileFilter getDskFileFilter() {
        return EmuUtil.getFileFilter("CPC-Disk-Dateien (*.dsk)", "dsk");
    }

    public static FileFilter getGIFFileFilter() {
        return EmuUtil.getFileFilter("GIF-Dateien (*.gif)", "gif");
    }

    public static FileFilter getHeadersaveFileFilter() {
        return EmuUtil.getFileFilter("Headersave-Dateien (*.z80)", "z80");
    }

    public static FileFilter getHexFileFilter() {
        return EmuUtil.getFileFilter("HEX-Dateien (*.hex)", "hex");
    }

    public static FileFilter getImageDiskFileFilter() {
        return EmuUtil.getFileFilter("ImageDisk-Dateien (*.imd)", "imd");
    }

    public static FileFilter getISOFileFilter() {
        return EmuUtil.getFileFilter("CD-/DVD-Abbilddateien (*.iso)", "iso");
    }

    public static FileFilter getKCBasicFileFilter() {
        return EmuUtil.getFileFilter("KC-BASIC-Dateien (*.sss)", "sss");
    }

    public static FileFilter getKCBasicSystemFileFilter() {
        return EmuUtil.getFileFilter("KC-BASIC-Systemdateien (*.kcb)", "kcb");
    }

    public static FileFilter getKCSystemFileFilter() {
        return EmuUtil.getFileFilter("KC-Systemdateien (*.kcc)", "kcc");
    }

    public static FileFilter getKCTapFileFilter() {
        return EmuUtil.getFileFilter("KC-TAP-Dateien (*.tap)", "tap");
    }

    public static FileFilter getPlainDiskFileFilter() {
        return EmuUtil.getFileFilter("Einfache Abbilddateien (*.img; *.image, *.raw)", "img", "image", "raw");
    }

    public static FileFilter getProjectFileFilter() {
        return EmuUtil.getFileFilter("Projekdateien (*.prj)", "prj");
    }

    public static synchronized Random getRandom() {
        if (random == null) {
            random = new Random();
            random.setSeed(System.currentTimeMillis());
        }
        return random;
    }

    public static FileFilter getRMCFileFilter() {
        return EmuUtil.getFileFilter("RBASIC-Maschinencodedateien (*.rmc)", "rmc");
    }

    public static FileFilter getROMFileFilter() {
        return EmuUtil.getFileFilter("ROM-Dateien (*.bin; *.rom)", "rom", "bin");
    }

    public static FileFilter getTapeFileFilter() {
        return EmuUtil.getFileFilter("Tape-Dateien (*.cdt; *.csw; *.tap; *.tzx)", "cdt", "csw", "tap", "tzx");
    }

    public static FileFilter getTeleDiskFileFilter() {
        return EmuUtil.getFileFilter("TeleDisk-Dateien (*.td0)", "td0");
    }

    public static FileFilter getTextFileFilter() {
        return EmuUtil.getFileFilter("Textdateien (*.asc; *.log; *.txt)", "asc", "log", "txt");
    }

    public static FileFilter getTzxFileFilter() {
        return EmuUtil.getFileFilter("ZX-Tape-Dateien (*.tzx)", "tzx");
    }

    public static File getDirectory(File file) {
        if (file != null) {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            while (file != null && !file.isDirectory()) {
                if (fileSystemView != null) {
                    file = fileSystemView.getParentDirectory(file);
                    continue;
                }
                file = file.getParentFile();
            }
        }
        return file;
    }

    public static int getInt2BE(byte[] byArray, int n) {
        int n2 = -1;
        if (byArray != null && n >= 0 && n + 1 < byArray.length) {
            n2 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
        }
        return n2;
    }

    public static long getInt4BE(byte[] byArray, int n) {
        long l = -1L;
        if (byArray != null && n >= 0 && n + 3 < byArray.length) {
            l = 0L;
            for (int i = 0; i < 4; ++i) {
                l <<= 8;
                l |= (long)(byArray[n++] & 0xFF);
            }
        }
        return l;
    }

    public static long getInt4LE(byte[] byArray, int n) {
        long l = -1L;
        if (byArray != null && n >= 0 && n + 3 < byArray.length) {
            l = byArray[n + 3] << 24 & 0xFF000000 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
        }
        return l;
    }

    public static String getProperty(Properties properties, String string) {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 != null) {
            if (string2.trim().isEmpty()) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    public static Window getWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static int getWord(byte[] byArray, int n) {
        int n2 = -1;
        if (byArray != null && n >= 0 && n + 1 < byArray.length) {
            n2 = byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
        }
        return n2;
    }

    public static boolean isGZipFile(File file) {
        String string;
        boolean bl = false;
        if (file != null && (string = file.getName()) != null && string.toLowerCase().endsWith(".gz")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isFileDrop(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = false;
        if ((dropTargetDragEvent.getDropAction() & 0x40000003) != 0) {
            bl = dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }
        return bl;
    }

    public static boolean isFileDrop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        if ((dropTargetDropEvent.getDropAction() & 0x40000003) != 0) {
            bl = dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }
        return bl;
    }

    public static boolean isHexChar(int n) {
        return n >= 48 && n <= 57 || n >= 65 && n <= 70 || n >= 97 && n <= 102;
    }

    public static boolean isJKCEMUFileDialogSelected() {
        String string = Main.getProperty(PROP_FILEDIALOG);
        return !TextUtil.equalsIgnoreCase(string, VALUE_FILEDIALOG_NATIVE) && !TextUtil.equalsIgnoreCase(string, VALUE_FILEDIALOG_SWING);
    }

    public static boolean isTextAt(CharSequence charSequence, byte[] byArray, int n) {
        int n2;
        boolean bl = false;
        if (charSequence != null && byArray != null && n + (n2 = charSequence.length()) <= byArray.length) {
            bl = true;
            for (int i = 0; i < n2; ++i) {
                if (((char)byArray[n + i] & 0xFF) == charSequence.charAt(i)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static FileLock lockFile(File file, RandomAccessFile randomAccessFile) throws IOException {
        FileLock fileLock = null;
        FileChannel fileChannel = randomAccessFile.getChannel();
        if (fileChannel != null) {
            try {
                fileLock = fileChannel.tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                throw new IOException(file.getPath() + ":\nDatei ist gesperrt.\n" + "Bitte schlie\u00dfen Sie die Datei in dem Programm,\n" + "in dem sie ge\u00f6ffnet ist.");
            }
            catch (IOException iOException) {
                throw new IOException(file.getPath() + ":\nDatei kann nicht gesperrt werden.");
            }
        }
        return fileLock;
    }

    public static BufferedInputStream openBufferedOptionalGZipFile(File file) throws IOException {
        InputStream inputStream = null;
        if (EmuUtil.isGZipFile(file)) {
            inputStream = new FileInputStream(file);
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                EmuUtil.closeSilent(inputStream);
                inputStream = null;
            }
        }
        if (inputStream == null) {
            inputStream = new FileInputStream(file);
        }
        return new BufferedInputStream(inputStream);
    }

    public static void printErr(String string) {
        if (Main.consoleWriter != null) {
            Main.consoleWriter.print(string);
            Main.consoleWriter.flush();
        } else {
            System.err.print(string);
        }
    }

    public static void printOut(String string) {
        if (Main.consoleWriter != null) {
            Main.consoleWriter.print(string);
            Main.consoleWriter.flush();
        } else {
            System.out.print(string);
        }
    }

    public static void printlnErr() {
        if (Main.consoleWriter != null) {
            Main.consoleWriter.println();
            Main.consoleWriter.flush();
        } else {
            System.err.println();
        }
    }

    public static void printlnOut() {
        if (Main.consoleWriter != null) {
            Main.consoleWriter.println();
            Main.consoleWriter.flush();
        } else {
            System.out.println();
        }
    }

    public static void printlnErr(String string) {
        if (Main.consoleWriter != null) {
            Main.consoleWriter.println(string);
            Main.consoleWriter.flush();
        } else {
            System.err.println(string);
        }
    }

    public static void printlnOut(String string) {
        if (Main.consoleWriter != null) {
            Main.consoleWriter.println(string);
            Main.consoleWriter.flush();
        } else {
            System.out.println(string);
        }
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length && (n = inputStream.read(byArray, n3, byArray.length - n3)) > 0) {
            n3 += n;
            n2 += n;
        }
        return n2;
    }

    public static byte[] readFile(File file, boolean bl) throws IOException {
        return EmuUtil.readFile(file, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file, boolean bl, int n) throws IOException {
        byte[] byArray = null;
        if (file != null) {
            InputStream inputStream;
            block9: {
                long l = -1L;
                inputStream = null;
                try {
                    if (bl && EmuUtil.isGZipFile(file)) {
                        inputStream = new GZIPInputStream(new FileInputStream(file));
                    } else {
                        l = file.length();
                        inputStream = new FileInputStream(file);
                    }
                    if (l > 0L) {
                        int n2;
                        if (n < 1) {
                            n = Integer.MAX_VALUE;
                        }
                        byArray = new byte[(int)Math.min(l, (long)n)];
                        if (l > 0L && (n2 = EmuUtil.read(inputStream, byArray)) > 0 && n2 < byArray.length) {
                            byArray = Arrays.copyOf(byArray, n2);
                        }
                        break block9;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
                    int n3 = inputStream.read();
                    while (n3 != -1 && n != 0) {
                        byteArrayOutputStream.write(n3);
                        n3 = inputStream.read();
                        --n;
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(inputStream);
                    throw throwable;
                }
            }
            EmuUtil.closeSilent(inputStream);
        }
        return byArray;
    }

    public static byte[] readFile(Component component, String string, boolean bl, int n, String string2) {
        byte[] byArray = null;
        if (string != null && !string.isEmpty()) {
            try {
                byArray = EmuUtil.readFile(new File(string), bl, n);
            }
            catch (IOException iOException) {
                String string3 = iOException.getMessage();
                BaseDlg.showErrorDlg(component, String.format("%s kann nicht geladen werden%s%s", string2, string3 != null ? ":\n" : ".", string3 != null ? string3 : ""));
                byArray = null;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readResource(Component component, String string) {
        IOException iOException;
        InputStream inputStream;
        InputStream inputStream2;
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream;
        block7: {
            byteArrayOutputStream = new ByteArrayOutputStream(2048);
            bl = false;
            inputStream2 = null;
            inputStream = null;
            iOException = null;
            try {
                inputStream = component.getClass().getResourceAsStream(string);
                if (inputStream == null) break block7;
                if (string.endsWith(".gz")) {
                    inputStream2 = inputStream;
                    inputStream = new GZIPInputStream(inputStream);
                }
                int n = inputStream.read();
                while (n != -1) {
                    byteArrayOutputStream.write(n);
                    n = inputStream.read();
                }
                bl = true;
            }
            catch (IOException iOException2) {
                try {
                    iOException = iOException2;
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(inputStream);
                    EmuUtil.closeSilent(inputStream2);
                    throw throwable;
                }
                EmuUtil.closeSilent(inputStream);
                EmuUtil.closeSilent(inputStream2);
            }
        }
        EmuUtil.closeSilent(inputStream);
        EmuUtil.closeSilent(inputStream2);
        if (!bl) {
            EmuUtil.exitSysError(component, String.format("Resource %s kann nicht geladen werden", string), iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void releaseSilent(FileLock fileLock) {
        if (fileLock != null) {
            try {
                fileLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static File renameFile(Component component, File file) {
        File file2 = null;
        if (file != null) {
            try {
                Path path = EmuUtil.renamePath(component, file.toPath());
                if (path != null) {
                    try {
                        file2 = path.toFile();
                    }
                    catch (InvalidPathException invalidPathException) {}
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                BaseDlg.showErrorDlg(component, "Umbenennen der Datei wird nicht unterst\u00fctzt.");
            }
        }
        return file2;
    }

    public static Path renamePath(Component component, Path path) {
        Path path2 = null;
        if (path != null) {
            String string = null;
            Path path3 = path.getFileName();
            if (path3 != null) {
                string = path3.toString();
            }
            String string2 = "Datei umbenennen";
            String string3 = "Die Datei";
            if (Files.isSymbolicLink(path)) {
                string2 = "Symbolischer Link umbenennen";
                string3 = "Der symbolische Link";
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                string2 = "Verzeichnis umbenennen";
                string3 = "Das Verzeichnis";
            }
            String string4 = ReplyTextDlg.showReplyTextDlg(component, "Neuer Name:", string2, string != null ? string : "");
            if (string4 != null) {
                try {
                    path2 = Files.move(path, path.resolveSibling(string4), new CopyOption[0]);
                }
                catch (Exception exception) {
                    BaseDlg.showErrorDlg(component, exception);
                }
            }
        }
        return path2;
    }

    public static void setFileWritable(File file, boolean bl) {
        if (file != null && file.setWritable(bl, false)) {
            file.setWritable(bl, true);
        }
    }

    public static void setProperty(Properties properties, String string, Object object) {
        if (properties != null) {
            String string2 = object != null ? object.toString() : null;
            properties.setProperty(string, string2 != null ? string2 : "");
        }
    }

    public static void setProperty(Properties properties, String string, boolean bl) {
        if (properties != null) {
            properties.setProperty(string, Boolean.toString(bl));
        }
    }

    public static boolean setSelectedHeadersaveFileTypeItem(JComboBox jComboBox, int n) {
        boolean bl = false;
        for (String string : headersaveFileTypeItems) {
            if (string.isEmpty() || string.charAt(0) != n) continue;
            jComboBox.setSelectedItem(string);
            bl = true;
            break;
        }
        return bl;
    }

    public static void setTableColWidths(JTable jTable, int ... nArray) {
        TableColumnModel tableColumnModel;
        if (jTable != null && nArray != null && (tableColumnModel = jTable.getColumnModel()) != null) {
            int n = Math.min(tableColumnModel.getColumnCount(), nArray.length);
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (tableColumn == null) continue;
                tableColumn.setPreferredWidth(nArray[i]);
            }
        }
    }

    public static void setValue(JSpinner jSpinner, int n) {
        try {
            jSpinner.setValue(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EmuUtil.exitSysError(null, null, illegalArgumentException);
        }
    }

    public static File showFileOpenDlg(Window window, String string, File file, FileFilter ... fileFilterArray) {
        file = EmuUtil.getDirectory(file);
        File file2 = null;
        if (EmuUtil.isJKCEMUFileDialogSelected()) {
            FileSelectDlg fileSelectDlg = new FileSelectDlg(window, FileSelectDlg.Mode.LOAD, false, false, string, file, fileFilterArray);
            fileSelectDlg.setVisible(true);
            file2 = fileSelectDlg.getSelectedFile();
        } else {
            File[] fileArray = null;
            fileArray = EmuUtil.isSwingFileDialogSelected() ? EmuUtil.showSwingFileDlg(window, false, false, string, file, fileFilterArray) : EmuUtil.showNativeFileDlg(window, false, false, string, file);
            if (fileArray != null && fileArray.length > 0) {
                file2 = fileArray[0];
            }
        }
        return file2;
    }

    public static void showFrame(final Frame frame) {
        if (frame != null) {
            if (frame.isVisible()) {
                int n = frame.getExtendedState();
                if ((n & 1) != 0) {
                    frame.setExtendedState(n & 0xFFFFFFFE);
                }
            } else {
                frame.setVisible(true);
                frame.setExtendedState(0);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.toFront();
                }
            });
        }
    }

    public static File showFileSaveDlg(Window window, String string, File file, FileFilter ... fileFilterArray) {
        File file2 = null;
        if (EmuUtil.isJKCEMUFileDialogSelected()) {
            FileSelectDlg fileSelectDlg = new FileSelectDlg(window, FileSelectDlg.Mode.SAVE, false, false, string, file, fileFilterArray);
            fileSelectDlg.setVisible(true);
            file2 = fileSelectDlg.getSelectedFile();
        } else {
            File[] fileArray = null;
            fileArray = EmuUtil.isSwingFileDialogSelected() ? EmuUtil.showSwingFileDlg(window, true, false, string, file, fileFilterArray) : EmuUtil.showNativeFileDlg(window, true, false, string, file);
            if (fileArray != null && fileArray.length > 0) {
                file2 = fileArray[0];
            }
        }
        return file2;
    }

    public static List<File> showMultiFileOpenDlg(Window window, String string, File file, FileFilter ... fileFilterArray) {
        List<File> list = null;
        file = EmuUtil.getDirectory(file);
        if (EmuUtil.isJKCEMUFileDialogSelected()) {
            FileSelectDlg fileSelectDlg = new FileSelectDlg(window, FileSelectDlg.Mode.MULTIPLE_LOAD, false, false, string, file, fileFilterArray);
            fileSelectDlg.setVisible(true);
            list = fileSelectDlg.getSelectedFiles();
        } else {
            File[] fileArray = null;
            fileArray = EmuUtil.isSwingFileDialogSelected() ? EmuUtil.showSwingFileDlg(window, false, true, string, file, fileFilterArray) : EmuUtil.showNativeFileDlg(window, false, true, string, file);
            if (fileArray != null && fileArray.length > 0) {
                list = Arrays.asList(fileArray);
            }
        }
        return list;
    }

    public static void sortFilesByName(File[] fileArray) {
        if (fileArray != null) {
            try {
                Arrays.sort(fileArray, File.separatorChar == '/' ? ObjectByStringComparator.getInstance() : ObjectByStringComparator.getIgnoreCaseInstance());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public static void stopCellEditing(JTable jTable) {
        TableCellEditor tableCellEditor;
        if (jTable != null && (tableCellEditor = jTable.getCellEditor()) != null && tableCellEditor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)tableCellEditor).stopCellEditing();
        }
    }

    public static void throwMysteriousData() throws IOException {
        throw new IOException("Datei enth\u00e4lt mysteri\u00f6se Daten.");
    }

    public static void throwUnsupportedFileFormat() throws IOException {
        throw new IOException("Das Dateiformat nicht unterst\u00fctzt\noder die Datei ist besch\u00e4digt.");
    }

    public static void writeASCII(OutputStream outputStream, CharSequence charSequence) throws IOException {
        if (charSequence != null) {
            EmuUtil.checkASCII(charSequence);
            int n = charSequence.length();
            for (int i = 0; i < n; ++i) {
                outputStream.write(charSequence.charAt(i));
            }
        }
    }

    public static void writeFixLengthASCII(OutputStream outputStream, CharSequence charSequence, int n, int n2) throws IOException {
        if (charSequence != null) {
            EmuUtil.checkASCII(charSequence);
            int n3 = charSequence.length();
            int n4 = 0;
            while (n > 0 && n4 < n3) {
                outputStream.write(charSequence.charAt(n4++));
                --n;
            }
        }
        while (n > 0) {
            outputStream.write(0);
            --n;
        }
    }

    public static void writeInt2BE(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public static void writeInt2LE(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
    }

    public static void writeInt4BE(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(l >> 24 & 0xFFL));
        outputStream.write((int)(l >> 16 & 0xFFL));
        outputStream.write((int)(l >> 8 & 0xFFL));
        outputStream.write((int)(l & 0xFFL));
    }

    public static void writeInt4LE(OutputStream outputStream, long l) throws IOException {
        EmuUtil.writeInt2LE(outputStream, (int)l);
        EmuUtil.writeInt2LE(outputStream, (int)(l >> 16));
    }

    private static void checkASCII(CharSequence charSequence) throws CharConversionException {
        if (charSequence != null) {
            int n = charSequence.length();
            for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                if (c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\u001a') continue;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Nicht-ASCII-Zeichen");
                if (!(c <= ' ' || Character.isSpaceChar(c) || Character.isWhitespace(c) || Character.isISOControl(c))) {
                    stringBuilder.append(" '");
                    stringBuilder.append(c);
                    stringBuilder.append('\'');
                }
                stringBuilder.append(" im Text enthalten");
                if (n > 1) {
                    stringBuilder.append("\n\nText:\n");
                    stringBuilder.append(charSequence);
                }
                throw new CharConversionException(stringBuilder.toString());
            }
        }
    }

    private static Comparator<Path> createPathComparator() {
        return new Comparator<Path>(){

            @Override
            public int compare(Path path, Path path2) {
                String string;
                String string2 = path != null ? path.toString() : null;
                String string3 = string = path2 != null ? path2.toString() : null;
                if (string2 == null) {
                    string2 = "";
                }
                return string2.compareTo(string != null ? string : "");
            }
        };
    }

    private static FileFilter getFileFilter(String string, String ... stringArray) {
        FileFilter fileFilter = null;
        if (stringArray != null && string != null && stringArray.length > 0) {
            if (fmt2FileFilter == null) {
                fmt2FileFilter = new HashMap<String, FileFilter>();
            }
            if ((fileFilter = fmt2FileFilter.get(string)) == null) {
                fileFilter = new FileNameExtensionFilter(string, stringArray);
                fmt2FileFilter.put(string, fileFilter);
            }
        }
        return fileFilter;
    }

    private static boolean isSwingFileDialogSelected() {
        return TextUtil.equalsIgnoreCase(Main.getProperty(PROP_FILEDIALOG), VALUE_FILEDIALOG_SWING);
    }

    private static File[] showNativeFileDlg(Window window, boolean bl, boolean bl2, String string, File file) {
        File[] fileArray = null;
        Dialog dialog = null;
        Frame frame = null;
        while (window != null) {
            if (window instanceof Dialog) {
                dialog = (Dialog)window;
                break;
            }
            if (window instanceof Frame) {
                frame = (Frame)window;
                break;
            }
            window = window.getOwner();
        }
        Dialog dialog2 = null;
        if (dialog != null) {
            dialog2 = new FileDialog(dialog, string, bl ? 1 : 0);
        } else if (frame != null) {
            dialog2 = new FileDialog(frame, string, bl ? 1 : 0);
        }
        if (dialog2 != null) {
            dialog2.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            ((FileDialog)dialog2).setMultipleMode(!bl && bl2);
            dialog2.setResizable(true);
            if (file != null) {
                if (file.isDirectory()) {
                    ((FileDialog)dialog2).setDirectory(file.getPath());
                } else {
                    String string2 = file.getParent();
                    if (string2 != null) {
                        ((FileDialog)dialog2).setDirectory(string2);
                    }
                    if (!file.exists() || file.isFile()) {
                        ((FileDialog)dialog2).setFile(file.getName());
                    }
                }
            }
            BaseDlg.setParentCentered(dialog2);
            dialog2.setVisible(true);
            fileArray = ((FileDialog)dialog2).getFiles();
        }
        return fileArray;
    }

    /*
     * WARNING - void declaration
     */
    private static File[] showSwingFileDlg(Window window, boolean bl, boolean bl2, String string, File fileFilterArray, FileFilter ... fileFilterArray2) {
        File[] fileArray = null;
        JFileChooser jFileChooser = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component component) {
                JDialog jDialog = super.createDialog(component);
                jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                return jDialog;
            }
        };
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setControlButtonsAreShown(true);
        if (fileFilterArray != null) {
            void var8_11;
            Object object = null;
            if (fileFilterArray.isDirectory()) {
                FileFilter[] fileFilterArray3 = fileFilterArray;
            } else {
                File file = fileFilterArray.getParentFile();
            }
            if (var8_11 != null) {
                if (bl && !fileFilterArray.equals(var8_11)) {
                    jFileChooser.setSelectedFile((File)fileFilterArray);
                } else {
                    jFileChooser.setCurrentDirectory((File)var8_11);
                }
            }
        }
        jFileChooser.setDialogTitle(string);
        jFileChooser.setDialogType(bl ? 2 : 0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(bl2);
        if (fileFilterArray2 != null) {
            for (FileFilter fileFilter : fileFilterArray2) {
                if (fileFilter == null) continue;
                jFileChooser.addChoosableFileFilter(fileFilter);
            }
            if (fileFilterArray2.length == 1 && fileFilterArray2[0] != null) {
                jFileChooser.setFileFilter(fileFilterArray2[0]);
            }
        }
        if (jFileChooser.showDialog(window, bl ? "Speichern" : "\u00d6ffnen") == 0) {
            if (bl2) {
                fileArray = jFileChooser.getSelectedFiles();
            } else {
                void var8_16;
                File file = EmuUtil.completeFileExtension(jFileChooser.getSelectedFile(), jFileChooser.getFileFilter());
                if (file != null && bl && !EmuUtil.confirmFileOverwrite(window, file)) {
                    Object var8_15 = null;
                }
                if (var8_16 != null) {
                    fileArray = new File[]{var8_16};
                }
            }
        }
        return fileArray;
    }

    private EmuUtil() {
    }
}

