/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import jkcemu.base.EmuUtil;

public class BaseDlg
extends JDialog
implements ActionListener,
KeyListener,
MouseListener,
WindowListener {
    public BaseDlg(Window window, String string) {
        super(window, string, Dialog.ModalityType.DOCUMENT_MODAL);
        this.init();
    }

    public BaseDlg(Window window, Dialog.ModalityType modalityType) {
        super(window, modalityType);
        this.init();
    }

    protected JButton createImageButton(String string, String string2) {
        JButton jButton = EmuUtil.createImageButton(this, string, string2);
        jButton.addActionListener(this);
        return jButton;
    }

    public boolean doClose() {
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public void setParentCentered() {
        BaseDlg.setParentCentered(this);
    }

    public static void setParentCentered(Dialog dialog) {
        Container container = dialog.getParent();
        if (container != null) {
            Dimension dimension = container.getSize();
            Point point = container.getLocation();
            Dimension dimension2 = dialog.getSize();
            int n = point.x + dimension.width / 2 - dimension2.width / 2;
            int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
            dialog.setBounds(n >= 0 ? n : 0, n2 >= 0 ? n2 : 0, dimension2.width, dimension2.height);
        }
    }

    public void setWaitCursor(boolean bl) {
        Component component = this.getGlassPane();
        if (component != null) {
            component.setVisible(bl);
            component.setCursor(bl ? Cursor.getPredefinedCursor(3) : null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doActionInternal(actionEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.showPopupInternal(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.showPopupInternal(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.showPopupInternal(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getKeyCode() == 10 && this.doActionInternal(keyEvent)) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.doClose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    protected boolean doAction(EventObject eventObject) {
        return false;
    }

    protected boolean showPopup(MouseEvent mouseEvent) {
        return false;
    }

    public static boolean showConfirmDlg(Component component, String string) {
        EmuUtil.frameToFront(component);
        return JOptionPane.showConfirmDialog(component, string, "Best\u00e4tigung", 2) == 0;
    }

    public static void showErrorDlg(Component component, String string, Exception exception) {
        String string2 = null;
        if (exception != null && (string2 = exception.getMessage()) != null && string2.trim().isEmpty()) {
            string2 = null;
        }
        if (string != null && exception != null) {
            String string3 = exception.getClass().getName();
            string = string2 != null ? (string3.startsWith("jkcemu.") || string3.startsWith("z80emu.") ? string + "\n\n" + string2 : string + "\n\n" + "Fehlermeldung des Betriebssystems:\n" + string2) : string + "\n\n" + string3;
        }
        if (string == null) {
            string = string2;
        }
        BaseDlg.showErrorDlg(component, string != null ? string : "Unbekannter Fehler");
    }

    public static void showErrorDlg(Component component, Exception exception) {
        BaseDlg.showErrorDlg(component, null, exception);
    }

    public static void showErrorDlg(Component component, String string) {
        BaseDlg.showErrorDlg(component, string, "Fehler");
    }

    public static void showErrorDlg(Component component, String string, String string2) {
        EmuUtil.frameToFront(component);
        JOptionPane.showMessageDialog(component, string != null ? string : "Unbekannter Fehler", string2, 0);
    }

    public static void showOpenFileErrorDlg(Component component, File file, Exception exception) {
        BaseDlg.showErrorDlg(component, "Die Datei '" + file.getPath() + "'\nkann nicht ge\u00f6ffnet werden.\n\n" + exception.getMessage());
    }

    public static int showOptionDlg(Component component, String string, String string2, String ... stringArray) {
        int n = -1;
        EmuUtil.frameToFront(component);
        JOptionPane jOptionPane = new JOptionPane(string, 3);
        jOptionPane.setOptions(stringArray);
        jOptionPane.createDialog(component, string2).setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (object != stringArray[i]) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public static void showInfoDlg(Component component, String string) {
        BaseDlg.showInfoDlg(component, string, "Information");
    }

    public static void showInfoDlg(Component component, String string, String string2) {
        EmuUtil.frameToFront(component);
        JOptionPane.showMessageDialog(component, string, string2, 1);
    }

    public static void showWarningDlg(Component component, String string) {
        BaseDlg.showWarningDlg(component, string, "Warnung");
    }

    public static void showWarningDlg(Component component, String string, String string2) {
        EmuUtil.frameToFront(component);
        JOptionPane.showMessageDialog(component, string, string2, 2);
    }

    public static boolean showYesNoDlg(Component component, String string) {
        return BaseDlg.showYesNoDlg(component, string, "Best\u00e4tigung");
    }

    public static boolean showYesNoDlg(Component component, String string, String string2) {
        EmuUtil.frameToFront(component);
        return BaseDlg.showYesNoDlg(component, string, string2, 3);
    }

    public static boolean showYesNoWarningDlg(Component component, String string, String string2) {
        EmuUtil.frameToFront(component);
        return BaseDlg.showYesNoDlg(component, string, string2, 2);
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    private boolean doActionInternal(EventObject eventObject) {
        boolean bl = false;
        this.setWaitCursor(true);
        try {
            bl = this.doAction(eventObject);
        }
        catch (Exception exception) {
            EmuUtil.exitSysError(this, null, exception);
        }
        this.setWaitCursor(false);
        return bl;
    }

    private boolean showPopupInternal(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent != null && mouseEvent.isPopupTrigger()) {
            bl = this.showPopup(mouseEvent);
        }
        return bl;
    }

    private static boolean showYesNoDlg(Component component, String string, String string2, int n) {
        Object[] objectArray = new String[]{"Ja", "Nein"};
        EmuUtil.frameToFront(component);
        JOptionPane jOptionPane = new JOptionPane(string, n);
        jOptionPane.setOptions(objectArray);
        jOptionPane.createDialog(component, string2).setVisible(true);
        Object object = jOptionPane.getValue();
        return object != null && object == objectArray[0];
    }
}

