/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.audio.AudioUtil;
import jkcemu.base.AutoLoadEntry;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileInfo;
import jkcemu.base.LoadData;

public class AutoLoader
extends Thread {
    public static final String PROP_AUTOLOAD_PREFIX = "autoload.";
    private static final String TEXT_CANNOT_LOAD = "Kann nicht geladen werden";
    private EmuThread emuThread;
    private List<AutoLoadEntry> entries;

    public static void start(EmuThread emuThread, Properties properties) {
        List<AutoLoadEntry> list;
        EmuSys emuSys = emuThread.getEmuSys();
        if (emuSys != null && (list = AutoLoadEntry.readEntries(properties, emuSys.getPropPrefix() + PROP_AUTOLOAD_PREFIX)) != null && !list.isEmpty()) {
            new AutoLoader(emuThread, list).start();
        }
    }

    @Override
    public void run() {
        try {
            for (AutoLoadEntry autoLoadEntry : this.entries) {
                Object object;
                String string = autoLoadEntry.getFileName();
                if (string == null || string.isEmpty()) continue;
                this.emuThread.getScreenFrm().showStatusText("AutoLoad: " + string);
                try {
                    EmuSys emuSys;
                    int n;
                    File file = new File(string);
                    if (AudioUtil.isAudioFile(file)) {
                        throw new IOException("Sound-Datei bei AutoLoad nicht unterst\u00fctzt");
                    }
                    object = EmuUtil.readFile(file, true, 65536);
                    if (object == null) {
                        throw new IOException(TEXT_CANNOT_LOAD);
                    }
                    FileInfo fileInfo = FileInfo.analyzeFile((byte[])object, file);
                    if (fileInfo == null) {
                        throw new IOException("Dateiformat unbekannt");
                    }
                    if (fileInfo.isTapeFile()) {
                        throw new IOException("Tape-Datei bei AutoLoad nicht unterst\u00fctzt");
                    }
                    Integer n2 = autoLoadEntry.getLoadAddr();
                    if (n2 == null && (n = fileInfo.getBegAddr()) >= 0) {
                        n2 = n;
                    }
                    if (n2 == null && (emuSys = this.emuThread.getEmuSys()) != null) {
                        n2 = emuSys.getLoadAddr();
                    }
                    if (n2 == null) {
                        throw new IOException("Ladeadresse nicht angegeben und in der Datei auch nicht enthalten");
                    }
                    LoadData loadData = fileInfo.createLoadData((byte[])object);
                    if (loadData == null) {
                        throw new IOException(TEXT_CANNOT_LOAD);
                    }
                    String string2 = loadData.getInfoMsg();
                    if (string2 != null && !string2.isEmpty()) {
                        this.addMsg(string, string2);
                    }
                    loadData.setBegAddr(n2);
                    loadData.setStartAddr(-1);
                    int n3 = autoLoadEntry.getMillisToWait();
                    if (n3 > 0) {
                        AutoLoader.sleep(n3);
                    }
                    this.emuThread.loadIntoMemory(loadData);
                }
                catch (IOException iOException) {
                    object = iOException.getMessage();
                    if (object != null && ((String)object).isEmpty()) {
                        object = null;
                    }
                    if (object == null) {
                        object = TEXT_CANNOT_LOAD;
                    }
                    this.addMsg(string, (String)(object != null ? object : TEXT_CANNOT_LOAD));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private AutoLoader(EmuThread emuThread, List<AutoLoadEntry> list) {
        super(Main.getThreadGroup(), "JKCEMU auto loader");
        this.emuThread = emuThread;
        this.entries = list;
    }

    private void addMsg(String string, String string2) {
        this.emuThread.getScreenFrm().fireAppendMsg("AutoLoad:\n" + string + ":\n" + string2);
    }
}

