/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jkcemu.Main;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoLoadEntry;
import jkcemu.base.AutoLoadEntryDlg;
import jkcemu.base.AutoLoadTableModel;
import jkcemu.base.EmuUtil;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class AutoLoadSettingsFld
extends AbstractSettingsFld
implements ListSelectionListener,
MouseListener {
    private int defaultFirstMillisToWait;
    private boolean checkAddrs;
    private AutoLoadTableModel tableModel;
    private JTable table;
    private JScrollPane scrollPane;
    private ListSelectionModel selectionModel;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnUp;
    private JButton btnDown;

    public AutoLoadSettingsFld(SettingsFrm settingsFrm, String string, int n, boolean bl) {
        super(settingsFrm, string + "autoload.");
        this.defaultFirstMillisToWait = n;
        this.checkAddrs = bl;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Dateien, die nach dem Einschalten bzw. nach RESET"), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("automatisch in den Arbeitsspeicher (RAM) geladen werden sollen:"), gridBagConstraints);
        this.tableModel = new AutoLoadTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setAutoCreateRowSorter(false);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setDragEnabled(false);
        this.table.setFillsViewportHeight(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(1, 1));
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.addMouseListener(this);
        EmuUtil.setTableColWidths(this.table, 100, 100, 400);
        this.scrollPane = new JScrollPane(this.table);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.scrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnUp = this.createImageButton("/images/nav/up.png", "Auf");
        jPanel.add(this.btnUp);
        this.btnDown = this.createImageButton("/images/nav/down.png", "Ab");
        jPanel.add(this.btnDown);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 5));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.btnAdd = new JButton("Hinzuf\u00fcgen");
        this.btnAdd.addActionListener(this);
        this.btnAdd.addKeyListener(this);
        jPanel2.add(this.btnAdd);
        this.btnEdit = new JButton("Bearbeiten");
        this.btnEdit.addActionListener(this);
        this.btnEdit.addKeyListener(this);
        jPanel2.add(this.btnEdit);
        this.btnRemove = new JButton("Entfernen");
        this.btnRemove.addActionListener(this);
        this.btnRemove.addKeyListener(this);
        jPanel2.add(this.btnRemove);
        this.selectionModel = this.table.getSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        new DropTarget(this.table, this).setActive(true);
        new DropTarget(this.scrollPane, this).setActive(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.selectionModel) {
            int n = this.table.getRowCount();
            int n2 = this.table.getSelectedRowCount();
            int n3 = this.table.getSelectedRow();
            boolean bl = n2 == 1 && n3 >= 0;
            this.btnUp.setEnabled(n2 == 1 && n3 > 0);
            this.btnDown.setEnabled(bl && n3 < n - 1);
            this.btnEdit.setEnabled(bl);
            this.btnRemove.setEnabled(n2 > 0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1 && mouseEvent.getComponent() == this.table) {
            this.doEdit();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            AutoLoadEntry autoLoadEntry = this.tableModel.getRow(i);
            if (autoLoadEntry == null) continue;
            String string = String.format("%s%d.", this.propPrefix, i);
            EmuUtil.setProperty(properties, string + "wait.millis", String.valueOf(autoLoadEntry.getMillisToWait()));
            EmuUtil.setProperty(properties, string + "file", autoLoadEntry.getFileName());
            EmuUtil.setProperty(properties, string + "address.load", AutoLoadTableModel.toHex4(autoLoadEntry.getLoadAddr()));
        }
        properties.setProperty(this.propPrefix + "count", Integer.toString(n));
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        this.settingsFrm.setWaitCursor(true);
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnAdd) {
                bl = true;
                this.doAdd();
            } else if (object == this.btnEdit) {
                bl = true;
                this.doEdit();
            } else if (object == this.btnRemove) {
                bl = true;
                this.doRemove();
            } else if (object == this.btnUp) {
                bl = true;
                this.doMove(-1);
            } else if (object == this.btnDown) {
                bl = true;
                this.doMove(1);
            }
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    protected boolean fileDropped(Component component, File file) {
        boolean bl = false;
        if (component == this.table || component == this.scrollPane) {
            this.addFile(file);
            bl = true;
        }
        return bl;
    }

    @Override
    public void updFields(Properties properties) {
        this.tableModel.clear();
        List<AutoLoadEntry> list = AutoLoadEntry.readEntries(properties, this.propPrefix);
        if (list != null) {
            this.tableModel.addRows(list);
        }
    }

    private void doAdd() {
        File file = EmuUtil.showFileOpenDlg(this.settingsFrm, "Datei ausw\u00e4hlen", Main.getLastDirFile("software"), EmuUtil.getBinaryFileFilter(), EmuUtil.getBasicFileFilter(), EmuUtil.getKCSystemFileFilter(), EmuUtil.getKCBasicFileFilter(), EmuUtil.getTapeFileFilter(), EmuUtil.getHeadersaveFileFilter(), EmuUtil.getHexFileFilter());
        if (file != null) {
            this.addFile(file);
        }
    }

    private void doEdit() {
        AutoLoadEntry autoLoadEntry;
        AutoLoadEntry autoLoadEntry2;
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (n = this.table.convertRowIndexToModel(nArray[0])) >= 0 && (autoLoadEntry2 = this.tableModel.getRow(n)) != null && (autoLoadEntry = AutoLoadEntryDlg.openEditEntryDlg(this.settingsFrm, autoLoadEntry2, this.checkAddrs)) != null) {
            this.tableModel.setRow(n, autoLoadEntry);
            this.fireDataChanged();
        }
    }

    private void doRemove() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = this.table.convertRowIndexToModel(nArray[i]);
                if (n < 0) continue;
                this.tableModel.removeRow(n);
            }
            this.fireDataChanged();
        }
    }

    private void doMove(int n) {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 1) {
            int n2 = this.tableModel.getRowCount();
            int n3 = nArray[0];
            int n4 = n3 + n;
            if (n3 >= 0 && n3 < n2 && n4 >= 0 && n4 < n2) {
                AutoLoadEntry autoLoadEntry = this.tableModel.getRow(n3);
                AutoLoadEntry autoLoadEntry2 = this.tableModel.getRow(n4);
                if (autoLoadEntry != null && autoLoadEntry2 != null) {
                    this.tableModel.setRow(n3, autoLoadEntry2);
                    this.tableModel.setRow(n4, autoLoadEntry);
                    EmuUtil.fireSelectRow(this.table, n4);
                    this.fireDataChanged();
                }
            }
        }
    }

    private boolean addFile(File file) {
        int n = this.tableModel.getRowCount();
        AutoLoadEntry autoLoadEntry = AutoLoadEntryDlg.openNewEntryDlg(this.settingsFrm, file, n > 0 ? 0 : this.defaultFirstMillisToWait, this.checkAddrs);
        if (autoLoadEntry != null) {
            this.tableModel.addRow(autoLoadEntry);
            int n2 = this.table.convertRowIndexToView(n);
            if (n2 >= 0) {
                EmuUtil.fireSelectRow(this.table, n2);
            }
            Main.setLastFile(file, "software");
            this.fireDataChanged();
        }
        return autoLoadEntry != null;
    }
}

