/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jkcemu.base.AutoLoadEntry;
import jkcemu.base.BaseDlg;
import jkcemu.base.FileInfo;
import jkcemu.base.FileNameFld;
import jkcemu.base.HexDocument;

public class AutoLoadEntryDlg
extends BaseDlg {
    private static final String LABEL_LOAD_ADDR = "Ladeadresse (optional):";
    private static final String LABEL_WAIT_TIME = "Wartezeit vor dem Laden:";
    private static int[] waitMillis = new int[]{0, 200, 500, 1000, 1500, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000};
    private static NumberFormat waitFmt = null;
    private boolean checkLoadAddr;
    private AutoLoadEntry appliedAutoLoadEntry;
    private FileNameFld fldFile;
    private JComboBox<String> comboWaitSeconds;
    private JLabel labelLoadAddr;
    private HexDocument docLoadAddr;
    private JTextField fldLoadAddr;
    private JButton btnOK;
    private JButton btnCancel;

    public static AutoLoadEntry openNewEntryDlg(Window window, File file, int n, boolean bl) {
        AutoLoadEntryDlg autoLoadEntryDlg = new AutoLoadEntryDlg(window, "Neuer AutoLoad-Eintrag", bl);
        autoLoadEntryDlg.fldFile.setFile(file);
        autoLoadEntryDlg.setMillisToWait(n);
        autoLoadEntryDlg.setVisible(true);
        return autoLoadEntryDlg.appliedAutoLoadEntry;
    }

    public static AutoLoadEntry openEditEntryDlg(Window window, AutoLoadEntry autoLoadEntry, boolean bl) {
        AutoLoadEntryDlg autoLoadEntryDlg = new AutoLoadEntryDlg(window, "AutoLoad-Eintrag bearbeiten", bl);
        autoLoadEntryDlg.fldFile.setFileName(autoLoadEntry.getFileName());
        autoLoadEntryDlg.setMillisToWait(autoLoadEntry.getMillisToWait());
        autoLoadEntryDlg.setLoadAddr(autoLoadEntry.getLoadAddr());
        autoLoadEntryDlg.setVisible(true);
        return autoLoadEntryDlg.appliedAutoLoadEntry;
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnOK) {
                bl = true;
                this.doApply();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private AutoLoadEntryDlg(Window window, String string, boolean bl) {
        super(window, string);
        this.checkLoadAddr = bl;
        this.appliedAutoLoadEntry = null;
        if (waitFmt == null && (waitFmt = NumberFormat.getNumberInstance()) instanceof DecimalFormat) {
            ((DecimalFormat)waitFmt).applyPattern("#0.0");
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Datei:"), gridBagConstraints);
        this.fldFile = new FileNameFld();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldFile, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel(LABEL_WAIT_TIME), gridBagConstraints);
        this.comboWaitSeconds = new JComboBox();
        for (int n : waitMillis) {
            this.comboWaitSeconds.addItem(waitFmt.format((double)n / 1000.0));
        }
        Font font = this.fldFile.getFont();
        if (font != null) {
            this.comboWaitSeconds.setFont(font);
        }
        this.comboWaitSeconds.setEditable(true);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        this.add(this.comboWaitSeconds, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Sekunden"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel(LABEL_LOAD_ADDR), gridBagConstraints);
        this.docLoadAddr = new HexDocument(4, LABEL_LOAD_ADDR);
        this.fldLoadAddr = new JTextField(this.docLoadAddr, "", 5);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldLoadAddr, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("hex"), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnOK = new JButton("OK");
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        jPanel.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    private void doApply() {
        block7: {
            try {
                File file = this.fldFile.getFile();
                if (file == null) break block7;
                int n = 0;
                try {
                    FileInfo fileInfo;
                    Number number;
                    String string;
                    Object object = this.comboWaitSeconds.getSelectedItem();
                    if (object != null && (string = object.toString()) != null && (number = waitFmt.parse(string)) != null) {
                        n = (int)Math.round(number.doubleValue() * 1000.0);
                    }
                    boolean bl = true;
                    number = this.docLoadAddr.getInteger();
                    if (this.checkLoadAddr && number == null && (fileInfo = FileInfo.analyzeFile(file)) != null && fileInfo.getBegAddr() < 0) {
                        bl = AutoLoadEntryDlg.showYesNoWarningDlg(this, "Das automatiche Laden wird nicht funktionieren,\nda Sie keine Ladeadresse angegeben haben\nund in der Datei keine enthalten ist.\n\nM\u00f6chten Sie trotzdem fortsetzen?", "Ladeadresse");
                    }
                    if (bl) {
                        this.appliedAutoLoadEntry = new AutoLoadEntry(n, file.getPath(), (Integer)number);
                        this.doClose();
                    }
                }
                catch (ParseException parseException) {
                    throw new NumberFormatException("Wartezeit vor dem Laden:: Ung\u00fcltiges Format");
                }
            }
            catch (NumberFormatException numberFormatException) {
                AutoLoadEntryDlg.showErrorDlg((Component)this, numberFormatException);
            }
        }
    }

    private void setMillisToWait(int n) {
        this.comboWaitSeconds.setSelectedItem(waitFmt.format((double)n / 1000.0));
    }

    private void setLoadAddr(Integer n) {
        if (n != null) {
            this.docLoadAddr.setValue(n, 4);
        } else {
            this.fldLoadAddr.setText("");
        }
    }
}

