/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jkcemu.base.EmuUtil;

public class AutoLoadEntry {
    public static final String PROP_COUNT = "count";
    public static final String PROP_FILE = "file";
    public static final String PROP_LOAD_ADDR = "address.load";
    public static final String PROP_WAIT_MILLIS = "wait.millis";
    private int millisToWait;
    private String fileName;
    private Integer loadAddr;

    public AutoLoadEntry(int n, String string, Integer n2) {
        this.millisToWait = n;
        this.fileName = string;
        this.loadAddr = n2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getMillisToWait() {
        return this.millisToWait;
    }

    public Integer getLoadAddr() {
        return this.loadAddr;
    }

    public static List<AutoLoadEntry> readEntries(Properties properties, String string) {
        int n;
        ArrayList<AutoLoadEntry> arrayList = null;
        if (properties != null && string != null && (n = EmuUtil.getIntProperty(properties, string + PROP_COUNT, 0)) > 0) {
            arrayList = new ArrayList<AutoLoadEntry>();
            for (int i = 0; i < n; ++i) {
                String string2 = String.format("%s%d.", string, i);
                String string3 = properties.getProperty(string2 + PROP_FILE);
                if (string3 == null || (string3 = string3.trim()).isEmpty()) continue;
                arrayList.add(new AutoLoadEntry(EmuUtil.getIntProperty(properties, string2 + PROP_WAIT_MILLIS, 0), string3, AutoLoadEntry.getAddrProperty(properties, string2 + PROP_LOAD_ADDR)));
            }
        }
        return arrayList;
    }

    private static Integer getAddrProperty(Properties properties, String string) {
        String string2;
        Integer n = null;
        if (properties != null && (string2 = properties.getProperty(string)) != null && !(string2 = string2.trim()).isEmpty()) {
            try {
                int n2 = Integer.parseInt(string2, 16);
                if (n2 >= 0 && n2 <= 65535) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }
}

