/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jkcemu.base.AutoInputDocument;
import jkcemu.base.AutoInputEntry;

public class AutoInputTableModel
extends AbstractTableModel {
    private static NumberFormat waitTimeFmt = null;
    private static String[] colNames = new String[]{"Wartezeit", "Eingabetext", "Bermerkung"};
    private List<AutoInputEntry> rows;

    public AutoInputTableModel() {
        if (waitTimeFmt == null && (waitTimeFmt = NumberFormat.getNumberInstance()) instanceof DecimalFormat) {
            ((DecimalFormat)waitTimeFmt).applyPattern("##0.0");
        }
        this.rows = new ArrayList<AutoInputEntry>();
    }

    public void addRow(AutoInputEntry autoInputEntry) {
        int n = this.rows.size();
        this.rows.add(autoInputEntry);
        this.fireTableRowsInserted(n, n);
    }

    public void addRows(Collection<AutoInputEntry> collection) {
        if (collection != null && !collection.isEmpty()) {
            int n = this.rows.size();
            this.rows.addAll(collection);
            this.fireTableRowsInserted(n, this.rows.size() - 1);
        }
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public AutoInputEntry getRow(int n) {
        return n >= 0 && n < this.rows.size() ? this.rows.get(n) : null;
    }

    public void removeRow(int n) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void setRow(int n, AutoInputEntry autoInputEntry) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.set(n, autoInputEntry);
            this.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class<Object> clazz = Object.class;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getColumnName(int n) {
        if (n < 0) return "";
        if (n >= colNames.length) return "";
        String string = colNames[n];
        return string;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = null;
        if (n >= 0 && n < this.rows.size() && n2 >= 0) {
            AutoInputEntry autoInputEntry;
            if (n2 < colNames.length && (autoInputEntry = this.rows.get(n)) != null) {
                switch (n2) {
                    case 0: {
                        string = waitTimeFmt.format((double)autoInputEntry.getMillisToWait() / 1000.0) + " s";
                        break;
                    }
                    case 1: {
                        string = AutoInputDocument.toVisibleText(autoInputEntry.getInputText());
                        break;
                    }
                    case 2: {
                        string = autoInputEntry.getRemark();
                    }
                }
            }
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

