/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputEntry;
import jkcemu.base.AutoInputEntryDlg;
import jkcemu.base.AutoInputTableModel;
import jkcemu.base.EmuUtil;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class AutoInputSettingsFld
extends AbstractSettingsFld
implements ListSelectionListener,
MouseListener {
    private static final int DEFAULT_MILLIS_TO_WAIT = 200;
    private boolean swapKeyCharCase;
    private int functionKeyCount;
    private int defaultFirstMillisToWait;
    private AutoInputTableModel tableModel;
    private JTable table;
    private JScrollPane scrollPane;
    private ListSelectionModel selectionModel;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnUp;
    private JButton btnDown;

    public AutoInputSettingsFld(SettingsFrm settingsFrm, String string, boolean bl, int n) {
        this(settingsFrm, string, bl, 0, n);
    }

    public AutoInputSettingsFld(SettingsFrm settingsFrm, String string, boolean bl, int n, int n2) {
        super(settingsFrm, string + "autoinput.");
        this.functionKeyCount = n;
        this.defaultFirstMillisToWait = n2;
        this.swapKeyCharCase = bl;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Tastatureingaben, die nach dem Einschalten bzw. nach RESET"), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("automatisch get\u00e4tigt werden sollen:"), gridBagConstraints);
        this.tableModel = new AutoInputTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setAutoCreateRowSorter(false);
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setDragEnabled(false);
        this.table.setFillsViewportHeight(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(1, 1));
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.addMouseListener(this);
        EmuUtil.setTableColWidths(this.table, 100, 200, 300);
        this.scrollPane = new JScrollPane(this.table);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.scrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel, gridBagConstraints);
        this.btnUp = this.createImageButton("/images/nav/up.png", "Auf");
        jPanel.add(this.btnUp);
        this.btnDown = this.createImageButton("/images/nav/down.png", "Ab");
        jPanel.add(this.btnDown);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 5));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.btnAdd = new JButton("Hinzuf\u00fcgen");
        this.btnAdd.addActionListener(this);
        this.btnAdd.addKeyListener(this);
        jPanel2.add(this.btnAdd);
        this.btnEdit = new JButton("Bearbeiten");
        this.btnEdit.addActionListener(this);
        this.btnEdit.addKeyListener(this);
        jPanel2.add(this.btnEdit);
        this.btnRemove = new JButton("Entfernen");
        this.btnRemove.addActionListener(this);
        this.btnRemove.addKeyListener(this);
        jPanel2.add(this.btnRemove);
        this.selectionModel = this.table.getSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.selectionModel) {
            int n = this.table.getRowCount();
            int n2 = this.table.getSelectedRowCount();
            int n3 = this.table.getSelectedRow();
            boolean bl = n2 == 1 && n3 >= 0;
            this.btnUp.setEnabled(n2 == 1 && n3 > 0);
            this.btnDown.setEnabled(bl && n3 < n - 1);
            this.btnEdit.setEnabled(bl);
            this.btnRemove.setEnabled(n2 > 0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1 && mouseEvent.getComponent() == this.table) {
            this.doEdit();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            AutoInputEntry autoInputEntry = this.tableModel.getRow(i);
            if (autoInputEntry == null) continue;
            try {
                String string = String.format("%s%d.", this.propPrefix, i);
                EmuUtil.setProperty(properties, string + "wait.millis", String.valueOf(autoInputEntry.getMillisToWait()));
                EmuUtil.setProperty(properties, string + "input_text", URLEncoder.encode(autoInputEntry.getInputText(), "UTF-8"));
                EmuUtil.setProperty(properties, string + "remark", autoInputEntry.getRemark());
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        properties.setProperty(this.propPrefix + "count", Integer.toString(n));
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        this.settingsFrm.setWaitCursor(true);
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnAdd) {
                bl = true;
                this.doAdd();
            } else if (object == this.btnEdit) {
                bl = true;
                this.doEdit();
            } else if (object == this.btnRemove) {
                bl = true;
                this.doRemove();
            } else if (object == this.btnUp) {
                bl = true;
                this.doMove(-1);
            } else if (object == this.btnDown) {
                bl = true;
                this.doMove(1);
            }
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }

    @Override
    public void updFields(Properties properties) {
        this.tableModel.clear();
        List<AutoInputEntry> list = AutoInputEntry.readEntries(properties, this.propPrefix);
        if (list != null) {
            this.tableModel.addRows(list);
        }
    }

    private void doAdd() {
        AutoInputEntry autoInputEntry;
        int n = this.defaultFirstMillisToWait;
        if (this.tableModel.getRowCount() > 0 && n > 200) {
            n = 200;
        }
        if ((autoInputEntry = AutoInputEntryDlg.openNewEntryDlg(this.settingsFrm, this.swapKeyCharCase, this.functionKeyCount, n)) != null) {
            int n2 = this.tableModel.getRowCount();
            this.tableModel.addRow(autoInputEntry);
            int n3 = this.table.convertRowIndexToView(n2);
            if (n3 >= 0) {
                EmuUtil.fireSelectRow(this.table, n3);
            }
            this.fireDataChanged();
        }
    }

    private void doEdit() {
        AutoInputEntry autoInputEntry;
        AutoInputEntry autoInputEntry2;
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 1 && (n = this.table.convertRowIndexToModel(nArray[0])) >= 0 && (autoInputEntry2 = this.tableModel.getRow(n)) != null && (autoInputEntry = AutoInputEntryDlg.openEditEntryDlg(this.settingsFrm, this.swapKeyCharCase, this.functionKeyCount, autoInputEntry2)) != null) {
            this.tableModel.setRow(n, autoInputEntry);
            this.fireDataChanged();
        }
    }

    private void doRemove() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = this.table.convertRowIndexToModel(nArray[i]);
                if (n < 0) continue;
                this.tableModel.removeRow(n);
            }
            this.fireDataChanged();
        }
    }

    private void doMove(int n) {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length == 1) {
            int n2 = this.tableModel.getRowCount();
            int n3 = nArray[0];
            int n4 = n3 + n;
            if (n3 >= 0 && n3 < n2 && n4 >= 0 && n4 < n2) {
                AutoInputEntry autoInputEntry = this.tableModel.getRow(n3);
                AutoInputEntry autoInputEntry2 = this.tableModel.getRow(n4);
                if (autoInputEntry != null && autoInputEntry2 != null) {
                    this.tableModel.setRow(n3, autoInputEntry2);
                    this.tableModel.setRow(n4, autoInputEntry);
                    EmuUtil.fireSelectRow(this.table, n4);
                    this.fireDataChanged();
                }
            }
        }
    }
}

