/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import jkcemu.base.AutoInputDocument;
import jkcemu.base.AutoInputEntry;
import jkcemu.base.BaseDlg;

public class AutoInputEntryDlg
extends BaseDlg {
    private static final String LABEL_WAIT_TIME = "Wartezeit vor Eingabe:";
    private static final String CMD_CHAR_PREFIX = "char.";
    private static int[] waitMillis = new int[]{0, 200, 500, 1000, 1500, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000};
    private static String[][] specialChars = new String[][]{{"\u0003", "Ctrl-C / Abbruch"}, {"\b", "Cursor links / Back Space"}, {"\t", "Cursor rechts / Tabulator"}, {"\n", "Cursor runter"}, {"\u000b", "Cursor hoch"}, {"\r", "Enter / Return"}, {"\u001b", "Escape"}};
    private static NumberFormat waitFmt = null;
    private AutoInputEntry appliedAutoInputEntry = null;
    private JComboBox<String> comboWaitSeconds;
    private AutoInputDocument docInputText;
    private JTextField fldInputText;
    private JTextField fldRemark;
    private JPopupMenu mnuSpecialChars;
    private JButton btnSpecialChars;
    private JButton btnOK;
    private JButton btnCancel;

    public static AutoInputEntry openNewEntryDlg(Window window, boolean bl, int n, int n2) {
        AutoInputEntryDlg autoInputEntryDlg = new AutoInputEntryDlg(window, bl, "Neuer AutoInput-Eintrag", n);
        autoInputEntryDlg.setMillisToWait(n2);
        autoInputEntryDlg.setVisible(true);
        return autoInputEntryDlg.appliedAutoInputEntry;
    }

    public static AutoInputEntry openEditEntryDlg(Window window, boolean bl, int n, AutoInputEntry autoInputEntry) {
        AutoInputEntryDlg autoInputEntryDlg = new AutoInputEntryDlg(window, bl, "AutoInput-Eintrag bearbeiten", n);
        autoInputEntryDlg.setMillisToWait(autoInputEntry.getMillisToWait());
        autoInputEntryDlg.setInputText(autoInputEntry.getInputText());
        autoInputEntryDlg.fldRemark.setText(autoInputEntry.getRemark());
        autoInputEntryDlg.setVisible(true);
        return autoInputEntryDlg.appliedAutoInputEntry;
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            String string;
            if (object == this.btnSpecialChars) {
                bl = true;
                this.mnuSpecialChars.show(this.getContentPane(), this.btnSpecialChars.getX(), this.btnSpecialChars.getY() + this.btnSpecialChars.getHeight());
            } else if (object == this.btnOK) {
                bl = true;
                this.doApply();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            } else if (eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
                int n = CMD_CHAR_PREFIX.length();
                if (string.startsWith(CMD_CHAR_PREFIX) && string.length() > n) {
                    try {
                        this.docInputText.insertString(this.fldInputText.getCaretPosition(), string.substring(n), null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
        return bl;
    }

    private AutoInputEntryDlg(Window window, boolean bl, String string, int n) {
        super(window, string);
        Object object;
        int n2;
        if (waitFmt == null && (waitFmt = NumberFormat.getNumberInstance()) instanceof DecimalFormat) {
            ((DecimalFormat)waitFmt).applyPattern("#0.0");
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel(LABEL_WAIT_TIME), gridBagConstraints);
        this.comboWaitSeconds = new JComboBox();
        int[] object2 = waitMillis;
        int jPanel = object2.length;
        for (n2 = 0; n2 < jPanel; ++n2) {
            int string2 = object2[n2];
            this.comboWaitSeconds.addItem(waitFmt.format((double)string2 / 1000.0));
        }
        this.comboWaitSeconds.setEditable(true);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        this.add(this.comboWaitSeconds, gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Sekunden"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Eingabetext:"), gridBagConstraints);
        this.docInputText = new AutoInputDocument(bl);
        this.fldInputText = new JTextField(this.docInputText, "", 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldInputText, gridBagConstraints);
        Font font = this.fldInputText.getFont();
        if (font != null) {
            this.comboWaitSeconds.setFont(font);
        }
        this.btnSpecialChars = new JButton("Bet\u00e4tigung einer Steuertaste eingeben");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnSpecialChars, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Bemerkung:"), gridBagConstraints);
        this.fldRemark = new JTextField();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldRemark, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.btnOK = new JButton("OK");
        jPanel2.add(this.btnOK);
        this.btnCancel = new JButton("Abbrechen");
        jPanel2.add(this.btnCancel);
        this.mnuSpecialChars = new JPopupMenu();
        for (n2 = 0; n2 < specialChars.length; ++n2) {
            String string3 = specialChars[n2][0];
            if (string3 == null || string3.isEmpty() || (object = AutoInputDocument.toVisibleText(string3)) == null) continue;
            JMenuItem jMenuItem = new JMenuItem(specialChars[n2][1]);
            jMenuItem.setActionCommand(CMD_CHAR_PREFIX + (String)object);
            jMenuItem.addActionListener(this);
            this.mnuSpecialChars.add(jMenuItem);
        }
        if (n > 0) {
            for (n2 = 1; n2 <= n; ++n2) {
                String string2;
                if (n2 == 10 || (string2 = AutoInputDocument.toVisibleText(Character.toString((char)(240 + n2)))) == null) continue;
                object = new JMenuItem(String.format("F%d", n2));
                ((AbstractButton)object).setActionCommand(CMD_CHAR_PREFIX + string2);
                ((AbstractButton)object).addActionListener(this);
                this.mnuSpecialChars.add((JMenuItem)object);
            }
        }
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.btnSpecialChars.addActionListener(this);
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    private void doApply() {
        block7: {
            try {
                String string = this.fldInputText.getText();
                if (string == null) break block7;
                if (string.isEmpty()) {
                    string = null;
                }
                if (string != null) {
                    int n = 0;
                    try {
                        Number number;
                        String string2;
                        Object object = this.comboWaitSeconds.getSelectedItem();
                        if (object != null && (string2 = object.toString()) != null && (number = waitFmt.parse(string2)) != null) {
                            n = (int)Math.round(number.doubleValue() * 1000.0);
                        }
                        this.appliedAutoInputEntry = new AutoInputEntry(n, AutoInputDocument.toRawText(string), this.fldRemark.getText());
                        this.doClose();
                        break block7;
                    }
                    catch (ParseException parseException) {
                        throw new NumberFormatException("Wartezeit vor Eingabe:: Ung\u00fcltiges Format");
                    }
                }
                AutoInputEntryDlg.showErrorDlg((Component)this, "Eingabetext: Sie m\u00fcssen mindestens ein Zeichen eingeben!");
            }
            catch (NumberFormatException numberFormatException) {
                AutoInputEntryDlg.showErrorDlg((Component)this, numberFormatException);
            }
        }
    }

    private void setInputText(String string) {
        boolean bl = this.docInputText.getSwapCase();
        this.docInputText.setSwapCase(false);
        this.fldInputText.setText(AutoInputDocument.toVisibleText(string));
        this.docInputText.setSwapCase(bl);
    }

    private void setMillisToWait(int n) {
        this.comboWaitSeconds.setSelectedItem(waitFmt.format((double)n / 1000.0));
    }
}

