/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jkcemu.audio.AbstractAudioOutComponent;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioOut;
import jkcemu.audio.VolumeBar;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;

public class TapeOutComponent
extends AbstractAudioOutComponent {
    private JRadioButton btnToLine;
    private JRadioButton btnToRecorder;

    public TapeOutComponent(AudioFrm audioFrm, EmuThread emuThread) {
        super(audioFrm, emuThread);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Funktion"));
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnToLine = new JRadioButton("Audiodaten \u00fcber Sound-System ausgegeben", true);
        buttonGroup.add(this.btnToLine);
        jPanel.add((Component)this.btnToLine, gridBagConstraints2);
        this.btnToRecorder = new JRadioButton("Audiodaten aufnehmen und in Datei speichern");
        buttonGroup.add(this.btnToRecorder);
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnToRecorder, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Optionen"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelMixer = new JLabel("Ger\u00e4t:");
        jPanel2.add((Component)this.labelMixer, gridBagConstraints3);
        this.labelFrameRate = new JLabel("Abtastrate (Hz):");
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.labelFrameRate, gridBagConstraints3);
        this.comboMixer = this.audioFrm.createMixerComboBox();
        gridBagConstraints3.insets.bottom = 0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridy = 0;
        ++gridBagConstraints3.gridx;
        jPanel2.add((Component)this.comboMixer, gridBagConstraints3);
        this.comboFrameRate = this.audioFrm.createFrameRateComboBox();
        this.comboFrameRate.setEditable(false);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.comboFrameRate, gridBagConstraints3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Status"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelFormat = new JLabel("Format:");
        jPanel3.add((Component)this.labelFormat, gridBagConstraints4);
        this.labelDuration = new JLabel("Aufnahmedauer:");
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelDuration, gridBagConstraints4);
        this.fldFormat = new JTextField();
        this.fldFormat.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets.bottom = 0;
        gridBagConstraints4.gridy = 0;
        ++gridBagConstraints4.gridx;
        jPanel3.add((Component)this.fldFormat, gridBagConstraints4);
        this.fldDuration = new JTextField();
        this.fldDuration.setEditable(false);
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.fldDuration, gridBagConstraints4);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel4, gridBagConstraints);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0);
        JPanel jPanel5 = new JPanel(new GridLayout(4, 1, 5, 5));
        jPanel4.add((Component)jPanel5, gridBagConstraints5);
        this.btnEnable = new JButton("Aktivieren");
        jPanel5.add(this.btnEnable);
        this.btnDisable = new JButton("Deaktivieren");
        jPanel5.add(this.btnDisable);
        this.btnPlay = new JButton("Abspielen");
        jPanel5.add(this.btnPlay);
        this.btnSave = new JButton("Speichern...");
        jPanel5.add(this.btnSave);
        this.volumeBar = new VolumeBar(1);
        this.volumeBar.setBorder(BorderFactory.createTitledBorder("Pegel"));
        this.volumeBar.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints5.insets.top = 20;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        ++gridBagConstraints5.gridy;
        jPanel4.add((Component)this.volumeBar, gridBagConstraints5);
        this.btnEnable.addActionListener(this);
        this.btnDisable.addActionListener(this);
        this.btnPlay.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnToLine.addActionListener(this);
        this.btnToRecorder.addActionListener(this);
        this.updFieldsEnabled();
    }

    public void resetFired() {
        if (this.emuThread.getTapeOut() != null) {
            this.willReset();
        }
        if (this.wasEnabled && this.emuThread.getTapeOut() == null) {
            EmuThread emuThread = this.emuThread;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        TapeOutComponent.this.enableAudio();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    TapeOutComponent.this.updFieldsEnabled();
                }
            });
        }
        this.updFieldsEnabled();
    }

    @Override
    protected void doEnable() {
        try {
            this.enableAudio();
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
    }

    @Override
    protected void updFieldsEnabled() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.btnToLine.isSelected();
        boolean bl4 = this.btnToRecorder.isSelected();
        boolean bl5 = this.recordedData != null;
        Object var6_6 = null;
        Object var7_7 = null;
        AudioOut audioOut = this.audioOut;
        if (audioOut != null) {
            bl2 = true;
        } else {
            EmuSys emuSys = this.emuThread.getEmuSys();
            if (emuSys != null) {
                bl = emuSys.supportsTapeOut();
            }
        }
        this.btnEnable.setEnabled(bl && !bl2);
        this.btnDisable.setEnabled(bl2);
        this.btnPlay.setEnabled(bl5 && !bl2);
        this.btnSave.setEnabled(bl5 && !bl2);
        this.btnToLine.setEnabled(bl && !bl2);
        this.btnToRecorder.setEnabled(bl && !bl2);
        this.labelMixer.setEnabled(bl && !bl2 && bl3);
        this.comboMixer.setEnabled(bl && !bl2 && bl3);
        this.labelFrameRate.setEnabled(bl && !bl2);
        this.comboFrameRate.setEnabled(bl && !bl2);
        if (!(bl2 || bl4 && bl5)) {
            this.fldFormat.setText("");
            this.fldDuration.setText("");
        }
        this.labelFormat.setEnabled(bl2);
        this.fldFormat.setEnabled(bl2);
        this.labelDuration.setEnabled(bl4 && bl2);
        if (bl2 && bl3) {
            this.labelDuration.setText("");
        }
        this.fldDuration.setEnabled(bl4 && bl2);
        this.volumeBar.setVolumeBarState(bl2);
    }

    private void enableAudio() throws IOException {
        int n;
        EmuSys emuSys = this.emuThread.getEmuSys();
        if (emuSys != null && emuSys.supportsTapeOut() && (n = this.audioFrm.getAndCheckSpeed()) > 0 && this.checkRecordedDataSaved()) {
            AudioOut audioOut = null;
            try {
                if (this.btnToLine.isSelected()) {
                    audioOut = new AudioOut(this, this.emuThread.getZ80CPU(), n, this.getSelectedFrameRate(), true, this.getSelectedMixer(), true, false);
                } else if (this.btnToRecorder.isSelected()) {
                    audioOut = new AudioOut(this, this.emuThread.getZ80CPU(), n, this.getSelectedFrameRate(), false, null, true, false);
                    audioOut.setRecording(true);
                    this.durationTimer.start();
                }
                if (audioOut != null) {
                    this.fldFormat.setText(audioOut.getFormatText());
                    this.fldDuration.setText(audioOut.getDurationText());
                    this.audioOut = audioOut;
                    this.emuThread.setTapeOut(audioOut);
                    this.updFieldsEnabled();
                }
            }
            catch (IOException iOException) {
                audioOut.stopAudio();
                throw iOException;
            }
        }
    }
}

