/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.EmuUtil;

public class TZXFile {
    private static final String[] fileExts = new String[]{"cdt", "tzx"};
    private static final int SAMPLE_RATE = 44100;
    private static final float T_STATES_PER_SAMPLE = 79.36508f;
    private static FileFilter fileFilter = null;

    public static String[] getFileExtensions() {
        return fileExts;
    }

    public static String getFileExtensionText() {
        return "*.cdt; *.tzx";
    }

    public static FileFilter getFileFilter() {
        if (fileFilter == null) {
            fileFilter = new FileNameExtensionFilter("CDT/TZX-Dateien (" + TZXFile.getFileExtensionText() + ")", fileExts);
        }
        return fileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(PCMDataSource pCMDataSource, File file) throws IOException {
        String string = file.getName();
        if (string == null) {
            string = "";
        }
        if (!(string = string.toLowerCase()).endsWith(".cdt") && !string.endsWith(".tzx")) {
            throw new IOException("Dateiformat nicht unterst\u00fctzt!\n\nUnterst\u00fctzte Dateiendungen sind *.cdt und *.tzx");
        }
        if (pCMDataSource.getSampleSizeInBits() > 1 || pCMDataSource.getChannels() > 1) {
            throw new IOException("In einer CDT/TZX-Datei k\u00f6nnen nur 1-Bit-Mono-Audiodaten gespeichert werden.");
        }
        long l = pCMDataSource.getFrameCount();
        long l2 = (l + 7L) / 8L;
        if (l2 > 0x7FFFFFL) {
            throw new IOException("Die Datei kann nicht gespeichert werden,\nda die L\u00e4nge der Audiodaten gr\u00f6\u00dfer ist,\nals das CDT/TZX-Dateiformat erm\u00f6glicht.");
        }
        byte[] byArray = new byte[1];
        if (pCMDataSource.read(byArray, 0, 1) != byArray.length) {
            AudioUtil.throwNoAudioData();
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            EmuUtil.writeASCII(bufferedOutputStream, "ZXTape!\u001a");
            ((OutputStream)bufferedOutputStream).write(1);
            ((OutputStream)bufferedOutputStream).write(20);
            String string2 = "File created by JKCEMU";
            ((OutputStream)bufferedOutputStream).write(48);
            ((OutputStream)bufferedOutputStream).write(string2.length());
            EmuUtil.writeASCII(bufferedOutputStream, string2);
            ((OutputStream)bufferedOutputStream).write(21);
            int n = 158;
            int n2 = pCMDataSource.getFrameRate();
            if (n2 != 22050) {
                n = Math.round(3500000.0f / (float)n2);
            }
            ((OutputStream)bufferedOutputStream).write(n & 0xFF);
            ((OutputStream)bufferedOutputStream).write(n >> 8 & 0xFF);
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).write(0);
            int n3 = (int)(l2 * 8L - l);
            ((OutputStream)bufferedOutputStream).write(n3 > 0 && n3 < 8 ? n3 : 8);
            ((OutputStream)bufferedOutputStream).write((int)(l2 & 0xFFL));
            ((OutputStream)bufferedOutputStream).write((int)(l2 >> 8 & 0xFFL));
            ((OutputStream)bufferedOutputStream).write((int)(l2 >> 16));
            while (l2 > 0L) {
                int n4 = 0;
                int n5 = 128;
                for (int i = 0; i < 8; ++i) {
                    if (pCMDataSource.read(byArray, 0, 1) == byArray.length && byArray[0] != 0) {
                        n4 |= n5;
                    }
                    n5 >>= 1;
                }
                ((OutputStream)bufferedOutputStream).write(n4);
                --l2;
            }
            ((OutputStream)bufferedOutputStream).close();
            bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedOutputStream);
    }

    private TZXFile() {
    }
}

