/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jkcemu.audio.AbstractAudioOutComponent;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioOut;
import jkcemu.audio.VolumeBar;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;

public class SoundOutComponent
extends AbstractAudioOutComponent {
    private boolean wasRecording = false;
    private JLabel labelChannels;
    private JRadioButton btnMono;
    private JRadioButton btnStereo;
    private JButton btnRecord;
    private JButton btnPause;
    private JButton btnDelete;

    public SoundOutComponent(AudioFrm audioFrm, EmuThread emuThread) {
        super(audioFrm, emuThread);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Optionen"));
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelMixer = new JLabel("Ger\u00e4t:");
        jPanel.add((Component)this.labelMixer, gridBagConstraints2);
        this.labelFrameRate = new JLabel("Abtastrate (Hz):");
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.labelFrameRate, gridBagConstraints2);
        this.labelChannels = new JLabel("Ausgang:");
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.labelChannels, gridBagConstraints2);
        this.comboMixer = this.audioFrm.createMixerComboBox();
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridy = 0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.comboMixer, gridBagConstraints2);
        this.comboFrameRate = this.audioFrm.createFrameRateComboBox();
        this.comboFrameRate.setEditable(false);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.comboFrameRate, gridBagConstraints2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnMono = new JRadioButton("Mono");
        buttonGroup.add(this.btnMono);
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnMono, gridBagConstraints2);
        this.btnStereo = new JRadioButton("Stereo", true);
        buttonGroup.add(this.btnStereo);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnStereo, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Status"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.labelFormat = new JLabel("Format:");
        jPanel2.add((Component)this.labelFormat, gridBagConstraints3);
        this.fldFormat = new JTextField();
        this.fldFormat.setEditable(false);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        ++gridBagConstraints3.gridx;
        jPanel2.add((Component)this.fldFormat, gridBagConstraints3);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Recorder"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelDuration = new JLabel("Aufnahmedauer:");
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.labelDuration, gridBagConstraints4);
        this.fldDuration = new JTextField();
        this.fldDuration.setEditable(false);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets.bottom = 5;
        gridBagConstraints4.weightx = 1.0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)this.fldDuration, gridBagConstraints4);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 5, 5, 5));
        gridBagConstraints4.anchor = 10;
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        ++gridBagConstraints4.gridy;
        jPanel3.add((Component)jPanel4, gridBagConstraints4);
        this.btnRecord = EmuUtil.createImageButton(this.audioFrm, "/images/audio/record.png", "Aufnehmen");
        jPanel4.add(this.btnRecord);
        this.btnPause = EmuUtil.createImageButton(this.audioFrm, "/images/audio/pause.png", "Pause");
        jPanel4.add(this.btnPause);
        this.btnPlay = EmuUtil.createImageButton(this.audioFrm, "/images/audio/play.png", "Wiedergeben");
        jPanel4.add(this.btnPlay);
        this.btnSave = EmuUtil.createImageButton(this.audioFrm, "/images/file/save_as.png", "Speichern unter...");
        jPanel4.add(this.btnSave);
        this.btnDelete = EmuUtil.createImageButton(this.audioFrm, "/images/audio/delete.png", "L\u00f6schen");
        jPanel4.add(this.btnDelete);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel5, gridBagConstraints);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0);
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel5.add((Component)jPanel6, gridBagConstraints5);
        this.btnEnable = new JButton("Aktivieren");
        jPanel6.add(this.btnEnable);
        this.btnDisable = new JButton("Deaktivieren");
        jPanel6.add(this.btnDisable);
        this.volumeBar = new VolumeBar(1);
        this.volumeBar.setBorder(BorderFactory.createTitledBorder("Pegel"));
        this.volumeBar.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints5.insets.top = 20;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        ++gridBagConstraints5.gridy;
        jPanel5.add((Component)this.volumeBar, gridBagConstraints5);
        this.btnEnable.addActionListener(this);
        this.btnDisable.addActionListener(this);
        this.btnRecord.addActionListener(this);
        this.btnPause.addActionListener(this);
        this.btnPlay.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.updMonoStereo();
        this.updFieldsEnabled();
    }

    public void resetFired() {
        if (this.emuThread.getSoundOut() != null) {
            this.willReset();
        }
        if (this.wasEnabled && this.audioOut == null && this.recordedData == null) {
            final EmuThread emuThread = this.emuThread;
            final boolean bl = this.wasRecording;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AudioOut audioOut;
                        SoundOutComponent.this.enableLine();
                        if (bl && (audioOut = emuThread.getSoundOut()) != null) {
                            audioOut.setRecording(true);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    SoundOutComponent.this.updMonoStereo();
                    SoundOutComponent.this.updFieldsEnabled();
                }
            });
        }
        this.updMonoStereo();
        this.updFieldsEnabled();
    }

    @Override
    protected boolean doAction(ActionEvent actionEvent) {
        boolean bl = true;
        Object object = actionEvent.getSource();
        if (object == this.btnRecord) {
            this.setRecording(true);
        } else if (object == this.btnPause) {
            this.setRecording(false);
        } else if (object == this.btnDelete) {
            this.doDelete();
        } else {
            bl = super.doAction(actionEvent);
        }
        return bl;
    }

    @Override
    protected void doEnable() {
        try {
            this.enableLine();
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        this.updMonoStereo();
    }

    @Override
    protected void updFieldsEnabled() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = this.recordedData != null;
        AudioOut audioOut = this.audioOut;
        if (audioOut != null) {
            bl3 = true;
            bl4 = audioOut.isRecording();
        } else {
            EmuSys emuSys = this.emuThread.getEmuSys();
            if (emuSys != null) {
                bl = emuSys.supportsSoundOutMono();
                bl2 = emuSys.supportsSoundOutStereo();
            }
        }
        boolean bl6 = bl || bl2;
        this.btnEnable.setEnabled(bl6 && !bl3);
        this.btnDisable.setEnabled(bl3);
        this.btnRecord.setEnabled(!bl4 && bl3);
        this.btnPause.setEnabled(bl4);
        this.btnPlay.setEnabled(bl5 && !bl3);
        this.btnSave.setEnabled(bl5 && !bl3);
        this.btnDelete.setEnabled(bl5 && !bl3);
        this.labelMixer.setEnabled(bl6 && !bl3);
        this.comboMixer.setEnabled(bl6 && !bl3);
        this.labelFrameRate.setEnabled(bl6 && !bl3);
        this.comboFrameRate.setEnabled(bl6 && !bl3);
        this.btnMono.setEnabled(bl && bl2 && !bl3);
        this.btnStereo.setEnabled(bl && bl2 && !bl3);
        if (!bl3 && !bl5) {
            this.fldFormat.setText("");
            this.fldDuration.setText("");
        }
        this.labelFormat.setEnabled(bl3);
        this.fldFormat.setEnabled(bl3);
        this.labelDuration.setEnabled(bl5 || bl3);
        this.fldDuration.setEnabled(bl5 || bl3);
        this.volumeBar.setVolumeBarState(bl3);
    }

    @Override
    public void willReset() {
        this.wasEnabled = false;
        this.wasRecording = false;
        AudioOut audioOut = this.emuThread.getSoundOut();
        if (audioOut != null) {
            boolean bl = audioOut.isRecording();
            this.doDisable();
            this.wasEnabled = true;
            this.wasRecording = bl;
        }
    }

    private void doDelete() {
        if (this.recordedData != null && BaseDlg.showYesNoDlg(this, "Aufnahme verwerfen?")) {
            this.recordedData = null;
            this.fldDuration.setText("");
            this.fldDuration.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    private void enableLine() throws IOException {
        int n;
        EmuSys emuSys = this.emuThread.getEmuSys();
        if (emuSys != null && (emuSys.supportsSoundOutMono() || emuSys.supportsSoundOutStereo()) && (n = this.audioFrm.getAndCheckSpeed()) > 0 && this.checkRecordedDataSaved()) {
            AudioOut audioOut = null;
            try {
                audioOut = new AudioOut(this, this.emuThread.getZ80CPU(), n, this.getSelectedFrameRate(), true, this.getSelectedMixer(), !emuSys.supportsSoundOut8Bit(), emuSys.supportsSoundOutStereo() && this.btnStereo.isSelected());
                this.fldFormat.setText(audioOut.getFormatText());
                this.fldDuration.setText(audioOut.getDurationText());
                this.audioOut = audioOut;
                this.emuThread.setSoundOut(audioOut);
                this.durationTimer.start();
                this.updFieldsEnabled();
            }
            catch (IOException iOException) {
                audioOut.stopAudio();
                throw iOException;
            }
        }
    }

    private void setRecording(boolean bl) {
        AudioOut audioOut = this.audioOut;
        if (audioOut != null) {
            audioOut.setRecording(bl);
            this.btnRecord.setEnabled(!bl);
            this.btnPause.setEnabled(bl);
        }
    }

    private void updMonoStereo() {
        EmuSys emuSys = this.emuThread.getEmuSys();
        if (emuSys != null) {
            if (emuSys.supportsSoundOutMono() && !emuSys.supportsSoundOutStereo()) {
                this.btnMono.setSelected(true);
            } else if (!emuSys.supportsSoundOutMono() && emuSys.supportsSoundOutStereo()) {
                this.btnStereo.setSelected(true);
            }
        }
    }
}

