/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.IOException;
import jkcemu.audio.PCMDataSource;

public class BitSampleBuffer {
    private byte[] data;
    private int size;
    private int frameRate;
    private long frameCount;
    private String errorText;

    public BitSampleBuffer(int n, int n2) {
        this.frameRate = n;
        this.frameCount = 0L;
        this.size = 0;
        this.data = new byte[n2];
        this.errorText = null;
    }

    public synchronized void addSample(boolean bl) throws IOException {
        if (this.size > 0) {
            if (bl == this.data[this.size - 1] > 0) {
                this.putLastPhaseAgain();
            } else if (this.ensureSize()) {
                this.data[this.size] = (byte)(bl ? 1 : -1);
                ++this.size;
            }
        } else {
            this.data[0] = (byte)(bl ? 1 : -1);
            this.size = 1;
        }
        ++this.frameCount;
    }

    public synchronized void addSamples(int n, boolean bl) throws IOException {
        while (n > 0) {
            if (this.size > 0) {
                int n2;
                byte by = this.data[this.size - 1];
                if (bl && by > 0) {
                    n2 = Math.min(n, 127 - by);
                    int n3 = this.size - 1;
                    this.data[n3] = (byte)(this.data[n3] + (byte)n2);
                    n -= n2;
                    this.frameCount += (long)n2;
                } else if (!bl && by < 0) {
                    n2 = Math.min(n, 128 + by);
                    int n4 = this.size - 1;
                    this.data[n4] = (byte)(this.data[n4] - (byte)n2);
                    n -= n2;
                    this.frameCount += (long)n2;
                }
            }
            if (n <= 0) continue;
            this.addSample(bl);
            --n;
        }
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public PCMDataSource newReader() {
        return new Reader(this.data, this.size, this.frameRate, this.frameCount);
    }

    private boolean ensureSize() throws IOException {
        boolean bl = true;
        if (this.size >= this.data.length) {
            try {
                int n = this.data.length / 2;
                if (n < 256) {
                    n = 256;
                } else if (n > 0x100000) {
                    n = 0x100000;
                }
                byte[] byArray = new byte[this.data.length + n];
                System.arraycopy(this.data, 0, byArray, 0, this.data.length);
                this.data = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                bl = false;
                this.data = null;
                System.gc();
                throw new IOException("Kein Speicher mehr f\u00fcr die Aufzeichnung\nder Audiodaten verf\u00fcgbar.");
            }
        }
        return bl;
    }

    private void putLastPhaseAgain() throws IOException {
        int n = this.size - 1;
        byte by = this.data[n];
        if (by > 0) {
            if (by == 127) {
                if (this.ensureSize()) {
                    this.data[this.size] = 1;
                    ++this.size;
                }
            } else {
                int n2 = n;
                this.data[n2] = (byte)(this.data[n2] + 1);
            }
        } else if (by < 0) {
            if (by == -128) {
                if (this.ensureSize()) {
                    this.data[this.size] = -1;
                    ++this.size;
                }
            } else {
                int n3 = n;
                this.data[n3] = (byte)(this.data[n3] - 1);
            }
        }
    }

    public static class Reader
    implements PCMDataSource {
        private byte[] data;
        private byte cur;
        private int size;
        private int pos;
        private int frameRate;
        private long frameCount;

        public Reader(byte[] byArray, int n, int n2, long l) {
            this.data = byArray;
            this.size = n;
            this.frameRate = n2;
            this.frameCount = l;
            this.cur = 0;
            this.pos = 0;
        }

        @Override
        public void close() {
        }

        @Override
        public int getChannels() {
            return 1;
        }

        @Override
        public long getFrameCount() {
            return this.frameCount;
        }

        @Override
        public int getFrameRate() {
            return this.frameRate;
        }

        @Override
        public int getSampleSizeInBits() {
            return 1;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isSigned() {
            return false;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) {
            int n3 = 0;
            while (n2 > 0) {
                while (this.cur == 0 && this.pos < this.size) {
                    this.cur = this.data[this.pos++];
                }
                if (this.cur < 0) {
                    this.cur = (byte)(this.cur + 1);
                    byArray[n++] = 0;
                } else {
                    if (this.cur <= 0) break;
                    this.cur = (byte)(this.cur - 1);
                    byArray[n++] = -128;
                }
                ++n3;
                --n2;
            }
            return n3;
        }

        @Override
        public synchronized void setFramePos(long l) throws IOException {
            if (l < 0L) {
                this.cur = 0;
                this.pos = 0;
            } else {
                for (int i = 0; i < this.size; ++i) {
                    byte by = this.data[i];
                    int n = Math.abs(by);
                    if ((long)n > l) {
                        n = (int)((long)n - l);
                        this.cur = (byte)(by < 0 ? -n : n);
                        this.pos = i;
                        break;
                    }
                    l -= (long)n;
                }
            }
        }

        @Override
        public boolean supportsSetFramePos() {
            return true;
        }
    }
}

