/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.File;
import java.io.IOException;
import jkcemu.audio.AudioFile;
import jkcemu.audio.CSWFile;
import jkcemu.audio.PCMDataInfo;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileInfo;
import jkcemu.emusys.kc85.KCAudioCreator;
import jkcemu.emusys.zxspectrum.ZXSpectrumAudioCreator;

public class AudioUtil {
    public static final String[] tapeFileExtensions = new String[]{".852", ".853", ".854", ".cdt", ".csw", ".tap", ".tzx"};
    public static final String ERROR_TEXT_LINE_UNAVAILABLE = "Der Audiokanal kann nicht ge\u00f6ffnet werden,\nda er bereits durch eine andere Anwendung benutzt wird.";
    public static final String ERROR_RECORDING_OUT_OF_MEMORY = "Kein Speicher mehr f\u00fcr die Aufzeichnung\nder Audiodaten verf\u00fcgbar.";
    public static final int FILE_READ_MAX = 0x1000000;
    public static final int RECORDING_MINUTES_MAX = 120;

    public static void appendAudioFormatText(StringBuilder stringBuilder, PCMDataInfo pCMDataInfo) {
        if (pCMDataInfo != null) {
            stringBuilder.append(pCMDataInfo.getFrameRate());
            stringBuilder.append(" Hz, ");
            stringBuilder.append(pCMDataInfo.getSampleSizeInBits());
            stringBuilder.append(" Bit, ");
            int n = pCMDataInfo.getChannels();
            switch (n) {
                case 1: {
                    stringBuilder.append("Mono");
                    break;
                }
                case 2: {
                    stringBuilder.append("Stereo");
                    break;
                }
                default: {
                    stringBuilder.append(n);
                    stringBuilder.append(" Kan\u00e4le");
                }
            }
        }
    }

    public static String getAudioFormatText(PCMDataInfo pCMDataInfo) {
        StringBuilder stringBuilder = new StringBuilder(64);
        AudioUtil.appendAudioFormatText(stringBuilder, pCMDataInfo);
        return stringBuilder.toString();
    }

    public static String getDurationText(int n, long l) {
        String string = null;
        if (n > 0 && l > 0L) {
            long l2 = l / (long)n;
            string = l2 < 60L ? String.format("%d Sekunden", l2) : (l2 < 3600L ? String.format("%d:%02d Minuten", l2 / 60L, l2 % 60L) : String.format("%d:%02d:%02d Stunden", l2 / 3600L, l2 % 3600L / 60L, l2 % 60L));
        }
        return string;
    }

    public static boolean isAudioFile(File file) {
        boolean bl = false;
        try {
            if (AudioFile.getInfo(file) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static PCMDataSource openAudioOrTapeFile(File file) throws IOException {
        String string;
        PCMDataSource pCMDataSource = null;
        byte[] byArray = null;
        boolean bl = false;
        if (file.isFile() && (string = file.getName()) != null) {
            bl = (string = string.toLowerCase()).endsWith(".tap") || string.endsWith(".tap.gz");
            byArray = EmuUtil.readFile(file, true, 0x1000000);
        }
        if (byArray != null) {
            if (FileInfo.isCswMagicAt(byArray, 0)) {
                pCMDataSource = CSWFile.getPCMDataSource(byArray, 0);
            } else if (FileInfo.isKCTapMagicAt(byArray, 0)) {
                pCMDataSource = new KCAudioCreator(true, 0, byArray, 0, byArray.length).newReader();
            } else if (bl || FileInfo.isTzxMagicAt(byArray, 0)) {
                pCMDataSource = new ZXSpectrumAudioCreator(byArray, 0, byArray.length).newReader();
            }
        }
        if (pCMDataSource == null) {
            pCMDataSource = AudioFile.open(file, byArray);
        }
        return pCMDataSource;
    }

    public static void throwNoAudioData() throws IOException {
        throw new IOException("Keine Audiodaten vorhanden");
    }
}

