/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import jkcemu.audio.AudioIO;
import jkcemu.audio.AudioIOObserver;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.DataLineCloser;
import jkcemu.audio.PCMDataSource;
import jkcemu.audio.PCMDataStream;
import jkcemu.base.EmuUtil;
import jkcemu.base.MyByteArrayOutputStream;
import z80emu.Z80CPU;

public class AudioOut
extends AudioIO {
    public static final int MAX_LINE_PAUSE_MILLIS = 100;
    public static final int MAX_RECORDING_PAUSE_SECONDS = 5;
    public static final int MAX_UNSIGNED_VALUE = 255;
    public static final int MAX_UNSIGNED_USED_VALUE = 220;
    public static final int UNSIGNED_VALUE_1 = 200;
    private static int[] frameRates = new int[]{44100, 48000, 32000, 22050, 16000, 8000};
    private int speedKHz;
    private int maxWaveTStatesLine;
    private int maxWaveTStatesRec;
    private int lineChannels;
    private int audioPos;
    private byte[] audioBuf;
    private volatile SourceDataLine dataLine;
    private volatile Thread writingThread;
    private MyByteArrayOutputStream recBufGZip;
    private GZIPOutputStream recBufOut;
    private int recBufFrames;
    private int recPauseFrames;
    private int recStatus;
    private int lastRecMonoValue;
    private int lastRecLeftValue;
    private int lastRecRightValue;
    private int maxRecBufFrames;
    private int maxRecPauseFrames;
    private boolean stereo;

    public AudioOut(AudioIOObserver audioIOObserver, Z80CPU z80CPU, int n, int n2, boolean bl, Mixer mixer, boolean bl2, boolean bl3) throws IOException {
        super(audioIOObserver, z80CPU);
        this.speedKHz = n;
        this.frameRate = 0;
        this.maxWaveTStatesLine = n * 100;
        this.maxWaveTStatesRec = n * 5 * 1000;
        this.lineChannels = 0;
        this.audioPos = 0;
        this.audioBuf = null;
        this.dataLine = null;
        this.writingThread = null;
        this.recBufGZip = null;
        this.recBufOut = null;
        this.recBufFrames = 0;
        this.recPauseFrames = 0;
        this.recStatus = 0;
        this.lastRecMonoValue = 0;
        this.lastRecLeftValue = 0;
        this.lastRecRightValue = 0;
        this.maxRecBufFrames = 0;
        this.stereo = bl3;
        if (bl) {
            SourceDataLine sourceDataLine = null;
            if (n2 > 0) {
                sourceDataLine = this.openSourceDataLine(mixer, n2, bl3);
            } else {
                int n3 = 0;
                while (true) {
                    if (n3 >= frameRates.length) break;
                    sourceDataLine = this.openSourceDataLine(mixer, frameRates[n3], bl3);
                    if (sourceDataLine != null) break;
                    ++n3;
                }
            }
            if (sourceDataLine != null) {
                AudioFormat audioFormat = sourceDataLine.getFormat();
                this.setFormat(Math.round(audioFormat.getSampleRate()), bl2 ? 1 : 8, bl3 ? 2 : 1, false, false);
                this.lineChannels = audioFormat.getChannels();
                this.dataLine = sourceDataLine;
                int n4 = this.frameRate;
                int n5 = sourceDataLine.getBufferSize() / 32;
                if (n5 > n4 / 2) {
                    n5 = n4 / 2;
                }
                if (n5 < 1) {
                    n5 = 1;
                }
                this.audioBuf = new byte[n5 * this.channels];
                this.audioPos = 0;
                this.observer.setVolumeLimits(0, 255);
            }
        }
        if (this.frameRate <= 0) {
            if (n2 <= 0) {
                n2 = frameRates[0];
            }
            this.setFormat(n2, bl2 ? 1 : 8, 1, false, false);
        }
        this.maxRecBufFrames = this.frameRate * 60 * 120;
        this.maxRecPauseFrames = this.frameRate * 5;
        this.tStatesPerFrame = (int)((float)n * 1000.0f / (float)this.frameRate);
    }

    public synchronized PCMDataSource createPCMDataSourceOfRecordedData() throws IOException {
        PCMDataStream pCMDataStream = null;
        if (this.hasRecordedData()) {
            if (this.recBufOut != null) {
                this.recBufOut.finish();
                this.recBufOut = null;
            }
            pCMDataStream = new PCMDataStream(this.frameRate, this.sampleSizeInBits, this.channels, this.dataSigned, this.bigEndian, new GZIPInputStream(this.recBufGZip.newInputStream()), (long)(this.recBufFrames * this.channels));
        }
        return pCMDataStream;
    }

    public String getDurationText() {
        return AudioUtil.getDurationText(this.frameRate, this.recBufFrames);
    }

    public int getRecordedFrameCount() {
        return this.recBufFrames;
    }

    public boolean hasRecordedData() {
        return this.recBufGZip != null && this.recBufFrames > 0;
    }

    public boolean isRecording() {
        return this.recStatus > 0;
    }

    public synchronized void setRecording(boolean bl) {
        try {
            if (bl && (this.recBufGZip == null || this.recBufOut == null)) {
                int n = this.frameRate * 60;
                if (this.stereo) {
                    n *= 2;
                }
                this.recBufGZip = new MyByteArrayOutputStream(n);
                this.recBufOut = new GZIPOutputStream(this.recBufGZip);
            }
            this.recStatus = 1;
            this.observer.fireRecordingStatusChanged(this);
        }
        catch (IOException iOException) {
            this.recBufGZip = null;
            this.recBufOut = null;
            this.recStatus = 0;
        }
    }

    public void stopAudio() {
        this.recStatus = 0;
        EmuUtil.closeSilent(this.recBufOut);
        SourceDataLine sourceDataLine = this.dataLine;
        if (sourceDataLine != null) {
            this.dataLine = null;
            Thread thread = this.writingThread;
            if (thread != null && thread != Thread.currentThread()) {
                thread.interrupt();
            }
            DataLineCloser.closeDataLine(sourceDataLine);
        }
    }

    public void writeFrames(int n, int n2, int n3, int n4) {
        GZIPOutputStream gZIPOutputStream;
        SourceDataLine sourceDataLine = this.dataLine;
        byte[] byArray = this.audioBuf;
        if (sourceDataLine != null && byArray != null && n > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.audioPos + this.channels - 1 >= byArray.length) {
                    this.writingThread = Thread.currentThread();
                    if (!sourceDataLine.isActive()) {
                        sourceDataLine.start();
                    }
                    sourceDataLine.write(byArray, 0, byArray.length);
                    this.audioPos = 0;
                    this.writingThread = null;
                }
                if (this.lineChannels == 2) {
                    if (this.channels == 1) {
                        n3 = n2;
                        n4 = n2;
                    }
                    byArray[this.audioPos++] = (byte)n3;
                    byArray[this.audioPos++] = (byte)n4;
                    continue;
                }
                byArray[this.audioPos++] = (byte)n2;
            }
        }
        if ((gZIPOutputStream = this.recBufOut) != null) {
            if (this.recStatus == 1) {
                this.lastRecMonoValue = n2;
                this.lastRecLeftValue = n3;
                this.lastRecRightValue = n4;
                this.recStatus = 2;
            } else if (this.recStatus == 2 && (!this.stereo && n2 != this.lastRecMonoValue || this.stereo && (n3 != this.lastRecLeftValue || n4 != this.lastRecRightValue))) {
                this.recPauseFrames = 0;
                this.recStatus = 3;
            }
            if (this.recStatus == 3) {
                try {
                    if (this.stereo) {
                        if (n3 == this.lastRecLeftValue && n4 == this.lastRecRightValue) {
                            this.recPauseFrames += n;
                        } else {
                            while (this.recPauseFrames > 0) {
                                ((OutputStream)gZIPOutputStream).write(this.lastRecLeftValue);
                                ((OutputStream)gZIPOutputStream).write(this.lastRecRightValue);
                                ++this.recBufFrames;
                                --this.recPauseFrames;
                            }
                            this.lastRecLeftValue = n3;
                            this.lastRecRightValue = n4;
                            for (int i = 0; i < n; ++i) {
                                ((OutputStream)gZIPOutputStream).write(n3);
                                ((OutputStream)gZIPOutputStream).write(n4);
                            }
                            this.recBufFrames += n;
                        }
                    } else if (n2 == this.lastRecMonoValue) {
                        this.recPauseFrames += n;
                    } else {
                        while (this.recPauseFrames > 0) {
                            ((OutputStream)gZIPOutputStream).write(this.lastRecMonoValue);
                            ++this.recBufFrames;
                            --this.recPauseFrames;
                        }
                        this.lastRecMonoValue = n2;
                        for (int i = 0; i < n; ++i) {
                            ((OutputStream)gZIPOutputStream).write(n2);
                        }
                        this.recBufFrames += n;
                    }
                    if (this.recBufFrames >= this.maxRecBufFrames) {
                        throw new IOException("Audiofunktion beendet, da die maximal\n zul\u00e4ssige Aufnahmedauer erreicht wurde");
                    }
                    if (this.recPauseFrames > this.maxRecPauseFrames) {
                        this.recStatus = 0;
                        this.recPauseFrames = 0;
                        this.observer.fireRecordingStatusChanged(this);
                    }
                }
                catch (IOException iOException) {
                    this.recStatus = 0;
                    this.stopAudio();
                    this.observer.fireFinished(this, iOException.getMessage());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.recStatus = 0;
                    this.recBufOut = null;
                    System.gc();
                    this.stopAudio();
                    this.observer.fireFinished(this, "Kein Speicher mehr f\u00fcr die Aufzeichnung\nder Audiodaten verf\u00fcgbar.");
                }
            }
        }
        this.observer.updVolume(this.channels == 2 ? (n3 + n4) / 2 : n2);
    }

    public void writePhase(boolean bl) {
        int n = bl ? 200 : 0;
        this.writeValue(n, n, n);
    }

    public void writeValue(int n, int n2, int n3) {
        if (this.tStatesPerFrame > 0) {
            if (this.firstCall) {
                this.firstCall = false;
                this.lastTStates = this.z80cpu.getProcessedTStates();
                this.lastPhase = false;
            } else {
                long l = this.z80cpu.getProcessedTStates();
                long l2 = Z80CPU.calcTStatesDiff(this.lastTStates, l);
                if (l2 > 0L) {
                    int n4 = (int)(l2 / (long)this.tStatesPerFrame);
                    if (this.currentDiffTStates(l2)) {
                        this.writeFrames(n4, n, n2, n3);
                    }
                    this.lastTStates += (long)(n4 * this.tStatesPerFrame);
                }
            }
        }
    }

    @Override
    protected boolean currentDiffTStates(long l) {
        boolean bl = false;
        if (l > (long)this.maxWaveTStatesLine) {
            this.audioPos = 0;
            SourceDataLine sourceDataLine = this.dataLine;
            if (sourceDataLine != null) {
                sourceDataLine.flush();
            }
        } else {
            if (this.dataLine != null) {
                this.z80cpu.setSpeedUnlimitedFor(l * 8L);
            }
            bl = true;
        }
        if (this.recStatus == 3 && l > (long)this.maxWaveTStatesRec) {
            this.recStatus = 0;
            if (this.dataLine != null) {
                this.observer.fireRecordingStatusChanged(this);
            } else {
                this.observer.fireFinished(this, null);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isLineOpen() {
        return super.isLineOpen() || this.dataLine != null;
    }

    private SourceDataLine openSourceDataLine(Mixer mixer, int n, boolean bl) throws IOException {
        SourceDataLine sourceDataLine = this.openSourceDataLine(mixer, n, bl, false);
        if (sourceDataLine == null) {
            sourceDataLine = this.openSourceDataLine(mixer, n, bl, true);
        }
        return sourceDataLine;
    }

    private SourceDataLine openSourceDataLine(Mixer mixer, int n, boolean bl, boolean bl2) throws IOException {
        SourceDataLine sourceDataLine;
        block7: {
            AudioFormat audioFormat = new AudioFormat(n, 8, bl ? 2 : 1, false, bl2);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            sourceDataLine = null;
            try {
                if (mixer != null) {
                    if (mixer.isLineSupported(info)) {
                        sourceDataLine = (SourceDataLine)mixer.getLine(info);
                    }
                } else if (AudioSystem.isLineSupported(info)) {
                    sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                }
                if (sourceDataLine != null) {
                    sourceDataLine.open(audioFormat, n / 4);
                }
            }
            catch (Exception exception) {
                DataLineCloser.closeDataLine(sourceDataLine);
                sourceDataLine = null;
                if (!(exception instanceof LineUnavailableException)) break block7;
                throw new IOException("Der Audiokanal kann nicht ge\u00f6ffnet werden,\nda er bereits durch eine andere Anwendung benutzt wird.");
            }
        }
        return sourceDataLine;
    }
}

