/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jkcemu.audio.AudioIOObserver;
import jkcemu.audio.DataLineCloser;
import z80emu.Z80CPU;

public abstract class AudioIO {
    protected AudioIOObserver observer;
    protected Z80CPU z80cpu;
    protected int frameRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected boolean dataSigned;
    protected boolean bigEndian;
    protected boolean firstCall;
    protected boolean lastPhase;
    protected long lastTStates;
    protected int tStatesPerFrame;
    protected int bytesPerSample;
    protected String formatText;
    private volatile SourceDataLine monitorLine;
    private volatile byte[] monitorBuf;
    private volatile int monitorPos;

    protected AudioIO(AudioIOObserver audioIOObserver, Z80CPU z80CPU) {
        this.observer = audioIOObserver;
        this.z80cpu = z80CPU;
        this.frameRate = 0;
        this.sampleSizeInBits = 0;
        this.channels = 0;
        this.dataSigned = false;
        this.bigEndian = false;
        this.firstCall = true;
        this.lastPhase = false;
        this.lastTStates = 0L;
        this.tStatesPerFrame = 0;
        this.bytesPerSample = 0;
        this.formatText = null;
        this.monitorLine = null;
        this.monitorBuf = null;
        this.monitorPos = 0;
    }

    protected boolean currentDiffTStates(long l) {
        return true;
    }

    public int getChannels() {
        return this.channels;
    }

    public String getFormatText() {
        return this.formatText;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public boolean isLineOpen() {
        return this.monitorLine != null;
    }

    public boolean isMonitorActive() {
        return this.monitorLine != null;
    }

    protected void openMonitorLine() {
        AudioFormat audioFormat = new AudioFormat(this.frameRate, this.sampleSizeInBits, this.channels, this.dataSigned, this.bigEndian);
        if (this.supportsMonitor() && this.monitorLine == null && audioFormat != null) {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            SourceDataLine sourceDataLine = null;
            try {
                if (AudioSystem.isLineSupported(info) && (sourceDataLine = (SourceDataLine)AudioSystem.getLine(info)) != null) {
                    sourceDataLine.open(audioFormat);
                    sourceDataLine.start();
                    int n = Math.round(audioFormat.getSampleRate());
                    int n2 = sourceDataLine.getBufferSize() / 32;
                    if (n2 < n / 8) {
                        n2 = n / 8;
                    } else if (n2 > n / 2) {
                        n2 = n / 2;
                    }
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    this.monitorBuf = new byte[n2];
                }
            }
            catch (Exception exception) {
                DataLineCloser.closeDataLine(sourceDataLine);
                sourceDataLine = null;
            }
            this.monitorLine = sourceDataLine;
        }
    }

    protected void closeMonitorLine() {
        SourceDataLine sourceDataLine = this.monitorLine;
        this.monitorLine = null;
        if (sourceDataLine != null) {
            DataLineCloser.closeDataLine(sourceDataLine);
        }
    }

    protected void setFormat(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.frameRate = n;
        this.sampleSizeInBits = n2;
        this.bytesPerSample = (n2 + 7) / 8;
        this.channels = n3;
        this.dataSigned = bl;
        this.bigEndian = bl2;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(n);
        stringBuilder.append(" Hz, ");
        stringBuilder.append(n2);
        stringBuilder.append(" Bit");
        switch (this.channels) {
            case 1: {
                stringBuilder.append(" Mono");
                break;
            }
            case 2: {
                stringBuilder.append(" Stereo");
                break;
            }
            default: {
                stringBuilder.append(", ");
                stringBuilder.append(this.channels);
                stringBuilder.append(" Kan\u00e4le");
            }
        }
        this.formatText = stringBuilder.toString();
        if (this.bytesPerSample == 1) {
            if (this.dataSigned) {
                this.observer.setVolumeLimits(-128, 127);
            } else {
                this.observer.setVolumeLimits(0, 255);
            }
        } else if (this.dataSigned) {
            this.observer.setVolumeLimits(Short.MIN_VALUE, Short.MAX_VALUE);
        } else {
            this.observer.setVolumeLimits(0, 65535);
        }
    }

    protected boolean supportsMonitor() {
        return false;
    }

    protected void writeMonitorLine(byte[] byArray) {
        SourceDataLine sourceDataLine = this.monitorLine;
        if (sourceDataLine != null && byArray != null) {
            sourceDataLine.write(byArray, 0, byArray.length);
        }
    }

    protected void writeMonitorLine(int n) {
        SourceDataLine sourceDataLine = this.monitorLine;
        byte[] byArray = this.monitorBuf;
        if (sourceDataLine != null && byArray != null) {
            if (this.monitorPos >= byArray.length) {
                sourceDataLine.write(byArray, 0, byArray.length);
                this.monitorPos = 0;
            }
            byArray[this.monitorPos] = (byte)n;
            ++this.monitorPos;
        }
    }
}

