/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.IOException;
import jkcemu.audio.PCMDataSource;

public abstract class AbstractPCMDataReader
implements PCMDataSource {
    protected int channels;
    protected int frameRate;
    protected int sampleSizeInBits;
    protected int bytesPerSample;
    protected int bytesPerFrame;
    protected boolean dataSigned;
    protected boolean bigEndian;
    protected long pcmDataOffs;
    protected long pcmDataLen;
    protected long frameCount;

    public AbstractPCMDataReader(int n, int n2, int n3, boolean bl, boolean bl2, long l, long l2) throws IOException {
        this.frameRate = n;
        this.sampleSizeInBits = n2;
        this.bytesPerSample = (n2 + 7) / 8;
        this.bytesPerFrame = this.bytesPerSample * n3;
        this.channels = n3;
        this.dataSigned = bl;
        this.bigEndian = bl2;
        this.pcmDataOffs = l;
        this.pcmDataLen = l2;
        this.frameCount = l2 / (long)this.bytesPerFrame;
        if (this.frameCount < 1L) {
            AbstractPCMDataReader.throwNoAudioData();
        }
    }

    protected static void throwNoAudioData() throws IOException {
        throw new IOException("Keine Audiodaten vorhanden");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public int getFrameRate() {
        return this.frameRate;
    }

    @Override
    public long getFrameCount() {
        return this.frameCount;
    }

    @Override
    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public boolean isSigned() {
        return this.dataSigned;
    }

    @Override
    public synchronized void setFramePos(long l) throws IOException {
        throw new IOException("Setzen der Abspielposition nicht m\u00f6glich");
    }

    @Override
    public boolean supportsSetFramePos() {
        return false;
    }
}

