#version 330

uniform float my_time;

in vec2 texCoord;
out vec4 my_out;

float resX = 1920;
float resY = 1080;

float v=.0001*my_time;

 vec3 i,r; // i = color, r = hitstate. r.x = min hitstate, r.y = max distance TODO: vec2? samen met iets anders?

void rot(inout vec2 s,float v)
{
	s=vec2(cos(v)*s.x+sin(v)*s.y,-sin(v)*s.x+cos(v)*s.y);
}

float s=1,f=9; // conePower, timer, orbit trap

float sd_Rect(vec3 p, vec3 r)
{
	return length(max(abs(p)-r,0));
}


float scene(vec3 r)// distance
{
	
	float y=2,z=2,x=6+r.y;

	i=vec3(0);
	if(fract(r.x/6/*4KS:CheckboardSize:0*/)>.5^^fract(r.z/6/*4KS:CheckboardSize:0*/+v*30/*4KS:CheckboardSpeed:0*/)>.5)	
			i=vec3(1);

	vec3 r2 = r;
	
	r2.y += 6;
	r2.z -= 50;
	rot(r2.xz, v*5);
	r2.xz = abs(r2.xz);
	float g = max(r2.y - 24./*4KS:AAAAPyr*/, max(-.68/*4KS:AAAY*/*r2.y - -.68/*4KS:AAA2*/*r2.z,
		-.68/*4KS:AAAY*/*r2.y - -.68/*4KS:AAA2*/*r2.x));
	if ( g < x)
			x = g, i = vec3(.7);


	float limit = -34*cos(v*3/*4KS:AppearFreq*/);
	if (r.x > limit)
		r.x=limit;

	// tiny slant
	r.x -= 0.1 *r.y;

	r.x+=29.94/*4KS:LogoX*/;

	// F
	g=sd_Rect(r,vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1));

	g=min(g, sd_Rect(r-vec3(2.9/*4KS:LogoFBarLength*/-.5*1.3/*4KS:LogoThickness*/,0,0), 
						vec3(2.9/*4KS:LogoFBarLength*/,1.3/*4KS:LogoThickness*/,1)));

	g=min(g, max(sd_Rect(r-vec3(3.54/*4KS:LogoFHeadLength*/-.5*1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0),
						vec3(3.54/*4KS:LogoFHeadLength*/,1.3/*4KS:LogoThickness*/,1)),
				  r.x-3.54/*4KS:LogoFHeadLength*/*2+.5*1.3/*4KS:LogoThickness*/ - .5*(r.y- 5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/ )
						));

	// U 
	r.x-=13.25/*4KS:LogoOffsetU*/;
	g=min(g,sd_Rect(r+vec3(-.5*1.3/*4KS:LogoThickness*/,0,0),vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1)));
	r2 = r;
	g=min(g, max(r2.y,max(r2.x,max(length(r2.xy)-(5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/),
					-length(r2.xy)+(5.03/*4KS:LogoHeight*/-1.5*1.3/*4KS:LogoThickness*/) ) ) )		
		);

	g=min(g,max(-r.y,sd_Rect(r+vec3(5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0,0),vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1))));

	// L
	r.x-=4.47/*4KS:LogoOffsetL*/;

	g=min(g, sd_Rect(r,vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1)));

	g=min(g, sd_Rect(r-vec3(2.9/*4KS:LogoLBarLength*/-.5*1.3/*4KS:LogoThickness*/,-5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,0), 
						vec3(2.9/*4KS:LogoLBarLength*/,1.3/*4KS:LogoThickness*/,1)));

	// C
	r.x-=10.03/*4KS:LogoOffsetC*/;

	r2 = r;
	g=min(g, max(r2.x,max(length(r2.xy)-(5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/),
					-length(r2.xy)+(5.03/*4KS:LogoHeight*/-1.5*1.3/*4KS:LogoThickness*/) ) )
		);
	r2.y=abs(r2.y);
	g=min(g, sd_Rect(r2-vec3(1.5/*4KS:LogoCBarLength*/-.5*1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0), 
						vec3(1.5/*4KS:LogoCBarLength*/,1.3/*4KS:LogoThickness*/,1)));

	
	g=max(g,min(r.y,r.x-1.5/*4KS:LogoCBarLength*/*2+1*1.3/*4KS:LogoThickness*/ - .5*(r.y- 5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/ )));

	// R 

	r.x-=4.39/*4KS:LogoOffsetR*/;

	// Loop of R
	r2=r;
	r2.y-=.5*5.03/*4KS:LogoHeight*/-.25*1.3/*4KS:LogoThickness*/;
	r2.y=abs(r2.y);
	r2.y+=.5*5.03/*4KS:LogoHeight*/-.25*1.3/*4KS:LogoThickness*/;

	g=min(g, sd_Rect(r2-vec3(1.5*1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0), 
						vec3(1.5*1.3/*4KS:LogoThickness*/,1.3/*4KS:LogoThickness*/,1)));

	r2 = r;
	r2.x-=2.5*1.3/*4KS:LogoThickness*/;
	r2.y-=.5*5.03/*4KS:LogoHeight*/-.25*1.3/*4KS:LogoThickness*/;
	g=min(g, max(-r2.x,max(length(r2.xy)-(.5*5.03/*4KS:LogoHeight*/+.75*1.3/*4KS:LogoThickness*/),
				-length(r2.xy)+(.5*5.03/*4KS:LogoHeight*/-1.25*1.3/*4KS:LogoThickness*/) ) ) );

	// diagonal bar of R + spacecut
	
	r2=r;
	r2.x-=2.5*1.3/*4KS:LogoThickness*/;
	rot(r2.xy,-1.12/*4KS:LogoRBarAngle*/);
	g=min(g, sd_Rect(r2-vec3(5.47/*4KS:LogoRBarLength*/-.5*1.3/*4KS:LogoThickness*/,0,0), vec3(5.47/*4KS:LogoRBarLength*/,.9*1.3/*4KS:LogoThickness*/,1)));

	g=max(g,min(r.x,-r2.y-.9*1.3/*4KS:LogoThickness*/)); // spacecut

	g=min(g, sd_Rect(r,vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1)));

	// U 
	r.x-=13.25/*4KS:LogoOffsetU2*/;
	g=min(g,sd_Rect(r+vec3(-.5*1.3/*4KS:LogoThickness*/,0,0),vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1)));
	r2 = r;
	g=min(g, max(r2.y,max(r2.x,max(length(r2.xy)-(5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/),
					-length(r2.xy)+(5.03/*4KS:LogoHeight*/-1.5*1.3/*4KS:LogoThickness*/) ) ) )		
		);

	g=min(g,max(-r.y,sd_Rect(r+vec3(5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0,0),vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1))));

	// M

	r.x-=9.48/*4KS:LogoOffsetM*/;

	r.x = abs(r.x);
	r.x-=1.06/*4KS:LogoMWidth*/*5.03/*4KS:LogoHeight*/;
	g=min(g, sd_Rect(r,vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1)));

	r2=r;
	r2.x+=1.3/*4KS:LogoThickness*/;
	r2.y-=5.03/*4KS:LogoHeight*/;
	rot(r2.xy,+4.31/*4KS:LogoMBarAngle*/);
	g=min(g, max(-r.y-5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,sd_Rect(r2-vec3(6.57/*4KS:LogoMBarLength*/-.5*1.3/*4KS:LogoThickness*/,0,0), vec3(6.57/*4KS:LogoMBarLength*/,.9*1.3/*4KS:LogoThickness*/,1))));

	// limit everything above/below.
	r.y=abs(r.y);
	g=max(g, +r.y-5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/);
	
	// limit everything in depth
	g = max(g, abs(r.z)- 1/*4KS:LogoDepth*/);
	if(g<x)
		x=g,i=vec3(.3);

	return x;
}

void main()
{	
	float z;
	int e=0;

   vec3 m=normalize(vec3(gl_FragCoord.xy/(resY*.5)-vec2(resX/resY,1),2)), //dir
		w=vec3(0,.41,.91);
	rot(w.xz,-5.02/*4KS:SunPos*/);
  

    r=vec3(.01/*4KS:RM_HitDist:3*/,100/*4KS:RM_MaxDist:0*/,.5/*4KS:AO*/); // hitstate

	 // camera
   vec3 g=vec3(0/*4KS:CamX*/,-.5/*4KS:CamY*/,-38.5/*4KS:CamZ*/);  
   rot(m.zy,-0/*4KS:CamLookDown*/);      
   rot(m.xz,+0/*4KS:CamLookRight*/);      
   
   vec3 p=g;
   z=scene(p);

   for(;e<150/*4KS:RM_MaxSteps:3*/&&abs(z)>r.x&&length(p-g)<r.y;e++) // march TODO: remove steps or horizon?
     p+=z*m,z=scene(p);

	// Mercury trick: take tiny step back to avoid stepping in the object and messing up the normals
	z=scene(p+=m*(scene(p)-.01));

    i += normalize(vec3(scene(p+vec3(.0001,0,0)),scene(p+vec3(0,.0001,0)),scene(p+vec3(0,0,.0001)))-z); //normal
	
    if(z>.3/*4KS:RM_NoHitDist*/) // pure sky
      i=vec3(.5/*4KS:SkyColR*/,.5/*4KS:SkyColG*/,.9/*4KS:SkyColB*/);
     
	my_out = vec4(i, 1.0);
}