import { resizeGame } from './resizeCanvas.js'
import { make_filled_maze } from './mazeGenerator.js'
import { detectScreenSize, getRandomCell }  from './mazeHelpers.js'
import { resetSim } from './reset.js'

function startSim() {

  let h = 800
  let w = 800

  //needs to be adjusted with resolution
  const cellSize = 100;
  const halfCellSize = parseInt(cellSize / 2);

  //import generated maze Data
  let Data = make_filled_maze(h, w, cellSize, halfCellSize);
  console.log(Data[0])
  let hor = Data[0]
  let ver = Data[1]

  var Engine = Matter.Engine,
      Render = Matter.Render,
      Runner = Matter.Runner,

      Composites = Matter.Composites,
      Common = Matter.Common,
      MouseConstraint = Matter.MouseConstraint,
      Mouse = Matter.Mouse,
      World = Matter.World,
      Bodies = Matter.Bodies;

  // create engine
  var engine = Engine.create(),
      world = engine.world;

  // create renderer
  var render = Render.create({
      element: document.body,
      //canvas: document.querySelector('#myCanvas'),
      engine: engine,
      options: {
          width: w,
          height: h,
          showAngleIndicator: false,
          background: 'white',
          wireframes: false
      }
  });

  Render.run(render);

  // create runner
  var runner = Runner.create();
  Runner.run(runner, engine);

  let CellCenters = Data[4]
  let ballSpawnPoint = getRandomCell(CellCenters)

  // add bodies
  var ball = Matter.Bodies.circle(ballSpawnPoint.x, ballSpawnPoint.y, halfCellSize-10, {
      density: 0.006,
      restitution: 0.5,
      render: {
        fillStyle: 'black'
      }
  })
  console.log(ball)

  //abstracting wall creation

  function wall(x, y, width, height) {
    return Matter.Bodies.rectangle(x,y, width, height, {
      isStatic: true,
      render: {
        fillStyle: 'black'
      }
    });
  }

  //Outer Walls
  World.add(world, [
      ball,
      Bodies.rectangle(w/2, 0, w, 2, { isStatic: true, fillStyle: 'black'}),
      Bodies.rectangle(w/2, h, w, 2, { isStatic: true, fillStyle: 'black'}),
      Bodies.rectangle(w, h/2, 2, h, { isStatic: true, fillStyle: 'black'}),
      Bodies.rectangle(0, h/2, 2, h, { isStatic: true, fillStyle: 'black'})
  ]);

  // Adding horizontal maze walls feed with Data
  // Struktur von Data verändern, inhalt von hor ver verändern, so dass notwendiges exportiert wird, funktion auslagern


  hor.forEach(function(line) {
    let mazeWall = wall(line.x1+halfCellSize-1, line.y1, cellSize+2, 3);
    Matter.World.add(world, mazeWall);
  });

  ver.forEach(function(line) {
    let mazeWall = wall(line.x1, line.y1+halfCellSize-1, 3, cellSize+2);
    World.add(engine.world, mazeWall);
  });
  //add goal body



  let goalSpawnPoint = getRandomCell(CellCenters)

  var goal = Bodies.circle(goalSpawnPoint.x, goalSpawnPoint.y, 5, {
          isSensor: true,
          isStatic: true,
          render: {
              fillStyle: 'transparent',
              lineWidth: 0
          }
      });

    var goalFrame = Bodies.circle(goalSpawnPoint.x, goalSpawnPoint.y, halfCellSize-5, {
            isSensor: true,
            isStatic: true,
            render: {
                strokeStyle: 'black',
                fillStyle: 'transparent',
                lineWidth: 2
              }
          });

  World.add(world, [
    goal, goalFrame
  ]);


var Events = Matter.Events

  // add collision event
  Events.on(engine, 'collisionStart', function(event) {
          var pairs = event.pairs;

          for (var i = 0, j = pairs.length; i != j; ++i) {
              var pair = pairs[i];

              if (pair.bodyA === goal) {
                  //console.log("Collision!")

                  setTimeout(resetSim(World, world, Engine, engine, Events, Runner, runner, render, Render), 9000);



              } else if (pair.bodyB === goal) {
                  //console.log("Collision!")


                  setTimeout(resetSim(World, world, Engine, engine, Events, Runner, runner, render, Render), 9000);
              }
          }
  });


  // add gyro control
  var updateGravity = function(event) {
      var orientation = typeof window.orientation !== 'undefined' ? window.orientation : 0,
          gravity = engine.world.gravity;

      if (orientation === 0) {
          gravity.x = Common.clamp(event.gamma, -90, 90) / 90;
          gravity.y = Common.clamp(event.beta, -90, 90) / 90;
      } else if (orientation === 180) {
          gravity.x = Common.clamp(event.gamma, -90, 90) / 90;
          gravity.y = Common.clamp(-event.beta, -90, 90) / 90;
      } else if (orientation === 90) {
          gravity.x = Common.clamp(event.beta, -90, 90) / 90;
          gravity.y = Common.clamp(-event.gamma, -90, 90) / 90;
      } else if (orientation === -90) {
          gravity.x = Common.clamp(-event.beta, -90, 90) / 90;
          gravity.y = Common.clamp(event.gamma, -90, 90) / 90;
      }
  };

  window.addEventListener('deviceorientation', updateGravity);

  // add mouse control
  var mouse = Mouse.create(render.canvas),
      mouseConstraint = MouseConstraint.create(engine, {
          mouse: mouse,
          constraint: {
              stiffness: 0.2,
              render: {
                  visible: false
              }
          }
      });

  World.add(world, mouseConstraint);

  // keep the mouse in sync with rendering
  render.mouse = mouse;

  // fit the render viewport to the scene
  Render.lookAt(render, {
      min: { x: 0, y: 0 },
      max: { x: w, y: h }
  });

  return {
      engine: engine,
      runner: runner,
      render: render,
      //canvas: render.canvas,
      // stop: function() {
      //     Matter.Render.stop(render);
      //     Matter.Runner.stop(runner);
      //    window.removeEventListener('deviceorientation', updateGravity);
      //}
  };
}
startSim()

export { startSim };

  //context for MatterTools.Demo
