from mikemath import randomUnit, scale
from PIL import Image
from math import acos, atan2, pi
import sys

filename = sys.argv[1]
ifile = open(filename)

verts = []
triangles = []

for line in ifile:
	data = line.split()
	if data[0] == 'v':
		verts.append([float(x) for x in data[1:]])
	elif data[0] == 'f':
		v = [int(x) - 1 for x in data[1:]]
		assert(len(v) == 3) # triangles!
		triangles.append(v)

ifile.close()

water = Image.open('water_8k.png')
color = Image.open('2_no_clouds_8k.jpg')
elevation = Image.open('dem_large/16_bit_dem_large.tif')

def elevate(e, xyz):
	s = 1.0 + e / 1_000_000
	return scale(s, xyz)

invPi = 1 / pi
inv2pi = 1 / (2 * pi)

def sample(vec, img):
	theta = acos(vec[2]) # -0 .. +π
	phi = atan2(vec[1], vec[0]) # -π .. +π
	t = theta * invPi # 0 .. 1
	s = (phi + pi) * invPi * 0.5 # 0 .. 1
	x = int(s * img.size[0]) % img.size[0]
	y = int(t * img.size[1]) % img.size[1]
	return img.getpixel((x,y))

samples = []
reindex = []

for xyz in verts:
	e = sample(xyz, elevation)
	if e != 8068:
		samples.append(elevate(e, xyz))
		reindex.append(len(samples))
	else:
		reindex.append(None)

# export OBJ file format
for s in samples:
	print('v', *s)

for tri in triangles:
	indices = [reindex[i] for i in tri]
	if all(indices):
		print('f', *indices)



