#pragma once
#include "custom-types.h"
#include <cmath>
#include "/usr/include/gcc/darwin/default/ppc_intrinsics.h"

// fwd declarations
struct Vec3;
Vec3 operator + ( const Vec3& u, const Vec3& v );
Vec3 operator - ( const Vec3& u, const Vec3& v );
Vec3 operator * ( float s, const Vec3& u );
f32 dot( const Vec3& u, const Vec3& v );

struct Vec3
	{
//	static constexpr f32 epsilon { 0.001f };

	f32 x { 0.0f };
	f32 y { 0.0f };
	f32 z { 0.0f };

	// constructors
	Vec3() = default; // zero by default
	Vec3( f32 arg_x, f32 arg_y, f32 arg_z ) // arbitrary vector
		: x( arg_x ), y( arg_y ), z( arg_z )
		{ }

	// queries
//	f32 magnitude() const
//		{ return sqrt( mag2()); }

	f32 mag2() const
		{ return x*x + y*y + z*z; }

	Vec3 normalized() const
		{ return __frsqrtes(mag2()) * *this; }

	Vec3 dirTo(const Vec3& other) const
		{ return (other - *this).normalized(); }

	Vec3 operator - () const
	 	{ return { -x, -y, -z }; }
//	 	{ return Vec3( -x, -y, -z ); }
			
	// mutators
//	void normalize()
//		{ *this = normalized(); }
//			
//	void operator += ( const Vec3& u )
//		{ x += u.x; y += u.y; z += u.z; }
	};

// operators
//inline bool operator == ( const Vec3& u, const Vec3& v )
//	{ return (u-v).mag2() < Vec3::epsilon * Vec3::epsilon; }
//
//inline bool operator != ( const Vec3& u, const Vec3& v )
//	{ return not ( u == v ); }

//inline Vec3 operator + ( const Vec3& u, const Vec3& v )
//	{ return Vec3( u.x + v.x, u.y + v.y, u.z + v.z ); }

inline Vec3 operator - ( const Vec3& u, const Vec3& v )
	{ return Vec3( u.x - v.x, u.y - v.y, u.z - v.z ); }

inline Vec3 operator * ( float s, const Vec3& u )
	{ return Vec3( s * u.x, s * u.y, s * u.z ); }

inline f32 dot( const Vec3& u, const Vec3& v )
	{ return u.x * v.x + u.y * v.y + u.z * v.z; }

//inline Vec3 proj( const Vec3& u, const Vec3& v )
//	{ return dot( u, v ) / dot( v, v ) * v; }
//
//inline Vec3 cross( const Vec3& u, const Vec3& v )
//	{ return Vec3( u.y * v.z - u.z * v.y, u.z * v.x - u.x * v.z, u.x * v.y - u.y * v.x ); }
