﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using Newtonsoft.Json;

namespace GhostlyAi
{
    class Lilfire
    {
        private  NetworkStream _writer;
        private  Solver<Tile, Gamestate> _aStar;
        private  Tile[,] _map;
        private ConcurrentBag<Tuple<Tile, Tile>> _teleports = new ConcurrentBag<Tuple<Tile, Tile>>();
        private readonly List<Point> _lastPos = new List<Point>();
        private readonly Stopwatch _sw = new Stopwatch();
        private int _tick;
        private List<Tile> _target;
        private int _range = 8;
        private const int Recalcpath = 6;
        public const int Hcorrections = 5;

        public void Start(string host, int port, string name)
        {

            _aStar = new Solver<Tile, Gamestate>(null);
            var client = new TcpClient();

            try
            {
                Console.WriteLine("Connecting: " +host);

                
                client.Connect(host, 54321);
                Thread.Sleep(100);

                
                if (client.Connected)
                {
                    _writer = client.GetStream();
                    StreamReader reader = new StreamReader(client.GetStream(), Encoding.UTF8);
                    Console.WriteLine("Connected!");
                    Write("NAME " + name);
                    
                    while (client.Connected)
                    {
                        var json = reader.ReadLine();
                        var jsonMessage = JsonConvert.DeserializeObject<JsonMessage>(json);

                        switch (jsonMessage.Messagetype)
                        {
                            case "welcome":

                                break;

                            case "stateupdate":
                                var stateupdateObj = JsonConvert.DeserializeObject<Stateupdate>(json);

                                _map = stateupdateObj.Gamestate.Map.GetTileMap();
                                _lastPos.Add(new Point(stateupdateObj.Gamestate.You.X, stateupdateObj.Gamestate.You.Y));
                                AddPlayersToMap(_map, stateupdateObj.Gamestate);
                                stateupdateObj.Gamestate.Map.Teleports = _teleports;
                                _aStar.SearchSpace = _map;

                                Stateupdate(stateupdateObj.Gamestate);
                                break;

                            case "dead":

                                break;

                            case "endofround":

                                break;

                            case "startofround": // ugunstig da dette må gjøre hver runde og ikke vært game
                                _lastPos.Clear();
                                _tick = 0;
                                _target = null;
                                break;
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
                Console.ReadKey();
            }
        }

        private  void FindTeleports(object o)
        {
            _teleports = new ConcurrentBag<Tuple<Tile, Tile>>();
            var aStar = new Solver<Tile, Gamestate>(GetMapClone());
            var gamestate = o as Gamestate;

            if (gamestate == null)
                return;

            var teleportTiles = new List<Tuple<Tile, Tile>>();

            for (var x = 0; x < _map.GetLength(0); x++)
            {
                if ((_map[x, 0].TileType == TileType.Floor ||
                    _map[x, 0].TileType == TileType.Pellet ||
                     _map[x, 0].TileType == TileType.SuperPellet) &&
                    (_map[x, _map.GetLength(1) - 1].TileType == TileType.Floor ||
                     _map[x, _map.GetLength(1) - 1].TileType == TileType.Pellet ||
                     _map[x, _map.GetLength(1) - 1].TileType == TileType.SuperPellet))
                {
                    teleportTiles.Add(new Tuple<Tile, Tile>(_map[x, 0], _map[x, _map.GetLength(1) - 1]));
                }
            }

            for (var y = 0; y < _map.GetLength(1); y++)
            {
                if ((_map[0, y].TileType == TileType.Floor || _map[0, y].TileType == TileType.Pellet ||
                     _map[0, y].TileType == TileType.SuperPellet) &&
                    (_map[_map.GetLength(0) - 1, y].TileType == TileType.Floor ||
                     _map[_map.GetLength(0) - 1, y].TileType == TileType.Pellet ||
                     _map[_map.GetLength(0) - 1, y].TileType == TileType.SuperPellet))
                {
                    teleportTiles.Add(new Tuple<Tile, Tile>(_map[0, y], _map[_map.GetLength(0) - 1, y]));
                }
            }

            foreach (var teleportTile in teleportTiles)
            {
                var path = aStar.Search(new Point(gamestate.You.X, gamestate.You.Y), new Point(teleportTile.Item1.X, teleportTile.Item1.Y), gamestate);
                if (path != null)
                    _teleports.Add(teleportTile);
            }
        }

        private Tile[,] GetMapClone()
        {
            var clone = new Tile[_map.GetLength(0), _map.GetLength(1)];
            for (int x = 0; x < _map.GetLength(0); x++)
            {
                for (int y = 0; y < _map.GetLength(1); y++)
                {
                    clone[x, y] = new Tile
                    {
                        TileType = _map[x, y].TileType,
                        X = x,
                        Y = y,
                        F = _map[x, y].F,
                        G = _map[x, y].G,
                        H = _map[x, y].H
                    };
                }
            }
            return clone;
        }

        private  void Stateupdate(Gamestate gamestate)
        {
            if (_tick == 0)
            {
                new Thread(FindTeleports).Start(gamestate);
                foreach (var player in gamestate.Others.Where(p => p.Isdangerous))
                {
                    player.Isdangerous = false; //dette skal ikke skje
                }
                
            }

            if(_target != null && _target.Count == 1 && _target[0].X == gamestate.You.X && _target[0].Y == gamestate.You.Y)
                _target.Clear();


            _tick++;
            _sw.Restart();



            var allNeighbors = new List<Tile>();
            var neighbors = new List<Tile>();

            var pelletTilePath = new List<Tuple<List<Tile>, int>>();

            if (_target == null || !IsValid(gamestate) || _target.Count < Recalcpath)
            {
                var superPelletTilePath = GetBestPathToTileTypeWhereIclosest(gamestate,15, TileType.SuperPellet);
                if (superPelletTilePath.Any())
                {
                    var shortesSafePath = GetShortesBestPath(superPelletTilePath.ToList());
                    if (shortesSafePath.Any())
                    {
                        _target = shortesSafePath; //TEST
                        GoTo(gamestate, shortesSafePath.ElementAt(0));
                        if (_sw.ElapsedMilliseconds > 99)
                            Console.WriteLine("Hva tok for lang tid?");
#if DEBUG
                              Console.WriteLine(_tick + ": " + _sw.ElapsedMilliseconds);
#endif
                        return;
                    }
                }
                allNeighbors.Clear();
                neighbors.Clear();


                var range = _range; 
                var rangeIncresse = 4;
                pelletTilePath = GetBestPathToTileTypeWhereIclosest(gamestate, range,TileType.Pellet);

                while (pelletTilePath.Count == 0)
                {
#if DEBUG
#else
                    if (_sw.ElapsedMilliseconds > 90)
                        break;
#endif
                    range = range + rangeIncresse;

                    if (rangeIncresse > 1)
                    {
                        
                        rangeIncresse--;
                    }

                    pelletTilePath = GetBestPathToTileTypeWhereIclosest(gamestate, range,TileType.Pellet);

                    if (Math.Min(((range*2) + 1)*((range*2) + 1), _map.Length) == _map.Length)
                    {
                        if (pelletTilePath.Count == 0)
                        {
                            SetTarget(gamestate);
                            pelletTilePath.Add(new Tuple<List<Tile>, int>(_target, 0));
                        }
                        break;
                    }
                }
            }
            else
            {
                //_target.RemoveAt(0);

                var path = _aStar.Search(new Point(gamestate.You.X, gamestate.You.Y),new Point(_target.Last().X, _target.Last().Y), gamestate);

                if(path != null)
                    _target = path.ToList();

                if (_target == null || !_target.Any())
                    SetTarget(gamestate);

                pelletTilePath.Add(new Tuple<List<Tile>, int>(_target,0));
            }

            if (pelletTilePath.Any())
            {
                var shortesSafePath = GetShortesPath(pelletTilePath, gamestate);

                if (shortesSafePath != null && shortesSafePath.Any())
                {
                    if (_target != null && _target.Any())
                    {
                        //er faktisk ny kalkulert path bedre enn target?
                        var path = _aStar.Search(new Point(gamestate.You.X, gamestate.You.Y),new Point(_target.Last().X, _target.Last().Y), gamestate);

                        if (path != null)
                        {
                            _target = path.ToList();

                            if (_target.Last().Points * 2 / _target.Last().G > (shortesSafePath.Last().Points * 2) / shortesSafePath.Last().G)
                                shortesSafePath = _target;
                            else
                                _target = shortesSafePath;
                        }
                        else
                            _target = shortesSafePath;

                    }
                    else
                        _target = shortesSafePath;

//                    Tile blidTile;
//                    if (IsBlindGate(shortesSafePath, gamestate, out blidTile))
//                    {
//                        shortesSafePath = NewShortesSafePath(gamestate, blidTile, shortesSafePath);
//                    }

                    GoTo(gamestate, shortesSafePath.ElementAt(0)); 
                    var elapsedMilliseconds = _sw.ElapsedMilliseconds;
                    if (elapsedMilliseconds > 99)
                        Console.WriteLine(_tick + ": " + elapsedMilliseconds + "Hva tok for lang tid?");

#if DEBUG
                              Console.WriteLine(_tick + ": " + elapsedMilliseconds);
#endif

                    return;
                }
            }

            if (gamestate.You.Isdangerous)
            {
                var playerTilePath = GetShortestPathToTileType(gamestate, TileType.Player);
                if (playerTilePath.Any())
                {
                    var shortesBestPath = GetShortesPath(playerTilePath, gamestate);
                    if (shortesBestPath.Any())
                    {
                        var nextTile = shortesBestPath.ElementAt(0);
                        GoTo(gamestate, nextTile);
                        if (_sw.ElapsedMilliseconds > 99)
                            Console.WriteLine("Hva tok for lang tid?");
#if DEBUG
                              Console.WriteLine(_tick + ": " + _sw.ElapsedMilliseconds);
#endif
                        return;
                    }
                }
            }

            if (_target != null && _target.Any())
            {
//                Tile blidTile;
//                if (IsBlindGate(_target, gamestate, out blidTile))
//                {
//                    _target = NewShortesSafePath(gamestate, blidTile, _target);
//                }

                GoTo(gamestate, _target.ElementAt(0)); 
                _target.RemoveAt(0);
            }

            GoRandom();

            if (_sw.ElapsedMilliseconds > 80)
                Console.WriteLine("Hva tok for lang tid?");

#if DEBUG
                              Console.WriteLine(_tick + ": " + _sw.ElapsedMilliseconds);
#endif
        }

        private List<Tile> NewShortesSafePath(Gamestate gamestate, Tile blidTile, List<Tile> shortesSafePath)
        {
            if (gamestate.Others.Any(p => p.Isdangerous))
            {
                var blindPath = _aStar.Search(new Point(gamestate.You.X, gamestate.You.Y), new Point(blidTile.X, blidTile.Y),
                    gamestate);
                if (blindPath != null)
                {
                    foreach (var player in gamestate.Others.Where(p => p.Isdangerous))
                    {
                        var playerPath = _aStar.Search(new Point(player.X, player.Y),
                            new Point(gamestate.You.X, gamestate.You.Y), gamestate);

                        if (playerPath != null)
                        {
                            if (playerPath.Count < blindPath.Count*2)
                            {
                                //vil bli sperret inne

                                var myNeighbors = GetNeighbors(gamestate.You.X, gamestate.You.Y);

                                foreach (var n in myNeighbors.ToList())
                                {
                                    if (n.X == shortesSafePath.ElementAt(0).X && n.Y == shortesSafePath.ElementAt(0).Y)
                                        myNeighbors.Remove(n);

                                    else if (n.X == _lastPos[_lastPos.Count - 2].X && n.Y == _lastPos[_lastPos.Count - 2].Y)
                                        myNeighbors.Remove(n);
                                }

                                //skal være hvertfall 1 vei videre.

                                if (myNeighbors.Any())
                                {
                                    var newPath = new List<Tile>();

                                    if (myNeighbors.Count == 1)
                                        newPath.Add(myNeighbors.First());
                                    else newPath.Add(myNeighbors.First()); //TODO velge riktig vei

                                    _target = newPath;
                                    shortesSafePath = newPath;
                                }
                            }
                        }
                    }
                }
            }
            return shortesSafePath;
        }

        private bool IsBlindGate(List<Tile> target, Gamestate gamestate, out Tile blindTile)
        {
            blindTile = null;
            var tile = new Tile() {X = gamestate.You.X ,Y = gamestate.You.Y };
            var neighbors = GetNeighbors(tile.X, tile.Y);
            neighbors = neighbors.Where(n => n.IsWalkable(gamestate)).ToList();

            if (neighbors.Count <= 2)
            {
                return false; //er ikke noe kryss så samma faen :P
            }
            var lastTile = tile;
            tile = target.ElementAt(0);

            while (neighbors.Any())
            {
                
                neighbors = GetNeighbors(tile.X, tile.Y);
                neighbors = neighbors.Where(n => n.IsWalkable(gamestate)).ToList();
                //neighbors = neighbors.Where(n => n.X != lastTile.X && n.Y != lastTile.Y).ToList();

                foreach (var n in neighbors.ToList())
                {
                    if (n.X == lastTile.X && n.Y == lastTile.Y)
                        neighbors.Remove(n);
                }

                if (neighbors.Count == 1)
                {
                    lastTile = tile;
                    tile = neighbors[0];
                }
                else if (neighbors.Count == 0)
                {
                    blindTile = tile;
                    return true;
                }
                else
                    return false; //flere veier ut
            }
            
            return false;
        }

        private void GoRandom()
        {
            var random = new Random();
            var move = random.Next(3);

            switch (move)
            {
                case 0:
                    Write("UP");
                    break;

                case 1:
                    Write("DOWN");
                    break;

                case 2:
                    Write("LEFT");
                    break;

                case 3:
                    Write("RIGHT");
                    break;
            }
        }

        private void SetTarget(Gamestate gamestate)
        {
            

            var range = 15;
            var pelletTilePath = GetBestPathToTileTypeWhereIclosest(gamestate, range, TileType.Pellet);
            
            if (pelletTilePath.Any())
            {
                var shortesSafePath = GetShortesBestPath(pelletTilePath.ToList());
                if (shortesSafePath.Any())
                    _target = shortesSafePath;
            }
            else
            {
                var pelletTilePaths = GetTilesOfType(TileType.Pellet);
                double bestDistd = -999;
                Tile targetTile = null;

                foreach (var tile in pelletTilePaths)
                {
                    var myDist = _aStar.Heuristic(new Point(gamestate.You.X, gamestate.You.Y),new Point(tile.X, tile.Y), gamestate);
                    var payersDist = gamestate.Others.Sum(player => _aStar.Heuristic(new Point(player.X, player.Y), new Point(tile.X, tile.Y), gamestate));
                    payersDist = payersDist/gamestate.Others.Count;

                    var distD = myDist - payersDist;

                    if (distD > bestDistd)
                    {
                        bestDistd = distD;
                        targetTile = tile;
                    }
                }

                if (targetTile != null)
                {
                    var path = _aStar.Search(new Point(gamestate.You.X, gamestate.You.Y), new Point(targetTile.X, targetTile.Y), gamestate);

                    if (path != null)
                        _target = path.ToList();
                }
            }
        }

        private List<Tile> GetTilesOfType(TileType tileType)
        {
            return _map.Cast<Tile>().Where(tile => tile.TileType == tileType).ToList();
        }
        private bool IsValid(Gamestate gamestate)
        {
            if (_target == null || !_target.Any())
                return false;

            var tileStilTargettype =_map[_target.Last().X, _target.Last().Y].TileType == _target.Last().TileType;
            if (!tileStilTargettype)
                return false;

            foreach (var player in gamestate.Others)
            {
                var playerPath = _aStar.Search(new Point(player.X, player.Y),new Point(_target.Last().X, _target.Last().Y), gamestate);
                if (playerPath!= null && playerPath.Count < _target.Count)
                    return false;
            }

            return true;

        }

        private  List<Tile> GetShortesBestPath(List<Tuple<List<Tile>, int>> superPelletTilePath)
        {
            var lf = superPelletTilePath.Min(p => p.Item1.Last().F);
            var bestPaths = superPelletTilePath.Where(p => p.Item1.Last().F == lf).Select(o => o.Item1).ToList();

            var sp = bestPaths.Min(p => p.Count);

            var shortestBestPahts = bestPaths.Where(p => p.Count == sp).ToList();

            if (shortestBestPahts.Any())
            {
                if (shortestBestPahts.Count == 1)
                    return shortestBestPahts.First();

                return shortestBestPahts.First(); //TODO finne hva som er best
            }
            return new List<Tile>();
        }

        private  void AddPlayersToMap(Tile[,] map, Gamestate gamestate)
        {
            foreach (var player in gamestate.Others)
            {
                map[player.X, player.Y].TileType = TileType.Player;
            }
        }

        private  void GoTo(Gamestate gamestate, Tile nextTile)
        {
            if (!gamestate.You.Isdangerous && !IsSafe(nextTile, 2, gamestate))
            {
                var neighbors = GetNeighbors(gamestate.You.X, gamestate.You.Y).Where(n => n.IsWalkable(gamestate)).ToList();

                foreach (var n in neighbors.ToList())
                {
                    if (n.X == nextTile.X && n.Y == nextTile.Y)
                        neighbors.Remove(n);
                }

                if (neighbors.Any())
                {
                    // ReSharper disable once ConvertIfStatementToConditionalTernaryExpression
                    if (neighbors.Count == 1)
                        nextTile = neighbors.First();
                    else
                    {
                        nextTile = neighbors.First(); //TODO velge riktig vei
                    }
                }
            }

            if (_lastPos.Count >= 3)
            {
                if (nextTile.X == _lastPos[_lastPos.Count - 2].X && nextTile.Y == _lastPos[_lastPos.Count - 2].Y && _lastPos[_lastPos.Count - 1].X == _lastPos[_lastPos.Count - 3].X && _lastPos[_lastPos.Count - 1].Y == _lastPos[_lastPos.Count - 3].Y)
                {

                    {
                        var neighbors = GetNeighbors(gamestate.You.X, gamestate.You.Y);

                        foreach (var neighbor in neighbors.ToList())
                        {
                            if (neighbor.X == nextTile.X && neighbor.Y == nextTile.Y)
                                neighbors.Remove(neighbor);
                            else if (!neighbor.IsWalkable(gamestate))
                                neighbors.Remove(neighbor);
                        }

                        if (neighbors.Any())
                        {
                            if (neighbors.Count > 1)
                            {
                                var rnd = new Random();
                                nextTile = neighbors[rnd.Next(0, neighbors.Count)];
                            }
                            else
                                nextTile = neighbors.First();
                        }

                        if (nextTile.X == _lastPos[_lastPos.Count - 2].X && nextTile.Y == _lastPos[_lastPos.Count - 2].Y)
                        {
                            Console.WriteLine("Tilbake?");
                        }
                    }
                }
            }

            if (gamestate.You.X == nextTile.X && gamestate.You.Y == nextTile.Y)
            {
                var neighbors = GetNeighbors(gamestate.You.X, gamestate.You.Y);

                foreach (var neighbor in neighbors.ToList())
                {
                    if (!neighbor.IsWalkable(gamestate))
                        neighbors.Remove(neighbor);
                }

                if (neighbors.Any())
                {
                    if (neighbors.Count > 1)
                    {
                        var rnd = new Random();
                        nextTile = neighbors[rnd.Next(0, neighbors.Count)];
                    }
                    else
                        nextTile = neighbors.First();
                }
            }

            if (!nextTile.IsWalkable(gamestate))
            {
                Console.WriteLine("wtf?");
            }

            if (nextTile.Y < gamestate.You.Y || (gamestate.You.Y == 0) && nextTile.Y > gamestate.You.Y)
                Write("UP");
            else if (nextTile.Y > gamestate.You.Y ||
                     (gamestate.You.Y == gamestate.Map.Height - 1 && nextTile.Y < gamestate.You.Y))
                Write("DOWN");
            else if (nextTile.X < gamestate.You.X || (gamestate.You.X == 0 && nextTile.X > gamestate.You.X))
                Write("LEFT");
            else if (nextTile.X > gamestate.You.X ||
                     (gamestate.You.X == gamestate.Map.Width - 1 && nextTile.X < gamestate.You.X))
                Write("RIGHT");
            else
            {
                Console.WriteLine("Go ????");
            }
        }

        private  bool IsSafe(Tile nextTile, int range, Gamestate gamestate)
        {
            var tiles = gamestate.Others.Where(p => p.Isdangerous).Select(player => new Point(player.X, player.Y)).ToList();

            var allNeighbors = new List<Tile>();
            var newNeighbors = new List<Tile>();
            foreach (var tile in tiles)
            {
                allNeighbors.AddRange(GetNeighbors(tile.X, tile.Y));
                newNeighbors.AddRange(GetNeighbors(tile.X, tile.Y));
            }

            range--;

            while (range > 0)
            {
                var neighbors = newNeighbors.ToList();
                newNeighbors.Clear();

                foreach (var newNeighbor in neighbors)
                {
                    allNeighbors.AddRange(GetNeighbors(newNeighbor.X, newNeighbor.Y));
                    newNeighbors.AddRange(GetNeighbors(newNeighbor.X, newNeighbor.Y));
                }

                range--;
            }

            foreach (var neighbor in allNeighbors)
            {
                if (neighbor.X == nextTile.X && neighbor.Y == nextTile.Y)
                    return false;
            }

            return true;
        }

        private  bool IsSafe(Tile nextTile, Gamestate gamestate)
        {
            foreach (var player in gamestate.Others.Where(p => p.Isdangerous))
            {
                var neighbors = GetNeighbors(player.X, player.Y);

                foreach (var neighbor in neighbors)
                {
                    if (neighbor.X == nextTile.X && neighbor.Y == nextTile.Y)
                        return false;
                }
            }

            return true;
        }

        private  List<Tile> GetShortesPath(List<Tuple<List<Tile>, int>> tilePath, Gamestate gamestate)
        {
            var shortestPaths = tilePath.Where(p => p.Item2 == tilePath.Select(tp => tp.Item2).Min()).ToList();


            if (shortestPaths.Count == 1)
                return shortestPaths[0].Item1;

            return GetShortesBestAlternativePath(tilePath, gamestate);
        }

        private  List<Tile> GetShortesBestAlternativePath(List<Tuple<List<Tile>, int>> tilePath, Gamestate gamestate)
        {
            var range = _range;
            var possiblePathToTileTypes = GetBestPossiblePathToTileType(gamestate, range, tilePath.First().Item1.Last().TileType).ToList();

            while (!possiblePathToTileTypes.Any() && range*range < _map.Length)
            {
                range++;
                possiblePathToTileTypes = GetBestPossiblePathToTileType(gamestate, range, tilePath.First().Item1.Last().TileType).ToList();
            }

            if (possiblePathToTileTypes.Any())
            {
                if (possiblePathToTileTypes.Count == 1)
                    return possiblePathToTileTypes[0].Item1;


                for (var index = 0; index < possiblePathToTileTypes.Count; index++)
                {
                    var possiblePathToTileType = possiblePathToTileTypes[index];
                    Tile secondLastTile = null;
                    if(possiblePathToTileType.Item1.Count > 1)
                    {
                        secondLastTile = possiblePathToTileType.Item1[possiblePathToTileType.Item1.Count - 2];
                    }
                    var lastTile = possiblePathToTileType.Item1.Last();

                    var neighbors = GetNeighbors(lastTile.X, lastTile.Y);

                    foreach (var neighbor in neighbors.ToList())
                    {
                        if (secondLastTile != null && neighbor.X == secondLastTile.X && neighbor.Y == secondLastTile.Y)
                            neighbors.Remove(neighbor);
                        else if (!neighbor.IsWalkable(gamestate))
                            neighbors.Remove(neighbor);
                    }


                    var v = 0;
                    foreach (var neighbor in neighbors)
                    {
                        if (neighbor.TileType == TileType.Pellet)
                            v++;
                        else if (neighbor.TileType == TileType.SuperPellet)
                            v += 10;
                    }
                        
                    possiblePathToTileTypes[index] = new Tuple<List<Tile>, int>(possiblePathToTileTypes[index].Item1, v);
                }


                var shortesBestAlternativePath = possiblePathToTileTypes.FirstOrDefault(shbap => shbap.Item2 == possiblePathToTileTypes.Max(o => o.Item2));


                return shortesBestAlternativePath != null ? shortesBestAlternativePath.Item1 : new List<Tile>();
            }

            return new List<Tile>();
        }

        
        private IEnumerable<Tuple<List<Tile>, int>> GetBestPossiblePathToTileType(Gamestate gamestate, int range,params TileType[] tiles)
        {
            var heuristicValues = GetHeuristicValues(gamestate, range, tiles, gamestate.You.X, gamestate.You.Y);
            heuristicValues = heuristicValues.OrderByDescending(o => o.Item2).ToList();
            return BestPathToTileType(gamestate, heuristicValues);
        }

        private IEnumerable<Tuple<List<Tile>, int>> BestPathToTileType(Gamestate gamestate, List<Tuple<Tile, double>> heuristicValues)
        {
            var bestPaths = new List<Tuple<List<Tile>, int>>();
            bool removeShorterPaths = !(heuristicValues.Count <= 5);
            while (heuristicValues.Any())
            {
#if DEBUG
#else
                if (_sw.ElapsedMilliseconds > 80)
                    break;
            #endif

                var hm = heuristicValues.Max(p => p.Item2);
                foreach (var heuristicValue in heuristicValues.Where(p => p.Item2 == hm).ToList())
                {
                    var tile = heuristicValue.Item1;
                    var skip = false;
                    foreach (var player in gamestate.Others)
                    {
                        
                        if (_aStar.Heuristic(new Point(player.X, player.Y), new Point(tile.X, tile.Y), gamestate) <
                            heuristicValue.Item2-Hcorrections)
                        {
                            skip = true;
                            heuristicValues.Remove(heuristicValue);
                            break;
                        }
                    }

                    if (skip)
                        continue;

                    var tilePath = _aStar.Search(new Point(gamestate.You.X, gamestate.You.Y), new Point(tile.X, tile.Y),
                        gamestate);
                    if (tilePath != null)
                    {
                        bestPaths.Add(new Tuple<List<Tile>, int>(tilePath.ToList(), tilePath.Count));

                        if (removeShorterPaths)
                        {
                            foreach (var pathTile in tilePath)
                            {
                                var p =
                                    heuristicValues.FirstOrDefault(o => o.Item1.X == pathTile.X && o.Item1.Y == pathTile.Y);
                                if (p != null)
                                {
                                    heuristicValues.Remove(p);
                                }
                            }
                        }
                        else
                        {
                            heuristicValues.Remove(heuristicValue);
                        }
                    }
                    else
                    {
                        heuristicValues.Remove(heuristicValue);
                    }
                }
            }
            if (bestPaths.Any())
            {

                if (bestPaths.Count == 1)
                    return bestPaths;


                var orgBestPaths = bestPaths.ToList();





                //ny liste - fin beste og sjek om i faktisk er nærmest

                var bestPathsTemp = new List<Tuple<List<Tile>, int>>();

                while (!bestPathsTemp.Any() && bestPaths.Any())
                {
                    var max = bestPaths.Max(o => (o.Item1.Last().Points * 2) / o.Item1.Last().G);
                    bestPathsTemp = bestPaths.Where(bp => (bp.Item1.Last().Points * 2) / bp.Item1.Last().G == max).ToList();
                    bestPathsTemp = bestPathsTemp.Where(bp => bp.Item1.Last().Points == bestPathsTemp.Max(o => o.Item1.Last().Points)).ToList();


                    RemoveFalsePaths(gamestate, bestPathsTemp, bestPaths);
                }
                if(bestPathsTemp.Any())
                {
                    return bestPathsTemp;
                }
                else
                {
                    var max = orgBestPaths.Max(o => (o.Item1.Last().Points * 2) / o.Item1.Last().G);
                    bestPaths = orgBestPaths.Where(bp => (bp.Item1.Last().Points * 2) / bp.Item1.Last().G == max).ToList();
                    bestPaths = bestPaths.Where(bp => bp.Item1.Last().Points == bestPaths.Max(o => o.Item1.Last().Points)).ToList();
                    return bestPaths;
                }


            }

            return new List<Tuple<List<Tile>, int>>();
        }

        private void RemoveFalsePaths(Gamestate gamestate, List<Tuple<List<Tile>, int>> bestPathsTemp, List<Tuple<List<Tile>, int>> bestPaths)
        {
            foreach (var tuple in bestPathsTemp.ToList())
            {
                var tile = tuple.Item1.Last();

                double closestPlayerHDist = 9999;
                var closestPlayerPoint = new Point(0, 0);

                foreach (var player in gamestate.Others)
                {
                    var playerHeuristic = _aStar.Heuristic(new Point(player.X, player.Y), new Point(tile.X, tile.Y), gamestate);
                    if (playerHeuristic < closestPlayerHDist)
                    {
                        closestPlayerHDist = playerHeuristic;
                        closestPlayerPoint = new Point(player.X, player.Y);
                    }
                }

                var closestPlayerDist = _aStar.Search(closestPlayerPoint, new Point(tile.X, tile.Y), gamestate);

                if (closestPlayerDist != null)
                {
                    if (closestPlayerDist.Count < tuple.Item2)
                    {
                        //han er faktisk nærmere fjern fra bestpaths.
                        bestPaths.Remove(tuple);
                        bestPathsTemp.Remove(tuple);
                    }
                }
            }
        }

        private List<Tuple<Tile, double>> GetHeuristicValues(Gamestate gamestate, int range, TileType[] tiles, int fromX, int fromY)
        {
            var minX = fromX - range;
            var maxX = fromX + range;

            var minY = fromY - range;
            var maxY = fromY + range;

            var minXd = 0;
            var maxXd = 0;

            var minYd = 0;
            var maxYd = 0;

            if (minX < 0)
            {
                minXd = Math.Abs(minX);
                minX = 0;
            }

            if (maxX > _map.GetLength(0) - 1)
            {
                maxXd = maxX - _map.GetLength(0) - 1;
                maxX = _map.GetLength(0) - 1;
            }

            if (minY < 0)
            {
                minYd = Math.Abs(minY);
                minY = 0;
            }

            if (maxY > _map.GetLength(1) - 1)
            {
                maxYd = maxY - _map.GetLength(1) - 1;
                maxY = _map.GetLength(1) - 1;
            }


            var paths = new List<Tuple<Tile, double>>();
            var teleportRange = new List<int>() { minXd, maxXd, minYd, maxYd }.Max();

            for (var x = minX; x <= maxX; x++)
            {
                for (var y = minY; y <= maxY; y++)
                {
                    if(x == fromX && y == fromY)
                        continue;

                    var tile = _map[x, y];
                    if (tiles.Contains(tile.TileType))
                    {
#if DEBUG
#else
                        if (_sw.ElapsedMilliseconds > 90)
                            break;
#endif
                        var heuristic = _aStar.Heuristic(new Point(fromX, fromY),new Point(x, y), gamestate);

                        paths.Add(new Tuple<Tile, double>(tile, heuristic));
                    }

                    foreach (var teleport in _teleports)
                    {
                        if (teleport.Item1.X == tile.X && teleport.Item1.Y == tile.Y)
                            paths.AddRange(GetHeuristicValues(gamestate, teleportRange, tiles, teleport.Item2.X,
                                teleport.Item2.Y));
                        else if (teleport.Item2.X == tile.X && teleport.Item2.Y == tile.Y)
                            paths.AddRange(GetHeuristicValues(gamestate, teleportRange, tiles, teleport.Item1.X,
                                teleport.Item1.Y));
                    }
                }
            }
            return paths;
        }

        private  List<Tile> GetNeighbors(int x, int y)
        {
            return new List<Tile>
            {
                x - 1 >= 0 ? _map[x - 1, y] : _map[_map.GetLength(0) - 1, y],
                x + 1 < _map.GetLength(0) ? _map[x + 1, y] : _map[0, y],
                y - 1 >= 0 ? _map[x, y - 1] : _map[x, _map.GetLength(1) - 1],
                y + 1 < _map.GetLength(1) ? _map[x, y + 1] : _map[x, 0]
            };
        }

        private  List<Tuple<LinkedList<Tile>, int>> GetPathToTileType(Gamestate gamestate, params TileType[] tiles)
        {
            var paths = new List<Tuple<LinkedList<Tile>, int>>();
            foreach (var tile in _map)
            {
                if (tiles.Contains(tile.TileType))
                {
                    var tilePath = _aStar.Search(new Point(gamestate.You.X, gamestate.You.Y), new Point(tile.X, tile.Y), gamestate);
                    if (tilePath != null)
                    {
                        paths.Add(new Tuple<LinkedList<Tile>, int>(tilePath, tilePath.Count));
                    }
                }
            }
            return paths;
        }

        private  List<Tuple<List<Tile>, int>> GetShortestPathToTileType(Gamestate gamestate, params TileType[] tileTypes)
        {
            var paths = new List<Tuple<List<Tile>, int>>();
            var tiles = new List<Tuple<Tile, double>>();
            foreach (var tile in _map)
            {
                if (tileTypes.Contains(tile.TileType))
                {
                    //var m = _aStar.Mhd(new Point(gamestate.You.X, gamestate.You.Y), new Point(tile.X, tile.Y));
                    var m = _aStar.Heuristic(new Point(gamestate.You.X, gamestate.You.Y), new Point(tile.X, tile.Y), gamestate);
                    tiles.Add(new Tuple<Tile, double>(tile, m));
                }
            }

            if (!tiles.Any())
                return paths;

            var sh = tiles.Min(t => t.Item2);

            foreach (var t in tiles.Where(t => t.Item2 == sh).Select(o => o.Item1))
            {
                var tilePath = _aStar.Search(new Point(gamestate.You.X, gamestate.You.Y), new Point(t.X, t.Y), gamestate);
                if (tilePath != null)
                {
                    paths.Add(new Tuple<List<Tile>, int>(tilePath.ToList(), tilePath.Count));
                }
            }

            return paths;
        }

        private List<Tuple<List<Tile>, int>> GetBestPathToTileTypeWhereIclosest(Gamestate gamestate, int range, params TileType[] tileTypes)
        {
            return GetBestPossiblePathToTileType(gamestate, range, tileTypes).ToList();
        }

        private  void GetNeighbors(ref List<Tile> neighbors, ref List<Tile> allNeighbors)
        {
            var n = neighbors.ToList();
            neighbors.Clear();

            foreach (var neighbor in n.ToList())
            {
                n = (GetNeighbors(neighbor.X, neighbor.Y));

                foreach (var tile in n)
                {
                    if (!allNeighbors.Contains(tile))
                    {
                        allNeighbors.Add(tile);
                        neighbors.Add(tile);
                    }
                }
            }
        }

        private  void Write(string message)
        {
            var data = new ASCIIEncoding().GetBytes(message); 
            _writer.Write(data, 0, data.Length);
        }
    }
}
