using System;
using System.Drawing;

namespace GhostlyAi
{
    public class Solver<TPathNode, TUserContext> : SpatialAStar<TPathNode, TUserContext> where TPathNode : IPathNode<TUserContext>
    {
        public override double Heuristic(Point start, Point end, TUserContext inUserContext)
        {
            double minH = 999999;

            var gamestate = inUserContext as Gamestate;
            if (gamestate != null)
            {
                foreach (var teleport in gamestate.Map.Teleports)
                {
                    var p1 = Mhd(start, new Point(teleport.Item1.X, teleport.Item1.Y));
                    var p2 = Mhd(new Point(teleport.Item2.X,teleport.Item2.Y), end);
                    
                    var h = p1 + p2 + 1;
                    
                    if (h < minH)
                        minH = h;
                    
                    p1 = Mhd(start,new Point(teleport.Item2.X, teleport.Item2.Y));
                    p2 = Mhd(new Point(teleport.Item1.X, teleport.Item1.Y),end);

                    h = p1 + p2 + 1;

                    if (h < minH)
                        minH = h;
                }
            }

            var heuristic = Mhd(start, end);

            if (heuristic < minH)
                minH = heuristic;

            return minH;
        }

        public double Mhd(Point inStart, Point inEnd)
        {
            return Math.Abs(inStart.X - inEnd.X) + Math.Abs(inStart.Y - inEnd.Y);
        }

        protected override double NeighborDistance(PathNode inFrom, PathNode inTo, PathNode endPathNode, TUserContext inUserContext)
        {
            //TODO if Lastpos (end) contains inTo  strre kost?

            

            if (endPathNode.UserContext.TileType == TileType.SuperPellet)
            {
                if (inTo.UserContext.TileType == TileType.SuperPellet) return 1;
                if (inTo.UserContext.TileType == TileType.Pellet) return 2;
                if (inTo.UserContext.TileType == TileType.Floor || inTo.UserContext.TileType == TileType.Door) return 10;
            }
            else
            {
                if (inTo.UserContext.TileType == TileType.SuperPellet) return 1;
                if (inTo.UserContext.TileType == TileType.Pellet) return 2;
                if (inTo.UserContext.TileType == TileType.Floor || inTo.UserContext.TileType == TileType.Door) return 15;
            }


            var gs = inUserContext as Gamestate;
            if (gs != null && gs.You.Isdangerous && inTo.UserContext.TileType == TileType.Player) return -20;

            return 1;
        }

        public Solver(TPathNode[,] inGrid)
            : base(inGrid)
        {
        }
    }
}