#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;

uniform vec2 direction = vec2(1,0);
uniform int samples = 20;
uniform float spread = 0.004;
uniform float intensity = 0.1;
uniform int showOnlyGlow = 1;
uniform float alpha = 1.0;
uniform float glowAlpha = 1.0;
uniform vec4 color = vec4(1,1,1,1);
uniform bool enableVertexColor = false;
uniform float time = 1.0;
uniform vec2 resolution = vec2(1280,720)*0.3;

vec4 glow2()
{
    vec4 sum = vec4(0,0,0,0);
    vec2 coord = texCoord;
    //return texture(texture0, coord);

    for (int i = -samples; i <= samples; i++)
    {
        vec4 texel = texture(texture0, coord + i * direction * spread);
        sum += texel * (1-abs(float(i))/float(samples));
    }

    sum *= intensity;
    sum.a = glowAlpha;

    if (showOnlyGlow == 0)
    {
        vec4 originalColor = texture(texture0, coord);
        originalColor.a = alpha;
        sum += originalColor;
    }
    
    return sum * color;
}

void main()
{             
    fragColor = glow2();
}
