#define NOISE_RAYS 60
#define SPHERES 10

uniform vec2 res;
uniform vec3 spheres[SPHERES];
uniform vec4 sphereMaterials[SPHERES];
uniform vec3 noise[NOISE_RAYS];
uniform float time;
uniform float levels[10];
uniform float pulse;
uniform float distorter;
uniform float fader;

float raySphereIntersect(vec3 r0, vec3 rd, vec3 s0, float sr) {
	// - r0: ray origin
	// - rd: normalized ray direction
	// - s0: sphere center
	// - sr: sphere radius
	// - Returns distance from r0 to first intersecion with sphere,
	//   or -1.0 if no intersection.
	float a = dot(rd, rd);
	vec3 s0_r0 = r0 - s0;
	float b = 2.0 * dot(rd, s0_r0);
	float c = dot(s0_r0, s0_r0) - (sr * sr);
	if (b*b - 4.0*a*c < 0.0) {
		return -1.0;
	}
	return (-b - sqrt((b*b) - 4.0*a*c)) / (2.0*a);
}

float planeIntersect(vec3 rayOrigin, vec3 rayDir)
{
	vec3 planeNormal = vec3(0.0,-1.0,0.0);
	vec3 planePoint = vec3(0.0,-30.0,0.0);
	
	if(dot(planeNormal, rayDir ) > 0)
	{
		return -dot(planeNormal, (rayOrigin - planePoint)) / dot(planeNormal,rayDir);
	}
	else
		return -1; //no intersection or intersection behind camera
}

uniform vec3 cam = vec3(100, 100, 100);

	




void main(void)
{
	vec3 target = vec3(0, 0, 0);
	vec3 dir = normalize(target - cam);
	vec3 camup = vec3(0, 1, 0);
	vec3 side = normalize(cross(dir, camup));
	vec3 up = normalize(cross(side, dir));
	float aspect = res.x/res.y;

	vec3 light = vec3(0,0,0);
	for (int n = 0; n < NOISE_RAYS; n++) 
	{
		vec3 rayDir = dir*1.5 + side * (gl_FragCoord.x / res.x * 2.0 - 1.0) * aspect + up * (gl_FragCoord.y / res.y * 2.0 - 1.0);
		rayDir = normalize(rayDir+noise[n]*0.006);
		vec3 origin = cam;
		float dist = 100;

		for (int b = 0; b < 4; b++) {
			float minDist = 1000000000;
			int hitSphere = -1;
	
			for (int i = 0; i < 10; i++) 
			{
				vec3 spherePos = spheres[i];
				float radius = sphereMaterials[i].w;

				float s = raySphereIntersect(origin, rayDir, spherePos, radius);

				if (s > 0 && s < minDist)
				{
					minDist = s;
					hitSphere = i;
				}
			}

			vec3 norm;
			vec3 hitPos;
			vec3 material;
			vec3 distort;

			float ps = planeIntersect(origin, rayDir);
			if (ps > 0 && ps < minDist) {
				minDist = ps;
				hitPos = origin + rayDir * minDist;
				norm = vec3(0,-1,0);
				material = vec3(0);
				distort = vec3(0);
				distort = noise[n]*0.24;
			}
			else if (hitSphere == -1) 
			{
				light += pow(max(0.0, pow(max(0,dot(rayDir, normalize(vec3(1,1,1)))),8) / (dist*0.01)), 2) * 3;
				break;
			}
			else
			{
				hitPos = origin + rayDir * minDist;
				norm = normalize(hitPos-spheres[hitSphere]);
				float t = 0;
				if (sphereMaterials[hitSphere].w > 0.8) t = time;
				float kick = 1;
				if (hitSphere == 1)
				{
					kick = (1+3*abs(levels[0]));
				}
				float swing = sin(time/60*50*3.1415+hitSphere)*0.5+0.5;
				material = sphereMaterials[hitSphere].xyz * ((swing*pulse+(1-pulse))+kick*distorter);
				if (mod(hitSphere,2) == 1) material *= pow(abs(sin(norm.y*20+t)),9);

				float amp = max(0, sin(hitSphere));
				amp = amp*amp+0.1;
				material *= amp;
				distort = noise[n]*0.30;
			}

			dist += minDist;

			light += material * 10 / (dist /100) / (b+1);// * abs(250 / (minDist/90+20) / (b+4.15));
		
			rayDir = normalize(reflect(rayDir, norm) + distort);
			origin = hitPos+rayDir*0.1;
		}
	}
	
	gl_FragColor = vec4(pow(light/NOISE_RAYS*fader,vec3(0.75)),1);
}
