-- cpp-interface.lua - Functions for interfacing with the C++ side

-- Copyright (c) 2017 cxw/Incline.  CC-BY-SA 3.0.  In any derivative work, 
-- mention or link to https://bitbucket.org/inclinescene/public and 
-- http://devwrench.com.

-- Stash a global, since I don't yet know how to access parameters from an
-- unnamed chunk with ... .
function loadGlobal(name, val)
    _G[name] = val
end

--=========================================================================--
-- Per-frame callbacks

-- List of event callbacks.  Each element is a function taking simulation
-- time as the only parameter.  Callbacks are not necessarily called in order.
CBK={}

-- Function called once per frame, in the event traversal.
function perFrameEvent(sim_time)
    for _, callback in pairs(CBK) do
        callback(sim_time)
    end
end

-- vi: set ts=4 sts=4 sw=4 et ai: --
