pico-8 cartridge // http://www.pico-8.com
version 8
__lua__
--import "picologos2.png"
pi=3.14159265
zoomstep=1
local counter=0
local	logoyp=32
local	rotspeed=1.0
local	starsmax=256
local	mx=127
local	my=63
local frame=0
local rotangle=1
local	starsx={}
local	starsy={}
local	starsz={}
local	starss={}
local	coltab={1,3,11,10,7,10,9,8}
	for i=0,starsmax do
		starsx[i]=rnd(127)-63
		starsy[i]=rnd(127)-63
		starsz[i]=rnd(512)
		starss[i]=rnd(7)+1
	end

local xrate=0
local yrate=0
local zrate=0
local	xxtab={}
local	yytab={}
local	zztab={}
local	ledge={}
local	redge={}
local cledge={}
local credge={}
local tledge={}
local tredge={}
  
		for y=1,128 do
		 ledge[y]=0
		 redge[y]=0
		 cledge[y]=0
		 credge[y]=0
		 tledge[y]=0
		 tredge[y]=0
		end

max_vertices2=4 --pyramid
max_faces2=4
pxtab2={2,-2,-2,2,}
pztab2={2,2,-2,-2,}
pytab2={2,-2,2,-2,}
facetab2={1,1,1,4,}
facetab21={2,3,4,3,}
facetab22={3,4,2,2,}
--]]
--[[
max_vertices=8 --cube
max_faces=12
pxtab={-1,1,-1,1,-1,1,-1,1,}
pztab={-1,-1,1,1,-1,-1,1,1,}
pytab={-1,-1,-1,-1,1,1,1,1,}
facetab={3,2,5,3,2,5,7,6,4,7,6,4,}
facetab1={2,3,3,5,5,2,6,7,7,4,4,6,}
facetab2={1,4,1,7,1,6,8,5,8,3,8,2,}

--]]

local max_vertices1=6
local max_faces1=8
local pxtab1={2,0,0,-2,0,0,}
local pztab1={0,2,0,0,-2,0,}
local pytab1={0,0,2,0,0,-2,}
local facetab1={1,1,1,1,4,4,4,4,}
local facetab11={2,3,5,6,2,6,5,3,}
local facetab12={3,5,6,2,6,5,3,2,}
--]]

local max_vertices3=12
local max_faces3=20
local pxtab3={0,0,0,0,3,3,-3,-3,2,-2,2,-2,}
local pztab3={3,3,-3,-3,2,-2,2,-2,0,0,0,0,}
local pytab3={2,-2,2,-2,0,0,0,0,3,3,-3,-3,}
local facetab3={2,1,3,4,5,6,7,8,9,10,11,12,1,1,2,2,3,3,4,4,}
local facetab31={1,2,4,3,6,5,8,7,10,9,12,11,9,7,5,12,6,10,11,8,}
local facetab32={5,7,6,8,11,9,10,12,3,1,2,4,5,10,11,7,9,8,6,12,}

gy={}
gt={}
heights={}
maxheights={}


maxgrid=64

camx=500
camy=0
camz=200
w=128
h=128    

	local angletab={}
	local disttab={}
	local zptab={}

    
function _init()

	cls(0)
	music(0,4000)
 srand(1)
 for x=1,256 do
   gy[x]=-50+rnd(70)
   gt[x]=rnd(255)
 end
	
end

function dostars()
	for i=0,starsmax-1 do
		starsz[i]-=starss[i]
		if starsz[i]<0 then
			starsz[i]=511
		end
	end
	mx=63+sin(frame)*32

 local ssin=sin(rotangle)
 local ccos=cos(rotangle)
 
	for i=0,starsmax-1 do
  local stx=starsx[i]
  local sty=starsy[i]
  local stz=starsz[i]
  -- rotation
  local stxx=ccos*stx-ssin*sty
  local styy=ssin*stx+ccos*sty
		local sx=256*stxx/(stz+20)+mx
		local sy=256*styy/(stz+20)+my
		pset(sx,sy,coltab[5-band(starsz[i]/128,3)])
	end
end

function dologo()
		if frame<0.315 then
			spr(16,128-sin(frame*6)*192,32,32,6)
	 end
	 if frame>0.315 and frame<0.45 then
		 spr(16,0,32,32,6)
		end
	 if frame>0.345 and frame<0.45 then
		 print("at deadline 2017",34,84,7)
		end

		if frame>0.45 then
		 spr(16,0,logoyp,32,6)
		 logoyp=logoyp+2  
		end
end

function dopoly(facecol)
	maxy=0
	miny=128
	
		if tflag==0 then
 -- scanedge
	 xx1=x1
	 yy1=y1
	 xx2=x2
	 yy2=y2
	 doline()
	 
	 xx1=x2
	 yy1=y2
	 xx2=x3
	 yy2=y3
	 doline()
	 
	 xx1=x3
	 yy1=y3
	 xx2=x1
	 yy2=y1
	 doline()

			for y=miny,maxy-1 do
	    line(ledge[y],y,redge[y],y,facecol)
			end
-- gouraud
  elseif tflag==1 then
  xx1=x1
	 yy1=y1
	 xx2=x2
	 yy2=y2
	 doline()
	 
	 xx1=x2
	 yy1=y2
	 xx2=x3
	 yy2=y3
	 doline()
	 
	 xx1=x3
	 yy1=y3
	 xx2=x1
	 yy2=y1
	 doline()

	 xx1=c1
	 yy1=y1
	 xx2=c2
	 yy2=y2
	 dolinecolor()
	 
	 xx1=c2
	 yy1=y2
	 xx2=c3
	 yy2=y3
	 dolinecolor()
	 
	 xx1=c3
	 yy1=y3
	 xx2=c1
	 yy2=y1
	 dolinecolor()

   local dcdx=((y2-y1)*(c3-c1)+(c1-c2)*(y3-y1))/((y2-y1)*(x3-x1)+(x1-x2)*(y3-y1))
   for y=miny,maxy-1 do
				 local c=cledge[y]
	    local x=ledge[y]
	    local e=flr(redge[y]+0x0.ffff)
     local cy=band(y,1)
	    while x<=e do
	    
	    --pset(x,y,coltab[flr(c+yoff+xoff)])
	     local cc=sget(band(flr(c+0x0.ffff)*2+band(x,1),63),cy)
	    -- co=bor(band(x,1),cy)
	    --pset(x,y,coltab[band(c+co,7)+1])
	     pset(x,y,cc)
	     x+=1
	     c=c+dcdx
	    end
   end

  elseif tflag==2 then
  --dcdx=((y2-y1)*(c3-c1)+(c1-c2)*(y3-y1))/((y2-y1)*(x3-x1)+(x1-x2)*(y3-y1))
  u1=0
  v1=0
  u2=31
  v2=31
  u3=0
  v3=31

  xx1=x1
	 yy1=y1
	 xx2=x2
	 yy2=y2
	 doline()
	 
	 xx1=x2
	 yy1=y2
	 xx2=x3
	 yy2=y3
	 doline()
	 
	 xx1=x3
	 yy1=y3
	 xx2=x1
	 yy2=y1
	 doline()

  --u
	 xx1=u1
	 yy1=y1
	 xx2=u2
	 yy2=y2
	 dolinecolor()

	 xx1=u2
	 yy1=y2
	 xx2=u3
	 yy2=y3
	 dolinecolor()
	 
	 xx1=u3
	 yy1=y3
	 xx2=u1
	 yy2=y1
	 dolinecolor()

  --v
	 xx1=v1
	 yy1=y1
	 xx2=v2
	 yy2=y2
	 dolinetexture()

	 xx1=v2
	 yy1=y2
	 xx2=v3
	 yy2=y3
	 dolinetexture()
	 
	 xx1=v3
	 yy1=y3
	 xx2=v1
	 yy2=y1
	 dolinetexture()
   
  local dudx=((y2-y1)*(u3-u1)+(u1-u2)*(y3-y1))/((y2-y1)*(x3-x1)+(x1-x2)*(y3-y1))
  local dvdx=((y2-y1)*(v3-v1)+(v1-v2)*(y3-y1))/((y2-y1)*(x3-x1)+(x1-x2)*(y3-y1))
   
 
  --dcdx=((y2-y1)*(c3-c1)+(c1-c2)*(y3-y1))/((y2-y1)*(x3-x1)+(x1-x2)*(y3-y1))
   
   for y=miny,maxy-1 do
				 local u=flr(cledge[y]+0x0.ffff)
	    local v=flr(tledge[y]+0x0.ffff)
	    local x=ledge[y]
	    local e=redge[y]
     while x<e do
	     local c=sget(flr(u+0x0.ffff+32),flr(v+64+0x0.ffff))
	     pset(x,y,c)	    
	     --pset(x,y,texture2[flr(band(v,31))*32+flr(band(u,31))])
	     x+=1
	     u+=dudx
	     v+=dvdx
	    end
   end
  
  end     
end


function doline()
	local buffid=0 -- right buffer
	if yy2<yy1 then
	  -- swap points
	  temp=xx2
	  xx2=xx1
	  xx1=temp
	  temp=yy2
	  yy2=yy1
	  yy1=temp
	  buffid=1 --left buffer
	end
	
	local deltax=(xx2-xx1)
	local deltay=(yy2-yy1)
	if deltay<=0 then return end
	local prestep=flr(yy1+0x0.ffff)-yy1
	
	local xstep=deltax/deltay
 xx1=xx1+prestep*xstep
 
	local sy1=flr(yy1)
	local sy2=flr(yy2)
	if sy1<miny  then
		miny=sy1
	end
	if sy2>maxy then
	 maxy=sy2
	end
	
	if buffid==0 then
	
		for y=sy1,sy2-1 do
	 	--sx=flr(xx1+0x0.ffff)
	 		local sx=xx1
	 		redge[y]=sx	
	  	xx1=xx1+xstep
	 end
 else
		for y=sy1,sy2-1 do
	 	--sx=flr(xx1+0x0.ffff)
	 		 local sx=xx1
	 			ledge[y]=sx	
	    xx1=xx1+xstep
  end
	end	


end

function dolinecolor()
	local buffid=0 -- right buffer
	if yy2<yy1 then
	  -- swap points
	 local temp=xx2
	  xx2=xx1
	  xx1=temp
	  temp=yy2
	  yy2=yy1
	  yy1=temp
	  buffid=1 --left buffer
	end
	
	local deltax=(xx2-xx1)
	local deltay=(yy2-yy1)
	if deltay<=0 then return end
	local prestep=flr(yy1+0x0.ffff)-yy1
	
	local xstep=deltax/deltay
 xx1=xx1+prestep*xstep
 
	local sy1=flr(yy1)
	local sy2=flr(yy2)
	if sy1<miny  then
		miny=sy1
	end
	if sy2>maxy then
	 maxy=sy2
	end
	
	if buffid==0 then
		for y=sy1,sy2-1 do
	 --sx=flr(xx1+0x0.ffff)
	 		sx=xx1
	 		credge[y]=sx
	  	xx1=xx1+xstep
  end
 else
 	for y=sy1,sy2-1 do
	 --sx=flr(xx1+0x0.ffff)
	 		sx=xx1
	 		cledge[y]=sx
	   xx1=xx1+xstep
	end	
 end
end

function dolinetexture()
	local buffid=0 -- left buffer
	if yy2<yy1 then
	  -- swap points
	  local temp=xx2
	  xx2=xx1
	  xx1=temp
	  temp=yy2
	  yy2=yy1
	  yy1=temp
	  buffid=1 --right buffer
	end
	
	local deltax=(xx2-xx1)
	local deltay=(yy2-yy1)
	if deltay<=0 then return end
	local prestep=flr(yy1+0x0.ffff)-yy1
	
	local xstep=deltax/deltay
 xx1=xx1+prestep*xstep
 
	local sy1=flr(yy1)
	local sy2=flr(yy2)
	if sy1<miny  then
		miny=sy1
	end
	if sy2>maxy then
	 maxy=sy2
	end
	
	if buffid==0 then
		for y=sy1,sy2-1 do
	 --sx=flr(xx1+0x0.ffff)
	 --		sx=xx1
	 		tredge[y]=xx1 --sx
	  	xx1=xx1+xstep
  end
 else
 	for y=sy1,sy2-1 do
	 --sx=flr(xx1+0x0.ffff)
	 		--sx=xx1
	 		tledge[y]=xx1 --sx
	   xx1=xx1+xstep
	end	
 end
end


function doculltest()
			dx21=(x2-x1)
			dx31=(x3-x1)
			dy31=(y3-y1)
			dy21=(y2-y1)
--			cull=bxor(dx21,dx31)
--			cull2=bxor(dy21,dy31)
--			cull=bxor(cull,cull2)
--			if cull>0 then				
				culltest=dx21*dy31-dy21*dx31
--			else
--			 culltest=bxor(dx21,dy31)
--			end
end

function dopyramid()
 
 zoomstep=(zoomstep+1)%180

 if tflag==0 then
    zoom=sin((zoomstep+180)/360)/3.0 --1.7 --1.85
	end
	if tflag==1 then
    zoom=sin((zoomstep+180)/360)/4.0 --1.7 --1.85
 end	   
	
	-- local zoom=0.50
	local ssinx=sin(rotanglex)
 local ccosx=cos(rotanglex)
 local ssiny=sin(rotangley)
 local ccosy=cos(rotangley)
 local ssinz=sin(rotanglez)
 local ccosz=cos(rotanglez)
 
	for v=1,max_vertices3 do

		 local px=pxtab3[v]*zoom
		 local py=pytab3[v]*zoom
		 local pz=pztab3[v]*zoom

  	--z axis
  	local stxx=ccosz*px-ssinz*py
 	 local styy=ssinz*px+ccosz*py
   
   --y axis
   local stxxx=ccosy*stxx+ssiny*pz
   local stzz=-ssiny*stxx+ccosy*pz

   --x axis
   local styyy=ccosx*styy-ssinx*stzz
   local stzzz=ssinx*styy+ccosx*stzz
   		 
		 xxtab[v]=256*stxxx/(stzzz+5)+mx
		 yytab[v]=256*styyy/(stzzz+5)+my
		 zztab[v]=stzzz
	end
	
	for f=1,max_faces3 do
 
  	x1=xxtab[facetab3[f]]
  	y1=yytab[facetab3[f]]
  	x2=xxtab[facetab31[f]]
  	y2=yytab[facetab31[f]]
  	x3=xxtab[facetab32[f]]
  	y3=yytab[facetab32[f]]
-- 2d cull test
	  doculltest()
		
		 if culltest>0 then
		   c1=zztab[facetab3[f]]*15+16
			  c2=zztab[facetab31[f]]*15+16
			  c3=zztab[facetab32[f]]*15+16
			  dopoly(sget(f,7))			
		 end
			--drawline()  	
   --line(x1,y1,x2,y2,7)
   --line(x2,y2,x3,y3,6)
  	--line(x3,y3,x1,y1,5)
 end
  	
end		 

function dogouraud()
 
 zoomstep=(zoomstep+1)%180
 local zoom=sin((zoomstep+180)/360)/3.6 --1.7 --1.85
	
	-- local zoom=0.50
	local ssinx=sin(rotanglex)
 local ccosx=cos(rotanglex)
 local ssiny=sin(rotangley)
 local ccosy=cos(rotangley)
 local ssinz=sin(rotanglez)
 local ccosz=cos(rotanglez)
 
	for v=1,max_vertices2 do

		 local px=pxtab2[v]*zoom
		 local py=pytab2[v]*zoom
		 local pz=pztab2[v]*zoom

  	--z axis
  	local stxx=ccosz*px-ssinz*py
 	 local styy=ssinz*px+ccosz*py
   
   --y axis
   local stxxx=ccosy*stxx+ssiny*pz
   local stzz=-ssiny*stxx+ccosy*pz

   --x axis
   local styyy=ccosx*styy-ssinx*stzz
   local stzzz=ssinx*styy+ccosx*stzz
   		 
		 xxtab[v]=256*stxxx/(stzzz+5)+mx
		 yytab[v]=256*styyy/(stzzz+5)+my
		 zztab[v]=stzzz
	end
	
	for f=1,max_faces2 do
 
  	x1=xxtab[facetab2[f]]
  	y1=yytab[facetab2[f]]
  	x2=xxtab[facetab21[f]]
  	y2=yytab[facetab21[f]]
  	x3=xxtab[facetab22[f]]
  	y3=yytab[facetab22[f]]
-- 2d cull test
	  doculltest()
		
		 if culltest>0 then
			  c1=zztab[facetab2[f]]*15+16
			  c2=zztab[facetab21[f]]*15+16
			  c3=zztab[facetab22[f]]*15+16
			  dopoly(sget(64+f%2,6))			
		 end
			--drawline()  	
   --line(x1,y1,x2,y2,7)
   --line(x2,y2,x3,y3,6)
  	--line(x3,y3,x1,y1,5)
 end
  	
end		 

function dobackground()
  for y=0,127 do
    c=sget(y/8+24,1)
    line(1,y,127,y,c)
  end
end   

function dofractline(x1,y1,x2,y2,t1,t2,col)

local sx1={}
local sx2={}
local sy1={}
local sy2={}
local st1={}
local st2={}

local x1=flr(x1)
local x2=flr(x2)
local y1=flr(y1)
local y2=flr(y2)
local temp=0
local top=1

if x1<=x2 then
  sx1[top]=x1
  sx2[top]=x2
  sy1[top]=y1
  sy2[top]=y2
  st1[top]=t1
  st2[top]=t2
else
  sx2[top]=x1
  sx1[top]=x2
  sy2[top]=y1
  sy1[top]=y2
  st2[top]=t1
  st1[top]=t2
  temp=x1
  x1=x2
  x2=temp
end
--printh(x1.." "..x2)

while top>=1 do
local	dx=flr(abs(sx2[top]-sx1[top]))
 if dx>1 then
local edge_dis=shr(dx,2)
   sx2[top+1]=sx2[top]
   sy2[top+1]=sy2[top]
   st2[top+1]=st2[top]
   local newx=flr((sx1[top]+sx2[top])/2)
   local newy=flr((sy1[top]+sy2[top])/2)
   local newt=band(st1[top]+st2[top],255)
   local v=band(bxor(st1[top],newt),bxor(st2[top],newt))
   local v=shr(band(v,128),7)
   local n=shr(band(v,128),7)
   
   if v==0 then
     if n==1 then
       newy=newy-edge_dis
     else
       newy=newy+edge_dis
     end
   end
   
   if newx>=w then
     sx2[top]=newx
     sy2[top]=newy
     st2[top]=newt
   else
     if newx<0 then
     	sx1[top]=newx
     	sy1[top]=newy
     	st1[top]=newt
     else
      sx2[top+1]=sx2[top]
      sy2[top+1]=sy2[top]
      st2[top+1]=st2[top]
      sx2[top]=newx
      sy2[top]=newy
      st2[top]=newt
      sx1[top+1]=newx
      sy1[top+1]=newy
      st1[top+1]=newt
      top+=1
     end
   end
 else
  if sx1[top]>=0 and sx1[top]<w then
    heights[sx1[top]]=sy1[top]
    if heights[sx1[top]]<0 then
      heights[sx1[top]]=0
    end
  end
  top-=1
 end

end

x1=flr(x1)
x2=flr(x2)
for x=x1,x2-1 do
   if (x>0) and (x<128) then
     y=heights[x]
		   if maxheights[x]>y then
  		    local dy=maxheights[x]-y
  		    maxheights[x]=y-1
    		  pset(x,y,0)
  					 line(x,y+1,x,y+dy,4)
 		  end
 		end
end

--line(63,0,63,127,8)

end      

function dogrid()
 
 for x=1,255 do
   maxheights[x]=127
   heights[x]=0
 end

 zz=2
 for z=-32,-512,-64 do
   xx=1
   for x=-127,127,32 do
     off=xx+zz*16
     off2=off+16
     xx+=1
     
     px1=x-camx
     py1=gy[off]-camy
     pz1=z-camz
    
     px2=x-camx
     py2=gy[off2]-camy
     pz2=z-64-camz
 
     px3=x+32-camx
     py3=gy[off+1]-camy
     pz3=z-camz

     xx1=128*px1/(pz1)+63
     yy1=128*py1/(pz1)+63
     xx2=128*px2/(pz2)+63
     yy2=128*py2/(pz2)+63
     xx3=128*px3/(pz3)+63
     yy3=128*py3/(pz3)+63
--     xx4=10*px4/pz4+64
--     yy4=10*py4/pz4+64
     
   -- clipping

    --if ((pz1<=0) or (pz2<=0)) and ((pz1>-480) or (pz2>-480)) then
      
     --  clip1=128*pz1/2*500
     --  clip2=128*pz2/2*500
 
     --if ((px1>=clip1)) or ((px1<=-clip1) or (px2<=-clip2)) then
     
    --line(xx1,yy1,xx2,yy2,xx)
    --line(xx1,yy1,xx3,yy3,xx)
    -- line(xx3,yy3,xx4,yy4,x)
       
       -- horizontal
       dofractline(xx1,yy1,xx3,yy3,gt[off],gt[off],x)
    	  -- verticals
    	  dofractline(xx1,yy1,xx2,yy2,gt[off2],gt[off2],z)
    --end   
   -- end
   end
 
     x=127
     off=xx+zz*16
     off2=off+16
     xx+=1
     
     px1=x-camx
     py1=gy[off]-camy
     pz1=z-camz
     
     px2=x-camx
     py2=gy[off2]-camy
     pz2=z-64-camz
 
     px3=x+32-camx
     py3=gy[off+1]-camy
     pz3=z-camz

     xx1=128*px1/(pz1)+63
     yy1=128*py1/(pz1)+63
     xx2=128*px2/(pz2)+63
     yy2=128*py2/(pz2)+63
     xx3=128*px3/(pz3)+63
     yy3=128*py3/(pz3)+63
				
				 --line(xx1,yy1,xx2,yy2,7)
    	dofractline(xx1,yy1,xx2,yy2,128,128,z)
     --printh(xx)
  zz+=1

 end
 --printh(off)
  z=-512
  zz=11
  xx=8
   for x=95,-192,-32 do
    off=xx+zz*16 		 
    off2=off+16
     xx-=1
     
     px1=x-camx
     py1=gy[off]-camy
     pz1=z-camz
    
     px2=x-camx
     py2=gy[off2]-camy
     pz2=z-64-camz
 
     px3=x+32-camx
     py3=gy[off+1]-camy
     pz3=z-camz

     xx1=128*px1/(pz1)+63
     yy1=128*py1/(pz1)+63
     xx2=128*px2/(pz2)+63
     yy2=128*py2/(pz2)+63
     xx3=128*px3/(pz3)+63
     yy3=128*py3/(pz3)+63
			  --line(xx1,yy1,xx3,yy3,9)
  			dofractline(xx1,yy1,xx3,yy3,gt[off],gt[off],x)
   end
		
end

function dogfx()
	spr(112,16,32,32,32)
end

function dotwirl()
  
  start1+=add1
  start2+=add2
  local co1=start1
  local co2=0 --start2
	 for x=1,128 do
			local ssin1=sin(co1/250)*64
			local ssin2=cos(co2/400)*64
			zptab[x]=ssin1+ssin2 --(ssin1+ssin2)%32
	
			co1+=off1
			co2+=off2
  end 
 
  for y=1,64 do
  local yy=(y-1)*2
    for x=1,64 do
      local xx=(x-1)*2
					 local ut=angletab[x+y*64]
					 --printh(i)
		    local vt=disttab[x+y*64]
					 local vv=zptab[flr(vt+1)%64] --+start1)%64
		    local c=sget((ut+vv)%64,7)
		    
		    rect(xx,yy,xx+1,yy+1,c)
  		end
		end

local tt=flr(frame*400)
local tc=coltab[(tt%16)]
local tx=sin((frame)*20+0)*6
print("deadline 2017",40+tx,16,tc)
tt+=1
tc=coltab[(tt%16)]
tx=sin((frame)*22+4)*6
print("-------------",40+tx,22,tc)
tt+=1
tc=coltab[(tt%16)]
tx=sin((frame)*23+6)*6
print("thank you for watching",24+tx,28,tc)
tt+=1
tc=coltab[(tt%16)]
tx=sin((frame)*24+8)*6
print("credits for our first pico-8",8+tx,40,tc)
tt+=1
tc=coltab[(tt%16)]
tx=sin((frame)*25+8)*6
print("code by heaven",40+tx,52,tc)
tt+=1
tc=coltab[(tt%16)]
tx=sin((frame)*26+8)*6
print("music by slimey",40+tx,64,tc)
tt+=1
tc=coltab[(tt%16)]
tx=sin((frame)*27+8)*6
print("pixels by alien",40+tx,72,tc)
tt+=1
tc=coltab[(tt%16)]
tx=sin((frame)*28+8)*6
print("(c) 2017 desire",40+tx,96,tc)

	
end

function _update()
	frame=frame+0.001
	
 
 camz=sin(frame*6)*60+60
 camx=cos(frame*6/2)*60+520
 camy=sin(frame*6/2)*30

end	

function _draw()
	cls()
	if frame>0 and frame<0.5 then
		dostars()
		rotangle=frame
	end
		
	if frame>0.25 and frame<0.5 then 
	 	dologo()
	 	--dotwirl()
	 	rotangle=frame
	end
 
 if frame>0.5 and frame<=0.7 then
 	 dostars()
 	 rotangle=frame*rotspeed
	 	rotspeed=rotspeed+0.02
	end
		
 		
	if frame>0.7 and frame<=1.348 then
  dostars()
		xrate=1.2
		yrate=2.8
		zrate=3.1
	 rotanglex=frame*xrate
	 rotangley=frame*yrate
 	rotanglez=frame*zrate
  if frame>0.70 and frame<=1.056 then 
    tflag=0
    dopyramid() 
  end
  if frame>1.056 and frame<=1.23 then 
    tflag=1 
    dopyramid()
  end
  if frame>1.23 and frame<=1.348 then 
    tflag=2 
    dogouraud()
  end
  --tflag=flr(frame*2-1)
	end

 if frame>1.348 and frame<=1.98 then
   dobackground()
   dogrid()
		 tflag=0
 end

 if frame>=1.98 and frame<2.17 then
   dogfx()
		 -- twirl
			add1=0.8
			add2=1.25
			start1=0
			start2=1
			off1=-0.5
			off2=2
		
		for y=1,64 do
		  yy=y-32
		  for x=1,64 do
		    xx=x-32
		    angle=-atan2(xx,yy)*64
		    if angle<0 then angle+=64 end
		    if angle>64 then angle-=64 end
		    angletab[x+y*64]=angle
		    dist=(sqrt(xx*xx+yy*yy)/(sqrt(64*64+64*64)))
		    dist=dist*64
		    if dist<0 then dist+=64 end
		    if dist>64 then dist-=64 end
		    disttab[x+y*64]=dist
		    --pset(x-1,y-1,angle)
		  
		  end

end

 end
 if frame>2.17 then
 	dotwirl()
 end	
 	
 
--status
--print("c "..stat(1)*100.0, 0, 0,7)
--print("m "..stat(0),40,0,7)
--print("t "..frame, 90, 0,7)
end

__gfx__
22288898999aaaabbb3b33311151555dddcdccc66676777fffefeee222777777b977777777777777777777777777777777777777777777777777777777777777
2282888999a9aababbb33313111555d5dddccc6c666777f7fffeee2e227777777777777777777777777777777777777777777777777777777777777777777777
efff6f666cccbcbbbaaa9a999888e8ee5555535333333444d4d4ddddbdbdbbbbbcbcbccccececeeee9e9e999969696666f6f6ffffafafaaaa7a7a77770707000
fefff666c6cccbbbabaaa99989888eee5535353333434344444dd4dddddbbdbbbbbbccbccccceeceeeee99e9999966966666ff6fffffaafaaaaa77a777777700
22288898999aaa7a777bbb3b333111215555535333333444d4d4ddddbdbdbbbbbcbcbccccececeeee9e9e999969696666f6f6ffffafafaaaa7a7a77770707000
2282888999a9aaa777b7bbb3331311125535353333434344444dd4dddddbbdbbbbbbccbccccceeceeeee99e9999966966666ff6fffffaafaaaaa77a777770700
000001011111121222222828888885855555535333333444d4d4ddddbdbdbbbbbcbcbccccececeeee9e9e999969696666f6f6ffffafafaaaa7a7a77770707000
425d6f77f6d524ee425d6f77f6d524ee425d6f77f6d5244e425d6f77f6d5244e0bbbccbccccceeceeeee99e9999966966666ff6fffffaafaaaaa77a777770700
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000d0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000060000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000766000000000000000700000000000000070000000000000000000000000000070000000000000700000000000000000000
00000000000000000000000000006665d000000d00000077600000000000007770000000000000000000000000007760000d0000007760000000000000000000
0000000000000000000000000007667556000000000006675d000000000006676700000000d00000000000000006675d0000000006675d000000000000000000
000000000000000000000000006667565500000d0000766755d0000d00007667567000000000000000000d0000766755d00d0000766755d00000000000000000
00000000000000000000000006067555d50000065007666755500007500666676560000000d00000000006500766675550065007666755500000000000000000
00000000000000000000000000066675550000675576666755500067557666675650000000600000000067557666675550675576666755500000000000000000
00000000000000000000000500066665550006775760666655500677576566675560000006760000000677576066665506775760666655500000000000000000
00000000000000000000000000066665550067677650666755506767765066675550000067756000006767765066675067677650666755500000000000000000
00000000000000000000000000066665550066676500666655566667650066756550000676755d00066667650066665066676500666655500000000000000000
00000000000000000000000000066665550066675550666755606667555067555d50006666755500606667555066670066675550666755500000000000000000
000000000000000000000000006666655500666755006665655066675500755555d0060666755506006667550066656066675500666565500000000000000000
0000000000000000000000000666666555006667555066555d50666755500655550050066675556000666755506655006667555066555d500000000000000000
00000000000000000000000066066665550066675506655555d06667555000d55005000666755600006667550065555066675506655555d00000000000000000
000000000000000000000006650666655500666755665555550066670500000d0000000666756000006667555005550066675566555555000000000000000000
00000000000000000000007650066665550066665665555550006666505000000000000666755000006666550000555066665665555550000000000000000000
00000000000000000000077505066665550066675755555700001666767677770000000667565500006667555000050066675755555700000000000000000000
0000000000000000000076755006666555006667506555776000016666666667600000067555d500006667555000000066675065557760000000000000000000
0000000000000000000666755506667555006667550d57675d000005555076675d0000066675550000666755500000006667550d57675d000000000000000000
00000000000000000006667555066756550066665050766755d000005500766755d0000667065500006666555000000066665050766755d00000000000000000
00000000000000000006667555067505d50066675506666755500000055076706550000666655500006667555000000066675506667065500000000000000000
00000000000000000006667555066675550066665566666755500000000077055d5000066675550000666655500000006666556667005d500000000000000000
00000000000000000006667555066665550066665660666755500007000076675550000666655500006666555000000066665660666755500000000000000000
00000000000000000006667555066655550066666650666755500076500076756550000666655500006667555000000066666650667065500000000000000000
00000000000000000006660555066500550066666500666755500766550676666550000666655500006670655000000066666500666755500000000000000000
000000000000000000066070550650750500666655506667555076665567767655500006666555000067055d5000000066665550666755500000000000000000
00000000000000000006077d05000765500066655500666755507666567577656550000666655500006667555000000066655500066755000000000000000000
000000000000000000007675d0006665500066555550666755507666675576555d50000666565500006675655000000066555550706750d00000000000000000
0000000000000000000766605d0766655500655555506667555076666555765555d000066675550000666755500000006555555067070d500000000000000000
000000000000000000066675056666655500065555006675655076675555d0d555000006675655000666756550000006065555006670d5500000000000000000
00000000000000000006666056666656550000d5500067555d5076755655000d500000667555d5005067555d5000005000d55000666755500000000000000000
00000000000000000006666566066555d500000d00006667555077565555d0000000050755555d0500755555d0000500000d0000666755500000000000000000
00000000000000000006666660565555560000000000667565507665655000000000500065555000000655550000000000000000667565500000000000000000
0000000000000000000666665505655550000000000067555d56076656000000000000000d5500000000d550000000000000000067555d500000000000000000
00000000000000000006666555505655000000000000755555d00076600000000000000000d0000000000d000000000000000000755555d00000000000000000
00000000000000000006665555550050000000000000065555000007000000000000000000000000000000000000000000000000065555000000000000000000
0000000000000000000665555550000000000000000000d55000000000000000000000000000000000000000000000000000000000d550000000000000000000
00000000000000000006555555000000000000000000000d00000000000000000000000000000000000000000000000000000000000d00000000000000000000
00000000000000000060655550000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000006000d5500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000d000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000100101011011111111111d1dd1ddddddddedee0000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000001000101011111000011101111111111111111111e001111d1dde0000000000000000000000000000000000000000000000
00000000000000000000000000000000000001100000000000101111111111111111111d001111111d0000000000000000000000000000000000000000000000
000000000000000000000000000000000001100000000000000101010111111111111111e00111111d0000000000000000000000000000000000000000000000
0000000000000000000000000000000000100000000000000000000011011111111111111d001111110000000000000000000000000000000000000000000000
000000000000000000000000000000001000dd6dddddddd200000001001111111111111111d001111d0000000000000000000000000000000000000000000000
0000000000000000000000000000000000d6666666ddd6dd000000000011111111111111111d0011110000000000000000000000000000000000000000000000
00000000000000000000000000000000d6666666d666ddddddd0000000011111111111111111d001110000000000000000000000000000000000000000000000
0000000000000000000000000000000d6676666666dd6dd66d000000001011111111111111111d00110000000000000000000000000000000000000000000000
000000000000000000000000000000d66666666666dd66d66dddd0000001011111111111111111d0010000000000000000000000000000000000000000000000
0000000000000000000000000000006676666666666666dddddddd2000001111111111111111111d000000000000000000000000000000000000000000000000
00000000000000000000000000000d66666666666666d66ddd6dd0d0000001111111111111111111d00000000000000000000000000000000000000000000000
0000000000000000000000000000d667766666666666666dddddd0020001111111111111111111111d0000000000000000000000000000000000000000000000
00000000000000000000000000006667766666666666666ddddddd0000001111111111111111111111d000000000000000000000000000000000000000000000
00000000000000000000000000006600060006666666666dddddddd6000010111111111111111111111000000000000000000000000000000000000000000000
0000000000000000000000000007d60e060e0666666666dddddddddd200001111111111111111111111010000000000000000000000000000000000000000000
00000000000000000000000000dd660e000e0d6666666dddddd00dddd00001111111111111111111111000000000000000000000000000000000000000000000
0000000000000000000000000dd666000600066666ddddddddd000ddd00000111111111111111111111010000000000000000000000000000000000000000000
000000000000000000000000767766666666666d6ddddddddddd00ddd00000011111111111111111111010000000000000000000000000000000000000000000
000000000000000000000000667760770776767666666d6ddddd00dd000000011111100011111111111000000000000000000000000000000000000000000000
0000000000000000000000006666607707666666777766d6dddd06ddd00000001111011001111111111010000000000000000000000000000000000000000000
000000000000000000000000d6667077076666666666666ddddd6dd0000001000111011101111111111010000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000d766ddddddd0000000100111100101111111111010000000000000000000000000000000000000000000
000000000000000000000000077770077007700770000d66dd6ddddd000000010011111101111111111010000000000000000000000000000000000000000000
000000000000000000000000087770077007700770700066dddddd6dd00000011001111101111111111010000000000000000000000000000000000000000000
000000000000000000000000008700070008800770800076ddd66dddd00000001100111011111111111010000000000000000000000000000000000000000000
000000000000000000000000000700080000000780000066d6d66d00d00001111111000111111111111010000000000000000000000000000000000000000000
0000000000000000000000000000000000000008000000766dddddd0000000110111111111111111111010000000000000000000000000000000000000000000
0002eeeeeeee220000000000000000000000700000000000666ddddd000000011011111111111111111010000000000000000000000000000000000000000000
02eee7eeeeeeeee20000000000000000000000000500006006dddddd000000001101111111111111111010000000000000000000000000000000000000000000
0e77eeee7eeeeeeee2000000020222222222000000000676066ddd00000000000110111111111111111010000000000000000000000000000000000000000000
2e77eeeeeeeeeee77e2000022e222222222222020000067606dddd00000001110011111111111111111010000000000000000000000000000000000000000000
eeeeeeeeeeeeeeeeeee002ee22222000000000000050066606ddddd0000000011101111111111111111010000000000000000000000000000000000000000000
eeeeee7eeeeeeeeee2e2ee2222200000000000500000067606ddddd0000000111111111111111111111010000000000000000000000000000000000000000000
eeeeeeeeeeee2e2e2e2e222220000000075000000000066606ddd000000111110011111111111111111010000000000000000000000000000000000000000000
2e22eee222e2e2e2e222222000000000000000000000006006dd0d60000110000000011111111111111010000000000000000000000000000000000000000000
0ee2222222222e22222220000000000000000000000000006d6d0dd0000010000000001111111111111010000000000000000000000000000000000000000000
027eeee00222222222200000008700070000800780780066d6dddd20000010000011101111111111111010000000000000000000000000000000000000000000
002772000002222200000000007700078008700770770076dd6d0d20000010000011001111111111111010000000000000000000000000000000000000000000
000270000000200000000000087780077007700770770066dddddd00000011000001001111111111111010000000000000000000000000000000000000000000
000070000000700000000000077770077007700770000d66dddddd00000001111111011111111111111010000000000000000000000000000000000000000000
00007000000000000000000000000000000000000000d766dd6ddd00000000000000111111111111111010000000000000000000000000000000000000000000
000070000000000000000000d6d0000000000d666666666ddddddd00000000000011111111111111111010000000000000000000000000000000000000000000
0000000000000000000000006666666666666666777766d6dd6ddd00000001111011111111111111111010000000000000000000000000000000000000000000
000070000000000000000000667767777776767666666d6ddd6ddd00000111111111111111111111111010000000000000000000000000000000000000000000
000000000000000000000000767766666666666d6ddddddddd6dddd0000101001111111111111111111010000000000000000000000000000000000000000000
0000b000000000000000000000766666dddddd00000000006d66ddd6011111001111111111111111111010000000000000000000000000000000000000000000
0000b00000000000000000000666666dddddddd060dddd0006666ddd001111111011111111111111111010000000000000000000000000000000000000000000
00000000000000000000000000766676dddddd00000d666d00666dddd01111011111111111111111111010000000000000000000000000000000000000000000
00000000000000000000000000000676ddd000000000d666d0d6d6dddd0111110111111111111111111010000000000000000000000000000000000000000000
00003000000000000000000000b000666d00000000000d666d066d6dddd001111111111111111111111010000000000000000000000000000000000000000000
00000000000000000000000000b0007000000000000000d6660d66d6ddddd0011111111111111111111010000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000d6660d66d6dddddd00000011111111111111010000000000000000000000000000000000000000000
000000000000000000000000000000b0000000000000000066660d66d666d6ddddd0d00001111111111010000000000000000000000000000000000000000000
000000000000000000000000003000b00000000000000006d666606666d66dd6dddddbb360011111111010000000000000000000000000000000000000000000
000050000000000000000000000000000000000036666dddddd666666666666dd6dddb33dd601111111010000000000000000000000000000000000000000000
00000000000000000000000000000000000000366d6dd6d6d6ddd666666666666dd6bb3dddd01111111010000000000000000000000000000000000000000000
0000000000000000000000000000003000000366666666666d6dd66666666666666bbb3d6dd60111111010000000000000000000000000000000000000000000
00000000000000000000000000000000000036676666666666ddd66666666666666b3b66d6dd6011111010000000000000000000000000000000000000000000
0000000000000000000000000050000000006666666d666666666666b66666d666b36b666d6d6011111010000000000000000000000000000000000000000000
00000000000000000000000000000000000067666667666666666666b666667666b66b6666d6d300000010000000000000000000000000000000000000000000
00000000000000000000000000000000000366666dd6663666666666b66dd66666b66b66666dd300111100000000000000000000000000000000000000000000
00000000000000000000000000000050003366666dd6db3666666666b36dd66666b663b66666b330000000000000000000000000000000000000000000000000
0000000000000000000000000033333b333b666666666b3666666666b36666d666b666b6d6d6bb33333333355555555555050000000000000000000000000000
0000000000000303333333333333bbbbbbbbd6d6d6d6db36d6d66d6bb36666766bbd66bb6d6dbbbbbb3b33333333300000000000000000000000000000000000
000000000000000000000333bbbaaabaabbbdd6d6d6db33d6d6dd6dbbb3d6d6ddbbbdddbdddbbbbb333333333555550300000000000000000000000000000000
00000000000000000000000003bbbbbbbbbbbddddddbbb3bbbbbbbbbbbbdddddbbbbbbbbbbbbb333333333555550000000000000000000000000000000000000
000000000000000000000000000bb33bb33bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbb355555555555555500000000000000000000000000000000
00000000000000000000003bbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbabbbbbaaabbbbbbbbbb3333333333333355555555555050000000000000000000000000
000000000000000000000000000333bb33bbbbbbbbbbaaaabbbbbbbbbbbb333bbbbbbbbbbbbbb3bbb33333355550000000000000000000000000000000000000
000000000000000000000000000000000000bbbbbbbbbbbbbbbbbbbbbb3bbb333333333333333333333555500000000000000000000000000000000000000000
00000000000000000000000000000a00000000000333bbbbbbbbb33bb33333333333333333355555555000000000000000000000000000000000000000000000
__label__
88888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888
88888888888888888888888888888888888888888888888888888888888888888888888888888888888ff8ff8888228822888222822888888822888888228888
8888888888888888888888888888888888888888888888888888888888888888888888888888888888ff888ff888222222888222822888882282888888222888
8888888888888888888888888888888888888888888888888888888888888888888888888888888888ff888ff888282282888222888888228882888888288888
8888888888888888888888888888888888888888888888888888888888888888888888888888888888ff888ff888222222888888222888228882888822288888
8888888888888888888888888888888888888888888888888888888888888888888888888888888888ff888ff888822228888228222888882282888222288888
88888888888888888888888888888888888888888888888888888888888888888888888888888888888ff8ff8888828828888228222888888822888222888888
88888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888
1161117116111611116116161116111711171c111c1c111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1161177716661666116116161666111711711ccc1ccc111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1161117111161116116116161611111717111c1c111c111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1666111116611661166616161666117117171ccc111c111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1ccc1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
111c1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1ccc1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1c111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1ccc1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111cc1117117171ccc111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
111111c111171171111c111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
177711c1111717771ccc111111111111111111111111111111111111111711111111111111111111111111111111111111111111111111111111111111111111
111111c1111711711c11111111111111111111111111111111111111111771111111111111111111111111111111111111111111111111111111111111111111
11111ccc117117171ccc111111111111111111111111111111111111111777111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111777711111111111111111111111111111111111111111111111111111111111118888
1bbb1171166616611166161116661666166616661771161611111616171771111c1c117711111ccc1c1c1ccc11111ccc1ccc1ccc1ccc11111166166616668878
1b1b1711161616161611161116111161161616161711161611711616117117111c1c111711711c1c1c1c1c1c11111c111c111c111c1111711616161616168887
1bb1171116661616161116111661116116661661171111611777166617771ccc1ccc111717771c1c11c11c1c11111cc11cc11cc11cc117771616166116618887
1b1b171116161616161616111611116116161616171116161171111611711c1c111c111711711c1c1c1c1c1c11111c111c111c111c1111711616161616168887
1b1b117116161616166616661666116116161666177116161111166617171ccc111c117711111ccc1c1c1ccc11c11c111c111c111c1111111661161616168878
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1666166617711616161611111cc11177111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
16161616171116161616117111c11117111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
16661661171116161616177711c11117111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
16161616171116161616117111c11117111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1616166617711166116611111ccc1177111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1666166616661666177116161111161617171c111c1c117711111166166616661666166616611111111111111111111111111111111111111111111111111111
1161116116161616171116161171161611711c111c1c111711711611116116161616116111611111111111111111111111111111111111111111111111111111
1161116116661661171111611777166617771ccc1ccc111717771666116116661661116111611111111111111111111111111111111111111111111111111111
1161116116161616171116161171111611711c1c111c111711711116116116161616116111611111111111111111111111111111111111111111111111111111
1161116116161666177116161111166617171ccc111c117711111661116116161616116116661111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1bbb1171161617171cc111111616161617171cc11c1111111ccc1171111111111111111111111111111111111111111111111111111111111111111111111111
11b117111616111711c1117116161616111711c11c111111111c1117111111111111111111111111111111111111111111111111111111111111111111111111
11b117111616117111c1177716161616117111c11ccc1111111c1117111111111111111111111111111111111111111111111111111111111111111111111111
11b117111666171111c1117116161616171111c11c1c1171111c1117111111111111111111111111111111111111111111111111111111111111111111111111
11b11171116117171ccc11111166116617171ccc1ccc1711111c1171111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
1616161611111cc111111616161611111cc111111166117111111111111111111111111111111111111111111111111111111111111111111111111111111111
16161616117111c1111116161616117111c111111611111711111111111111111111111111111111111111111111111111111111111111111111111111111111
11611161177711c1111116661666177711c111111611111711111111111111111111111111111111111111111111111111111111111111111111111111111111
16161616117111c1117111161116117111c111711611111711111111111111111111111111111111111111111111111111111111111111111111111111111111
1616161611111ccc17111666166611111ccc17111166117111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
166617171c1c1ccc1ccc117111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
161111711c1c1c1c1c1c111711111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
166117771ccc1c1c1c1c111711111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
16111171111c1c1c1c1c111711111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
16661717111c1ccc1ccc117111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
88888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888
82888222822882228888822282228222888282228222822888888888888888888888888888888888888888888882228288828282888882822282288222822288
82888828828282888888828288828882882882828882882888888888888888888888888888888888888888888888828288828282888828828288288282888288
82888828828282288888822282228822882882228822882888888888888888888888888888888888888888888888228222822282228828822288288222822288
82888828828282888888828282888882882888828882882888888888888888888888888888888888888888888888828282888282828828828288288882828888
82228222828282228888822282228222828888828222822288888888888888888888888888888888888888888882228222888282228288822282228882822288
88888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888

__gff__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
010a00001602018030190401d050220502405025050290501605018050190501d050220502405025050290501605018050190501d050220502405025050290501605018050190501d05022050240502505029050
010a00001502017030180401c050210502305024050280501505017050180501c050210502305024050280501505017050180501c050210502305024050280501505017050180501c05021050230502405028050
010a00001935019350163001d30019310193101630000000163501635000000000001631016310000000000011350113500000000000113101131000000000001935019350000000000019310193100000000000
010a00001837018370000000000018330183300000000000183101831000000000003977025700347700000026701327713377134771347713477000000000000000000000000000000000000000000000000000
010a00000c0500105004000010000f0000d0000c0000b000066501a65009000066001a600116000500003000026000d60011600166000c050010501660000000066501a650000000000000000000000000000000
010a00001c3701c37016600176001c3301c33015600156001c3101c31014600156003c77039700397700000000000347713377132771327713277100000000000000000000000000000000000000000000000000
010a000018350183501700000000183101831000000000001535015350020000100015310153101d000220001c3501c35001000000001c3101c3101d000220001835018350010000100018310183100100022000
010a00001937019370000000000019330193300000000000193101931000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00001604018040190401d040220402404025040290401603018030190301d030220302403025030290301602018020190201d020220202402025020290201601018010190101d01022010240102501029010
010a00000405001050126001260012650126500400001000126101261004050010501265012650000000000004050010501261012610126501265000000000001261012610040500105012650126500000000000
010a00000405001050126101261012650126500000000000126101261004050010501265012650000000000004050010501261012610126501265000000000001261012610040500105012650126500000000000
010a0000214501c4001c4501a400154501a000214501a2001c4501a200154501a400214501a2001c4501a200224501a2001d4501b400164501a200224501d4001d4501a200164501b400224501a200244501a200
010a00002143021430214302140021430214302140021430214302143021430214302143021430000002143022430224300000022430224302243022430000002243022430224302243000000224302243022430
010a00002543025430254302543025430254300000025430254302543000000254300000025430254302543026430264302643026430000002643026430264300000026430264302643028400284302843028430
010a0000182701120015270000000000000000102701027010270102001527015200182701820018200000001927000000162701620016200000001927019270192701a2001b2701920019270000001827000000
010a00001c270000001a2700000000000000001927019270192700000016270000001527000000000000000013270132700000013270132700000013270132001627000000132700000015270000000000000000
010a0000254302543025430254302543025430000002543025430254300000025430000002543025430254302643026430264302643000000264302643026430000002643026430264301c003284302843028470
010a00001545001000154501260015450126001545000000154501260015450010001545012600164521645216452010001645016400164501260016450000001645012600164500100016450126031845000000
010a0000213521c302213121c3021c352153121531200000213520000021312000001c352000001c31200000223520000022312000001d352000001d312000002235200000223120000024352000002431200000
010a00002155221552215522155221552215522155221552215522150221552000002155220300215520000022552000002155200000215520000024552000002155200000215520000024552000002155200000
010a000021552215522155221552215522155221552215522155200000215520000024552000002155200000285520000024552000002d55200000285520000030552000002d5522950228552285022455200000
010a0000394501d000374501d000344501d0002d4502d4502d4502d4502d4502d4502d4502d4502d4502d4002d4502e400304002100030450210003440021000324501f0002d4001f000344501f0002d4001f000
010a0000394503b40037450210003440021000344503445034450344503445034450344503445034450230003245024000344502400030450240002d450240002b450000002b450000002c450000002d4502d450
010a0000154501540015450240001545024000154502400015450260001545026000154502600015450260001a450280001a450280001a450280001a450280001c4501d4001c450000001c450000001c45000000
010a00002d4502d4502d4500000003000000000100001000316003160036600000000300000000010000100031600316003660000000030000000001000000000000000000000000000000000000000000000000
01640000374503845039073000000f0040000000000000001f2002020021200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
016400001f25020250210730000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
016400002b7502c7502d0732d00300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
016400001305014050150730000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010a00000906009050090400903009020090100906009050090400903009020090100a0600a0500a0400a0300a0200a0100a0600a0500a0400a0300a0200a0100a0600a0500a0400a0100a0600a0500a0400a010
010a00000905009010090500901009050090100905009010090500901009050090100905009010090500901002050020100205002010020500201002050020100405004010040500401004050040100405004010
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 00464344
00 01434344
00 00024344
00 01034344
00 00020444
00 01050444
00 01060444
00 00074344
00 08434344
00 090b4344
00 0a0b4344
00 0a0b0c45
00 0a0b0d44
00 0a0b0c0e
00 0a0b100f
00 0a0b4344
00 06424344
00 1109125d
00 0a11031d
00 1109125d
00 0a11051d
00 11091213
00 0a11031d
00 11091214
00 0a11051d
00 150a171e
00 160a171e
00 1809171e
00 191a1b1c
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344

