#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;

//////////////////////////////////////////////////////

float sphere(vec3 p, float r)
{
	return length(p) - r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}


float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}


float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float length6( vec2 p )
{
	p = p*p*p; p = p*p;
	return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p )
{
	p = p*p; p = p*p; p = p*p;
	return pow( p.x + p.y, 1.0/8.0 );
}

float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}

float sdTorus62( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length6(q)-t.y;
}


float smin( float a, float b)
{
	float k = 0.1;
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float smink( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}


float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}


float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}


#define MAT_BLOCK 1.0
#define MAT_S1_TORUS 12.0
#define EPS 0.01

vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}

vec2 sun(vec2 a, vec2 b)
{
	float sm = smin(a.x,b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	
	return ca < cb ? vec2(sm, a.y) : vec2(sm, b.y);
}

vec2 sunk(vec2 a, vec2 b, float k)
{
	float sm = smink(a.x,b.x, k);
	float m = min(a.x, b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	
	return ca < cb ? vec2(sm, a.y) : vec2(m, b.y);
}


vec2 unn(vec2 a, float dis, float mat)
{
	return a.x < dis ? a : vec2(dis, mat);
}



vec2 scene(vec3 p, vec3 rd)
{
	float t = mod(iGlobalTime, 30.0);
	vec2 res = vec2(99999, -1);
	if (p.z > 23.0){
		vec3 s = vec3(30, 30, 30);
		vec3 q = mod(p - vec3(15, 15, 5), s)-0.5*s;
		
		res = vec2(sdTorus(q.xzy, vec2(4, 1)), MAT_S1_TORUS);
	}
	
	
	vec3 s = vec3(1);
	vec3 q = mod(p,s)-0.5*s;
	ivec3 n = ivec3(floor(p / s));
	float dis = -sdCylinder(vec3(n.xzy), vec3(0.0, 0.0, 15.0));
	dis = min(dis, -sdBox(vec3(n), vec3(200.0)));
	if (dis < 0.0) {
		res = un(res, vec2(udRoundBox(q , vec3(0.3), 0.23), MAT_BLOCK));
	} else {
		vec3 d = (s * 0.5 -  sign(rd)* q) / abs(rd);
		float b = min(d.x, min(d.y, d.z));
		float a = max(dis - 1.73, b + EPS);
		res = un(res, vec2(max(EPS, a), -1));
	}
	
	return res;
}



vec3 getNormal(vec3 p, vec3 rd, vec3 ro)
{
    vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = scene(p + ep.xyz, rd).x - scene(p - ep.xyz, rd).x;
    normal.y = scene(p + ep.yxz, rd).x - scene(p - ep.yxz, rd).x;
    normal.z = scene(p + ep.yzx, rd).x - scene(p - ep.yzx, rd).x;
    return normalize(normal);
}


float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}


float shadow(in vec3 ro, in vec3 rd, float mint, float maxt, float shadowAmbient)
{
    
    float t = 0.1;
    for(float _ = 0.0; _ == 0.0; _ += 0.0)
    {
        if (t >= maxt) {
        	return 1.0;
        }
        float h = scene(ro + rd*t, rd).x;
        if( h<0.01 )
            return shadowAmbient;
        t += h;
    }
    return 1.0;
}

vec3 mainImage2(vec2 fragCoord)
{
	vec3 eye = vec3(0);
	vec3 light = vec3(0);
	vec3 tar = vec3(0);
	bool waterRefract = false;
	float lightInvSize = 0.5;
	float shadowAmbient = 0.3;
	float lightIntensity = 0.004;
	bool lightCollision = false;
	const int jumps = 2;
	float refJumpDistance = 0.02;
	bool shadows = true;
	const int imax = 600;
	float tmax = 800.0;
	vec3 skyColor = vec3(0);
	bool cubicDis = false;
	vec3 rollV = vec3(0, 1, 0);
	
    float t = mod(iGlobalTime, 30.0);
    eye = vec3(0.0, -7.0, t*0.4);
    tar = eye + vec3(0.01*cos(t), 0.02*sin(t), 1.0 + 0.02*cos(t));
    if(t < 5.0){
        light = vec3(0.0, 0.0 + -7.0*smoothstep(0.0,4.0,t), -20.0 + 60.0*smoothstep(0.0, 4.0, t));	
    } else if (t < 20.0){
        float r = 13.0*smoothstep(5.0, 15.0, t);
        light = vec3(r*cos(t*2.0), -7.0 + 7.0*smoothstep(5.0,10.0,t)+ r*sin(t*2.0), 40.0);
    } else if (t < 25.0){
        float r = 13.0 - 13.0*smoothstep(20.0, 25.0, t);
        light = vec3(r*cos(t*2.0), -7.0 + 7.0*smoothstep(5.0,10.0,t) + r*sin(t*2.0), 40.0);
    } else {
        lightCollision = true;
        light = vec3(0.0,0.0, 40.0 + 70.0*smoothstep(25.0,30.0, t));
    } 

    
    
	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(rollV, dir)); //vec3(0, 1, 0)
 	vec3 up = cross(dir, right);
    
    float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x); 

    vec3 color = skyColor;//vec3(0.3);
      
    t = 0.0;
    //vec3 ro = eye + forward * 1 + right * u + up * v;
	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);
	
	float ref = 1.0;
	float lightAura = 0.0;
    float breakVar = 0.0;
	for(int j = 0; j < jumps; ++j)
    {
        if (breakVar > 0.5) {
            break;
        }
    	t = 0.0;
    	 for(int i = 0; i < imax; ++i)
   		 {
             if (t >= tmax) {
             	break;
             }
	        vec3 p = ro + rd * t;
	        vec2 dm = scene(p, rd);
	        float d = dm.x;
	        float m = dm.y;
			
			
	        if(d < EPS || i == imax || t >= tmax) //d < 0.001 
	        {
	        	vec3 x0 = light;
	        	vec3 x1 = ro;
	        	vec3 x2 = ro + rd;
	        	float ldis = pow(length(cross(x2 - x1, x1 - x0)),2.0) / pow( distance(x2, x1), 2.0); 
	        	vec3 normal = getNormal(p, rd, ro);
				
				vec3 invLight = normalize(light - p);
	        	float diffuse = max(0.,dot(invLight, normal));
	        	vec3 refrd = reflect(rd, normal);
	        	

	        	vec3 n = floor(p);
				vec3 c = vec3(0.5);
				
				if(m == MAT_BLOCK){
					c = vec3(sin(n.y) * 0.1 + 0.3, sin(n.y) * 0.1 +0.1, sin(n.y) * 0.1 + 0.1)*1.1;				
				} else if (m == MAT_S1_TORUS) {
					c = vec3(0.4, 0.4, 0.4); //TODO  + 0.7 * vec3(texture(noiseP, vec2(p.xy * 0.1)));
				}
				
	        	
	        	
                c = 0.7*c* (1.0 + diffuse);
                if(shadows){
                    c *= shadow(p, normalize(light - p), 0.1, length(light - p) - 1.0, shadowAmbient);
                }
                c += specular(normal, -invLight, normalize(eye - p), 70.0);
	        	
	            
	            float dis = length(light - p);
	            float disFact = 1.0 / (1.0 + lightIntensity*dis*dis * (cubicDis ? dis : 1.0 ));
	            c *= disFact;
				
					        	
	        	float tl = -dot(x1 - x0, x2 - x1)/pow(distance(x2,x1),2.0);
	        	if(tl > 0.0 && ((lightCollision && distance(eye, light) < distance(eye, p)) || !lightCollision)){
	        		lightAura = max(lightAura, 1.0/(0.01 + lightInvSize*ldis));
	        	}
				
				color = mix(color, c, ref);
				
				
                rd = reflect(rd, normal);

                ro = p + rd*refJumpDistance;


				
	           
	        	
	        
		        ref = 0.0;
	        	
	        	if (ref <= 0.01) {
					breakVar = 1.0;	        		
	        	}
	           	break;
	        }
	
	        t += d;
    	}
    }
    
   
    fragColor = vec4(color + vec3(lightAura),  1.0); 
    return fragColor.xyz;
}	








/////////////////////////////////////////////////////


#define SIZE 5.0
float map1(vec3 p) {
	float s = SIZE;
	vec3 q = vec3(mod(p.x, s) - s * 0.5, p.y, mod(p.z, s) - s * 0.5);
	return udRoundBox(q, vec3(s * 0.4), s * 0.1);
}

ivec2 raymarch(vec3 ro, vec3 rd, inout vec3 finalPos) {
	float t = 0.0;
	const int maxIter = 1000;
	const float maxDis = 3000.0;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	ivec2 xy = ivec2(-1, -1);
	for (int i = 0; i < maxIter; i++) {
		p = ro + rd * t;
		
		
		d = map1(p);
		if (d < 0.01) {
			float s = SIZE;
			xy = ivec2(p.xz / SIZE);
			break;
		}
		t += d;
		if (t > maxDis) {
			break;
		}
	}
	finalPos = p;
	return xy;
}

vec3 getNormal1(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map1(p + ep.xyz) - map1(p - ep.xyz);
    normal.y = map1(p + ep.yxz) - map1(p - ep.yxz);
    normal.z = map1(p + ep.yzx) - map1(p - ep.yzx);
    return normalize(normal);

}


void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
    vec3 eye = vec3(20.0 + iGlobalTime * 3.0, 20.0, 20.0 + iGlobalTime * 3.0) + vec3(600.0, 500.0, -200.0) * max(mod(iGlobalTime, 30.0) - 3.0, 0.0) / 30.0;//vec3(iGlobalTime * 0.5, 100.0, iGlobalTime);
	vec3 tar = eye + vec3(0.0, -1.0, 1.0);

	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 20.0, -20.0);

	vec3 finalPos = vec3(-1.0, -1.0, -1.0);
	float material = -1.0;
	ivec2 xy = raymarch(ro, rd, finalPos);
	xy *= 5;
	vec3 color = vec3(0.0, 0.0, 0.0);
	if (xy.x >= 0 && xy.y >= 0 && xy.x < 1280 && xy.y < 720) {
		color = mainImage2(vec2(xy));
	    vec3 normal = getNormal1(finalPos);
		vec3 invLight = normalize(light - finalPos);
		float diffuse = max(0.0, dot(invLight, normal));
		color = 0.7 * color * (1.0 + diffuse);
		color += specular(normal, -invLight, normalize(eye - finalPos), 70.0) * (1.0 - smoothstep(20.0, 100.0, eye.y));
		
	}
    fragColor = vec4(color, 1.0);
}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
