#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;

#define compactKeys  10
uniform float midi[10 * compactKeys];


float getClosestDistance(vec3 p)
{
	float d = 0.0;
    float minD = 1.0;
    
	d = max(0.0, p.y);
	if(d<minD)
	{
		minD = d;
	}
	
	d = max(0.0,p.x);
	if(d<minD)
	{
		minD = d;
	}
	
	d = max(0.0,40.0-p.x);
	if(d<minD)
	{
		minD = d;
	}
	
	d = max(0.0,-p.z);
	if(d<minD)
	{
		minD = d;
    }
    
	return minD;
}




vec3 evaluateLight(in vec3 pos)
{
	
    float s = 4.0;
	vec3 origp = vec3(pos);
	vec3 q = floor(pos / s);
	int indexChannel = int(q.y);
	int indexKey = int(q.x);
	
	pos = mod(pos, s);
	pos.z = origp.z;
    vec3 lightPos = vec3( s * 0.5, s * 0.5,  1.0);
    vec3 lightCol = (2000.0*normalize(vec3(0.5 + 0.5 * sin(q.y * 3.4), 0.5 + 0.5 * cos(q.y * 5.3), 0.5 + 0.5 * sin(q.y * 7.3))));
    vec3 L = lightPos-pos;
    float distanceToL = length(L);
    vec3 point = lightCol * 1.0/(distanceToL*distanceToL);
    vec3 Lnorm = L/distanceToL;
    float dir = max(0.0, dot(Lnorm, vec3(0.0, -1.0, 0.0)));
    
    float m = 0.0;
    if (indexChannel >= 0 && indexChannel < 10) {
    	m = 2 * midi[indexChannel * compactKeys + indexKey % compactKeys];
    }
    
    float cy = length(pos.xy - lightPos.xy-vec2(0.0, 0.0))- m;
    return point * clamp(-cy, 0.0, 1.0) + point * 0.05;
}




void traceScene(bool improvedScattering, vec3 rO, vec3 rD, inout vec3 scatteredLight)
{
	const int numIter = 100;
	
    float muS = 0.06;
    
    
    // Initialise volumetric scattering integration (to view)
    float transmittance = 1.0;
    
	float d = 1.0; // hack: always have a first step of 1 unit to go further
	float material = 0.0;
	vec3 p = vec3(0.0, 0.0, 0.0);
    float dd = 0.0;
	for(int i=0; i<numIter;++i)
	{
		vec3 p = rO + d*rD;
        
        // See slide 28 at http://www.frostbite.com/2015/08/physically-based-unified-volumetric-rendering-in-frostbite/
        vec3 S = evaluateLight(p);// incoming light
        vec3 Sint = S - S * exp(-muS * dd); // integrate along the current step segment
        scatteredLight += transmittance * Sint; // accumulate and also take into account the transmittance from previous steps

        // Evaluate transmittance to view independentely
        transmittance *= exp(-muS * dd);
		
		
        dd = getClosestDistance(p);
        if(dd<0.2)
            break; // give back a lot of performance without too much visual loss
		d += dd;
	}
}


void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
	vec2 uv = fragCoord.xy / iResolution.xy;
	vec2 uv2 = 2.0*fragCoord.xy / iResolution.xy - 1.0;
	
	vec3 camPos = vec3( 20.0, 18.0,-80.0);
     
	vec3 camX   = vec3( 1.0, 0.0, 0.0) *0.75;
	vec3 camY   = vec3( 0.0, 1.0, 0.0) *0.5;
	vec3 camZ   = vec3( 0.0, 0.0, 1.0);
	
	vec3 rO = camPos;
	vec3 rD = normalize(uv2.x*camX + uv2.y*camY + camZ);

    vec3 color = vec3( 0.0, 0.0, 0.0);
    traceScene( fragCoord.x>(iResolution.x/2.0),  rO, rD, color);
	

    
    // Gamma correction
	color = pow(color, vec3(1.0/2.2)); // simple linear to gamma, exposure of 1.0
   

	fragColor = vec4(color ,1.0);
}

void main()
{
	mainImage(fragColor, fragCoord);
}
