#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;

//#define EXAMPLE_ONE //  2D polar mod cylinder
//#define EXAMPLE_TWO // 3D polar mod cylider
#define EXAMPLE_THREE // 2D polar mod + len mod capped cyliders
//#define EXAMPLE_FOUR // spherical mod
//#define EXAMPLE_FIVE // mod + noise = art

vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

#define PI 3.1415

#ifdef EXAMPLE_ONE
vec2 map(vec3 p)
{	
	if (p.x == 0.0) {
		p.x = 0.00001;
	}
	float angle = atan(p.y, p.x);
	float numParts = 3.0;
	float partSize = PI / numParts;
	angle += PI;
	float part = floor(angle / partSize);
	angle = mod(angle, partSize) + partSize * 0.5 * max(0.0, numParts - 1.0);
	float len = length(p.xy);
	vec3 newPos = vec3(len * cos(angle), len * sin(angle), p.z);
	return vec2(sdCylinder(newPos, vec3(0.0, 0.0, 0.5)), part);
}
#endif

#ifdef EXAMPLE_TWO
vec2 map(vec3 p)
{	
	p = p.zyx;
	
	float numParts = 10; 
	float partSize = PI / numParts;
	

	float angleo = atan(p.y, p.x) + PI;
	float angle = mod(angleo, partSize)  + partSize * 0.5 * max(0.0, numParts - 1.0);

	float angleYZ = atan(length(p.xy) * sin(angle), p.z) + PI;
	float partYZ = floor(angleYZ / partSize);
	
	
	float ring = partYZ * 0.5;
	float numPartsYZ = 10; // bero p partYZ
	if (abs(ring - 5.0) < 0.001) {
		numPartsYZ = 2.0;
	}
	if (abs(ring - 5.5) < 0.001) {
		numPartsYZ = 5.0;
	}
	float partSizeYZ = PI / numPartsYZ;
	float partXY = floor(angleo / partSizeYZ);
	angle = mod(angleo, partSizeYZ)  + partSizeYZ * 0.5 * max(0.0, numPartsYZ - 1.0);
	float len = length(p.xy);
	vec3 intermediatePos = vec3(len * cos(angle), len * sin(angle), p.z);

	angleYZ = atan(intermediatePos.y, intermediatePos.z) +  PI;
	partYZ = floor(angleYZ / partSizeYZ);
	
	angleYZ = mod(angleYZ, partSize) + partSize * 0.5 * max(0.0, numParts - 1.0);
	float lenYZ = length(intermediatePos.yz);
	vec3 finalPos = vec3(intermediatePos.x, lenYZ * sin(angleYZ), lenYZ * cos(angleYZ));
	
	
	float rs = 1.0;
	finalPos.y = mod(finalPos.y , rs) - rs/2.0;
	
	
	//float minDistance = sdCappedCylinder(finalPos, vec2(0.5, 1.0));
	float minDistance = udRoundBox(finalPos, vec3(0.3), 0.2);
	
	return vec2(minDistance, /*ring * 10.0*/mix(partXY, partYZ, 0.5));

}
#endif


#ifdef EXAMPLE_THREE
vec2 map(vec3 p)
{	
	if (p.x == 0.0) {
		p.x = 0.00001;
	}
	float angle = atan(p.y, p.x);
	float numParts = 12.0;
	float partSize = PI / numParts;
	angle += PI;
	float part = floor(angle / partSize);
	angle = mod(angle, partSize) + partSize * 0.5 * max(0.0, numParts - 1.0);
	float len = length(p.xy);
	float lenSize = 4.0;
	float lenY = mod(len, lenSize) - lenSize * 0.5;
	float lenPart = floor(len / lenSize);
	vec3 newPos = vec3(len * cos(angle), lenY * sin(angle), p.z);
	return vec2(sdCappedCylinder(newPos, vec2(0.5, 1.0)), part + lenPart * 10);
}
#endif

#ifdef EXAMPLE_FOUR
vec2 map(vec3 p)
{	
	float r = length(p);
	
	float phi = acos(p.z / r);
	//float phi = PI/2 - (PI/2)*(p.z/r);
	float phio = phi;
	float theta = atan(p.y, p.x);
	//phi = atan(p.y, p.z);
	
	float s = 10.0;
	float mr = mod(r, s) - s * 0.5;
	float qr = floor(r / s);
	
	float n  = 4.0;
	phi = mod(phi, PI / n)  + (n - 1.0) * 0.5 * PI / n;
	//theta = mod(theta, PI / n) + (n - 1.0) * 0.5 * PI / n;
	
	phi *= r * sin(theta);
	theta *= r;
	
	float x = r * sin(phi) * cos(theta);
	float y = r * sin(phi) * sin(theta);
	float z = r * cos(phi);
	
	return vec2(1.0 * sdCappedCylinder(vec3(x, y, z), vec2(0.5, 3.0)), phio/PI);	
}
#endif

#ifdef EXAMPLE_FIVE
vec2 map(vec3 p)
{
	p += vec3(40.0, 40.0, 0.0);
	float s = 0.0 + texture(iChannel0, p.xy * 0.015 + iGlobalTime * 0.03).x * 10.0;
	//p.y += iGlobalTime;
	vec3 q = floor(p / s);
	//p.x += sin(q.y + iGlobalTime);
	//q = floor(p / s);
	//p.y += sin(q.x + iGlobalTime);
	vec3 m = mod(p, s) - s * 0.5;
	return vec2(1.0 * udBox(vec3(m.x, m.y , p.z), vec3(2.0, 2.0, 0.1)), q.x + 10 * q.y);
}
#endif



vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}

float raymarch(vec3 ro, vec3 rd, inout vec3 finalPos) 
{
	float t = 0.0;
    const int maxIter = 100;
    
    float part = -1.0;
    
    vec3 p = vec3(-1.0, -1.0, -1.0);
    for (int i = 0; i < maxIter; i++) {
        p = ro + rd * t;

    	vec2 dm = map(p);
        if (dm.x < 0.01) {
        	part = dm.y;
        	break;
        }
        t += dm.x * 1.0;
    }
    finalPos = p;
    return part;
}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
 	vec3 eye = vec3(40, sin(iGlobalTime * 1.0) * 10.0 , cos(iGlobalTime * 1.0) * 10.0);
    vec3 tar = eye + vec3(0.0, 0.0, 0.1);
   	tar = vec3(0, 0, 0);
    vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir)); 
 	vec3 up = cross(dir, right);
    
	vec3 ro = eye;	
    vec3 rd = normalize(dir + right*u + up*v);
    
    vec3 light = vec3(0.0, 20.0, -20.0);
    
    vec3 finalPos = vec3(-1.0, -1.0, -1.0);
    float part = raymarch(ro, rd, finalPos);
   	vec3 color = vec3(0.5, 0.0, 0.5);
    if (part >= 0.0) {
		vec3 normal = getNormal(finalPos);
		vec3 invLight = normalize(light - finalPos);
	  	float diffuse = max(0.0, dot(invLight, normal));
    	color = vec3(0.4 + 0.4 * sin(part), 0.4 + 0.4 * sin(part * 0.5 + 1.0), 0.4 + 0.4 * sin(part * 0.25 + 2.0));
    	//color = vec3(part);
    	//color = vec3(length(finalPos - eye) * 0.01);
    	color = 0.7 * color * (1.0 + diffuse);
	    //color += specular(normal, -invLight, normalize(eye - finalPos), 70.0);
    }
 
    fragColor = vec4(color, 1.0);
}

void main()
{
	mainImage(fragColor, fragCoord);
}
