#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;



vec4 texCube( sampler2D sam, in vec3 p, in vec3 n, in float k )
{
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
    vec3 w = pow( abs(n), vec3(k) );
	return (x*w.x + y*w.y + z*w.z) / (w.x+w.y+w.z);
}

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

int[64] arr = int[](0,0,0,0,0,0,0,0,
					0,1,0,1,0,1,1,1,
					0,1,0,1,0,1,0,0,
					0,1,1,1,0,1,1,0,
					0,1,0,1,0,1,0,0,
					0,1,0,1,0,1,1,1,
					0,0,0,0,0,0,0,0,
					0,0,0,0,0,0,0,0
);

vec4 map(vec3 pos, vec3 rd)
{	
	vec3 d = vec3(1);
	vec3 q = mod(pos, d) - 0.5 * d;

	vec3 s = (d * 0.5 -  sign(rd)* q) / abs(rd);
	vec2 part = floor(pos.xy / d.xy);

	pos.xy = mod(pos.xy, d.xy) - d.xy * 0.5;
	vec3 c =  texture2D( iChannel0, vec2(-part.x, -part.y - 32) / 64.0).xyz;
	int i = int(-part.x + 16*part.y);
	//int c = arr[i%64];

	float dis = udRoundBox(pos, vec3(0.3), 0.1);
	float b = min(s.x, min(s.y, s.z));
	if(c.x == 1.0){
		dis = max(b + 0.01, dis);
	}

	return vec4(dis, c);
}

vec3 raymarch(vec3 ro, vec3 rd, inout vec3 finalPos)
{
	float t = 0.0;
    const int maxIter = 150;
    
    float material = 0.0;
    vec3 color = vec3(0);
    vec3 p = vec3(-1.0, -1.0, -1.0);
    for (int i = 0; i < maxIter; i++) {
        p = ro + rd * t;

    	vec4 dm = map(p, rd);
        if (dm.x < 0.01) {
        	color = dm.yzw;
        	break;
        }
        t += dm.x * 0.4;
    }
    finalPos = p;
    return color;
}

vec3 getNormal(vec3 p, vec3 rd)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz, rd).x - map(p - ep.xyz, rd).x;
    normal.y = map(p + ep.yxz, rd).x - map(p - ep.yxz, rd).x;
    normal.z = map(p + ep.yzx, rd).x - map(p - ep.yzx, rd).x;
    return normalize(normal);

}






float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
 	vec3 eye = vec3(64, 0 , 70);
   // vec3 tar = eye + vec3(0.0, 0.0, 0.1);
   	vec3 tar = vec3(65, 0, 0);
    vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir)); 
 	vec3 up = cross(dir, right);
    
	vec3 ro = eye;	
    vec3 rd = normalize(dir + right*u + up*v);
    
    vec3 light = vec3(0, 0, 0);
    
    vec3 finalPos = vec3(-1.0, -1.0, -1.0);
    vec3 color = raymarch(ro, rd, finalPos);
   	//vec3 color = vec3(0.5, 0.0, 0.2);
	vec3 normal = getNormal(finalPos, rd);
	vec3 invLight = normalize(light - finalPos);

  	float diffuse = max(0.0, dot(invLight, normal));
	//color = vec3(occlusion(finalPos, normal));
	color = 0.7 * color * (1.0 + diffuse);
  //  color += specular(normal, -invLight, normalize(eye - finalPos), 70.0);
 
    fragColor = vec4(color, 1.0);
}

void main()
{
	mainImage(fragColor, fragCoord);
}
