#version 430

in vec2 fragCoord;
out vec4 fragColor;

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform vec3 iMouse;
uniform sampler2D iChannel0;
/////////////////////////////////////////////////////
#define MAT_HOUSE 1.0
#define MAT_SIDE_WALK 2.0
#define MAT_STREET 3.0
#define MAT_LAMP_POST 4.0
float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

vec2 un(vec2 dm1, vec2 dm2) {
	return dm1.x < dm2.x ? dm1 : dm2;
}

vec2 map(vec3 o) {
	vec2 dm = vec2(99999999.0, -1.0);
	vec2 street = vec2(o.y + 10, MAT_STREET);
	dm = un(dm, street);
	return dm;
}

float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}




vec4 windowLight(vec3 pos) {
	
	vec2 d = vec2(0.5, 0.5);
	
	vec2 part = floor(pos.xz / d);
	pos.xz = mod(pos.xz, d) - d * 0.5;
//	pos.y += 10*sin(iGlobalTime * 0.3 + part.y + part.x*0.3) - 10;
	if (pos.y <= 1) {
		pos.y = mod(pos.y, 0.5) - 0.5 * 0.5;
	}
	vec3 lightPos = vec3(0.0, 0, 0.0);
	vec3 lightCol =  0.1 * texture2D( iChannel0, vec2(part.x - 16, -part.y)/ 32.0).xyz;//0.1*vec3(1.0, 1.0, 0.3);
	vec3 L = lightPos-pos;
	float distanceToL = max(0.0001, length(pos));
	vec3 point = lightCol * 1.0/(distanceToL*distanceToL);

	return vec4(point, distanceToL);
}

#define PI 3.1415
vec3 evaluateLight(vec3 pos, inout float dis)
{
	vec4 window = windowLight(pos);
	dis = window.w;
	return window.xyz;
}

vec3 raymarch(vec3 ro, vec3 rd, inout vec3 finalPos, inout float transmittance, inout float material) {
	float t = 0.0;
	const int maxIter = 500;
	const float maxDis = 100.0;
	material = 0.0;
	float d = 0.0;
	vec3 p = vec3(-1.0, -1.0, -1.0);
	vec3 scatteredLight = vec3(0.0);
	transmittance = 1.0;
	for (int i = 0; i < maxIter; i++) {
		p = ro + rd * t;
		vec2 dm = map(p);
		d = dm.x;
		float fogAmount = 0.25 * (1-smoothstep(0, 8, p.y));//(1-smoothstep(0, 8, p.y)) * 0.45 + 0.05;//0.06;
		float lightDis = -1.0;
		vec3 light = evaluateLight(p, lightDis);
		d = min(d, max(lightDis * 0.5, 0.08)); // 0.08
		vec3 lightIntegrated = light - light * exp(-fogAmount * d);
		scatteredLight += transmittance * lightIntegrated;
		transmittance *= exp(-fogAmount * d);


		if (dm.x < 0.01) {
			material = dm.y;
			break;
		}
		t += d;
		if (t > maxDis) {
			break;
		}
	}
	finalPos = p;
	return scatteredLight;
}

vec3 getNormal(vec3 p)
{
	vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = map(p + ep.xyz).x - map(p - ep.xyz).x;
    normal.y = map(p + ep.yxz).x - map(p - ep.yxz).x;
    normal.z = map(p + ep.yzx).x - map(p - ep.yzx).x;
    return normalize(normal);

}

float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	float u = (fragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((fragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x);
    
//    vec3 eye = vec3(iGlobalTime * 0.5, 2.0, iGlobalTime);
    vec3 eye = vec3(5, -3.0 + iGlobalTime, 5);
//	vec3 tar = eye + vec3(sin(iGlobalTime * 0.1), -0.8, cos(iGlobalTime * 0.1));
	vec3 tar = vec3(-1, -1, 1);//eye + vec3(0, -0.8, 0.4);

	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(vec3(0, 1, 0), dir));
	vec3 up = cross(dir, right);

	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);

	vec3 light = vec3(0.0, 20.0, -20.0);

	vec3 color = vec3(0.5, 0.0, 0.5);
	vec3 finalPos = vec3(-1.0, -1.0, -1.0);
    //float material = raymarch(ro, rd, finalPos);
	float transmittance = -1.0;
	float material = -1.0;
	vec3 scatteredLight = raymarch(ro, rd, finalPos, transmittance, material);
    if (material ==  MAT_HOUSE) {
    	/*if (mod(finalPos.x + 0.1, 0.5) > 0.48 || mod(finalPos.y, 0.5) > 0.48 || mod(finalPos.z + 0.1, 0.5) > 0.48) {
    		color = vec3(0.1, 0.1, 0.55);
    	} else {
    		color = vec3(0.1, 0.1, 0.6);
    	}*/
    	color = vec3(0.35, 0.25, 0.3);
    } else if (material ==  MAT_SIDE_WALK) {
    	color = vec3(0.7);
    } else if (material ==  MAT_STREET) {
    	color = vec3(0.3);
    } else if (material ==  MAT_LAMP_POST) {
    	color = vec3(0.5);
    }
    vec3 normal = getNormal(finalPos);
	vec3 invLight = normalize(light - finalPos);
	float diffuse = max(0.0, dot(invLight, normal));
	color = 0.7 * color * (1.0 + diffuse);
	color += specular(normal, -invLight, normalize(eye - finalPos), 70.0);
	//color = mix(color, vec3(0.6), 1.0 - exp(-length(ro - finalPos)*0.05));
    fragColor = vec4(color, 1.0);

    fragColor = vec4(transmittance * color + scatteredLight, 1.0);
    fragColor.rgb = fragColor.rgb / (fragColor.rgb + vec3(1.0));

}

/////////////////////////////////////////////////////
void main()
{
	mainImage(fragColor, fragCoord);
}
