#version 130
varying vec2 tCoord;
varying vec4 pos;
varying float distPosToCam;
uniform sampler2D iChannel0;
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec3 cameraPosition;
uniform float poppin;
uniform float speed;
uniform float rotato;
uniform float rasternoise;



#define MAX_STEPS 88.
#define MAX_DISTANCE 0.5
#define epsilon 0.0015
#define infinite 1e7
#define lightSize 4.
#define powLight 2.
#define lightColor vec3(1.0)
vec3 lightSource = vec3(2.0,4.0,-4.0);


float circle(vec2 coord, vec2 pos, float size){
    return min(floor(distance(coord,pos)-size),0.);
}
float roundBox(vec2 coord, vec2 pos, vec2 b ){
  return length(max(abs(coord-pos)-b,0.0));
}


mat3 rotationMatrix(vec3 axis, float angle) {
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float rand(float co){
    return rand(vec2(co));
}
float smin( float a, float b, float k ) {
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float udRoundBox( vec3 p, vec3 b, float r ) {
  return length(max(abs(p)-b,0.0))-r;
}
float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}
float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    q=q.zxy;
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdTorus82( vec3 p, vec2 t )
{
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
mat3 rotY(in float a)
{
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}

mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float getColorReflection( vec3 position, out vec3 color, out float reflectiveValue) {

    float T=iGlobalTime*1.4;
    vec3 _position = position;
    
    vec3 _position2 = position;
    float dist = 1e5;
    float dist2 = 1e5;
    vec3 boxpos = _position-vec3(0.0,0.0,0.0);
        boxpos *= 
            rotationMatrix(
                vec3(
                    0.043532,
                    0.2342,
                    0.07674),iGlobalTime/3.);
    
        dist = min( dist, sdBox(boxpos,vec3(0.2,0.2,0.2)));
        dist = max( dist, -sdBox(boxpos,vec3(0.22,0.19,0.19)));
        dist = max( dist, -sdBox(boxpos,vec3(0.19,0.22,0.19)));
        dist = max( dist, -sdBox(boxpos,vec3(0.19,0.19,0.22)));
    for(float i=0.; i<7.; i++)
    dist2 = smin( 
            dist2, 
            sdSphere( boxpos-0.18*vec3(sin(i*535.3+rand(i+2.)*T),cos(i*1232.+rand(i+3.)*T),cos(i*53.+rand(i+4.)*T)), 0.06+0.03*sin(i+iGlobalTime)), 24. );
    
    dist2 = max( dist2, sdBox(boxpos,vec3(0.19)));
    dist=min(dist,dist2);
    reflectiveValue = 0.4;
        float a=mod((boxpos.y+boxpos.x+boxpos.z)*13.,2.);
        color = vec3(1.0-floor(min(a,1.0)));
        color -=vec3(0.8,0.9,0.3)*pow(max(1.-length(boxpos),0.),8.);
    color+=vec3(.2);
    dist -= floor(rand(_position.xz)*2.+rand(_position.zy)*2.)/10000.;
    return dist;
}
float getDistance( in vec3 position) {
    vec3 _position = position;
    vec3 c;
    float r;
    return getColorReflection(_position, c, r);
}
vec3 getSurfaceNormal(vec3 position) {
    float e=epsilon;
    vec3 normalVector = vec3(
                            getDistance(position+vec3( e,  0., 0.)) - getDistance(position+vec3(  -e,   0.,  0.)) ,
                            getDistance(position+vec3( 0., e,  0.)) - getDistance(position+vec3(   0., -e,   0.)) ,
                            getDistance(position+vec3( 0., 0., e)) - getDistance(position+vec3(    0.,  0., -e)) );
    normalVector = normalize(normalVector);
    return normalVector;
}
float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.4;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<66; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.01) break;
    }
    return clamp(res,0.1,9.0);
}
float fastTraceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.2;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<11; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.01) break;
    }
    return clamp(res,0.65,9.0);
}
float getSurfaceColor( vec3 curPosition, vec3 normalVector, vec3 lightSource, vec3 lightDirection) {
    float intensity = lightSize * pow( 0.001 + max(0.0, dot( lightDirection, normalVector)),  powLight);
    intensity = lightSize * pow( intensity / distance( curPosition, lightSource),  powLight);
    intensity += pow (max( dot( normalize( lightSource - curPosition), normalVector), 0.0), powLight);
    return intensity;
}
vec3 giTrace(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    int hit = 0;
    vec3 rna=vec3(rand(rayOrigin.xy)-.5,rand(rayOrigin.xz)-.5,rand(rayOrigin.zy)-.5);
    #define maxSamples 3.
        for(float i = 0.; i < maxSamples; i++) {
                rna +=rna.zxy;
                vec3 curPosition = 
                    rayOrigin + normalize(rayDirection + 0.2*rna );
                vec3 color = vec3( 0.0);
                float reflection = 0.0;
                getColorReflection( curPosition, color, reflection);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                finalLight += light*max(lightSize*directLight,0.01);
                endColorResult +=  color * finalLight;
        }
    
    return endColorResult / maxSamples;
}
vec4 passTrace(vec3 rayOrigin, vec3 rayDirection, out vec3 inside_colored) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    float finalLight = 1.0;
    float dist = 0.0;
    float storeColorStrength = 1.0;
    float globalIllumination=0.;
    float lengthGone = 0.0;
    float stepped = 0.0;
    #define LARGE_STEP 0.01
    /*raymarch through with bigger steps*/
        for(float i = 0.; i < MAX_STEPS/3.; i++) {
            stepped += LARGE_STEP;
            float stepable = getDistance( curPosition);
      
            curPosition += LARGE_STEP * rayDirection;
            lengthGone += LARGE_STEP;
            vec3 sLight = lightColor  * distance(curPosition, lightSource);
            inside_colored += LARGE_STEP * lightSize * sLight / (1.0 + pow( distance(lightSource, curPosition) ,  powLight) );
            if( getDistance( curPosition) > epsilon) {
                break;
            } 
            /*too far from begining  point, call it an end*/
            if( distance( prevPosition.xy, curPosition.xy) > MAX_DISTANCE) {
                break;
            }
        }
    inside_colored = inside_colored * lengthGone * 0.01;
    return vec4( curPosition, distance(prevPosition,curPosition));
}
vec3 AO(vec3 rayOrigin, vec3 rayDirection) {
    float AO = 0.0;
    for(float i=1.0; i<12.0; i++) {
        vec3 position =  rayOrigin + i * 0.01 * rayDirection;
        AO += getDistance( position);
    }
    return vec3(AO);
}
vec4 oneTrace(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    int hit = 0;
    
        for(float i = 0.; i < MAX_STEPS/8.; i++) {
            float stepable = getDistance( curPosition);
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;

           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                vec3 color = vec3( 0.0);
                float R = 0.0;
                getColorReflection( curPosition, color, R);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                float albedo = 0.9;
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
                vec3 lightColorInside = color + finalLight * lightColor;
               
                vec3 surfaceFinalColor = color * lightColor * storeColorStrength * finalLight;
                
                float surfLight = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                float surfLightBackSide = 0.3333;
                
                float scatterDeathDepth = 0.3333;
                vec3 backSide = vec3(0.0);

                endColorResult += storeColorStrength * pow(max(dot(normalize(lightSource-curPosition),normalVector),0.0),powLight);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) / (1.0+surfLight+surfLightBackSide);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * pow(lightColor,vec3(powLight))/ (1.0+surfLight+surfLightBackSide+scatterDeathDepth+pow(distance(curPosition,lightSource),2.) ) ;
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * ( (surfLight+surfLightBackSide) ) * R * surfaceFinalColor ;
                
                storeColorStrength *= R / (1.0+scatterDeathDepth);
                hit = 1;
                dist = 0.0;
                prevPosition = curPosition + normalVector;
                curPosition = prevPosition;
                rayDirection = reflect(rayDirection, -normalVector);
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition*vec3(1.,1.,.3)) > MAX_DISTANCE) {
                break;
            }
    }
    vec3 lightDir = (lightSource-rayOrigin);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    vec3 backdrop=min(max( pow(directLight,2.1) * vec3(1.8,1.1,.9) * 4., 0.01),1.);
    backdrop = pow(backdrop,vec3(2.0));
    if(hit==0) endColorResult += backdrop ;
    return vec4( endColorResult, 1.);
}

vec4 march(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    int hit = 0;
    float collisions = 0.;
    float distanceOfCollision = 1111110.;
        for(float i = 0.; i < MAX_STEPS; i++) {
            float stepable = getDistance( curPosition);
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;
           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                vec3 color = vec3( 0.0);
                float R = 0.0;
                getColorReflection( curPosition, color, R);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                float albedo = 0.9;
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
                vec3 lightColorInside = color + finalLight * lightColor;
               
                vec3 surfaceFinalColor = color * lightColor * storeColorStrength * finalLight;
                
                vec4 pos_ilum = passTrace( curPosition + epsilon * rayDirection, normalize(rayDirection*rotationMatrix(normalVector,0.1)), lightColorInside);
                
                float surfLight = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                float surfLightBackSide = getSurfaceColor(-pos_ilum.xyz, -normalVector, lightSource, lightDirection);
                
                float scatterDeathDepth = pow(pos_ilum.w,2.0)*24.0;
                vec3 backSide = ( lightColorInside + color * lightColor * storeColorStrength *  oneTrace(pos_ilum.xyz + 2. * epsilon * rayDirection, rayDirection).rgb ) / (1.0 + scatterDeathDepth);
                            

                endColorResult += (lightColor + color)/2. * storeColorStrength * pow(max(dot(normalize(lightSource-curPosition),normalVector),0.0),powLight);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) / (1.0+surfLight+surfLightBackSide);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * pow(lightColor,vec3(powLight))/ (1.0+surfLight+surfLightBackSide+scatterDeathDepth+pow(distance(curPosition,lightSource),2.) ) ;
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * ( (surfLight+surfLightBackSide) ) * R * surfaceFinalColor / (1.0+pow(distance( curPosition, pos_ilum.xyz), 6.2 ));
                if(collisions==0.){
                    vec3 AOresult = log(AO(curPosition, normalVector)) /5. ;
                    endColorResult +=  AOresult /(1.0+(surfLight+surfLightBackSide));
                }
                collisions++;
                storeColorStrength *= R;
                hit = 1;
                dist = 0.0;
                prevPosition = curPosition + normalVector * epsilon;
                curPosition = prevPosition;
                rayDirection = reflect(rayDirection, -normalVector);
                break;
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition) > MAX_DISTANCE) {
                break;
            }
    }
    
    
    vec3 lightDir = (lightSource-rayOrigin);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    vec3 backdrop=min(max( pow(directLight,7.1) * vec3(1.0) * 5.6, 0.01),1.);
    
    vec2 p = gl_FragCoord.xy / iResolution.xy;
    float aspectCorrection = (iResolution.x/iResolution.y);
    vec2 coordinate_entered = 2.0 * p - 1.0;
    vec2 coord = vec2(aspectCorrection,1.0) *coordinate_entered;
     vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float vignette = .6 / (.8 + 1.3*dot(uv.xy, uv.xy));
    backdrop += vec3(1.0,0.5,0.1) - vec3(0.4,0.2,0.1) * floor(mod((uv.x+uv.y*.8)*12.0,2.0)) ;
    backdrop *= sin(coord.x)*0.5+0.6;
    backdrop += vec3(0.5,0.2,0.0)*sin(coord.x)*0.5+0.6;
    backdrop /=2.0;
    backdrop = max(min(backdrop,vec3(2.0)),vec3(0.0));
    if(hit==0) endColorResult += backdrop ;
    endColorResult = max(endColorResult,vec3(0.0));
    return vec4( endColorResult, 1.);
}
float resolveRaySphereIntersection(vec3 b, vec3 c, vec3 dir){
    vec3 OC=b-c;
    float P=dot(OC,dir);
    if(P<0.) return 1111.0;
    float d=sqrt(pow(length(OC),2.0)-pow(P,2.0));
    return d;
}
float trace(vec3 rayOrigin, vec3 rayDirection) {
    return resolveRaySphereIntersection(vec3(0.0,3.0,2.0), rayOrigin, rayDirection)*3.0;
}
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

vec4 render( vec2 uv ) {  
     float aspect = iResolution.x / iResolution.y;
        vec3 cameraPosition = vec3( 0.0, 0.0, 0.8);
        vec3 direction = normalize( vec3(.5 * uv * vec2( aspect, 1.0), 0.9 ) );
        cameraPosition *= rotationMatrix(vec3(0.0,1.0,0.0), -poppin);
        direction *= rotationMatrix(vec3(0.0,1.0,0.0),+poppin);
        cameraPosition *= rotationMatrix(vec3(0.0,1.0,0.0), -speed);
        direction *= rotationMatrix(vec3(0.0,1.0,0.0),+speed);
        direction.z *= -1.0;
    
        vec4 color = march( cameraPosition, direction);

        return color;
        
}

vec3 tone(vec3 color, float gamma)
{
    float white = 2.;
    float luma = dot(color, vec3(0.2126, 0.7152, 0.0722));
    float toneMappedLuma = luma * (1. + luma / (white*white)) / (1. + luma);
    color *= toneMappedLuma / luma;
    color = pow(color, vec3(1. / gamma));
    return color;
}


void main() {  
     vec2 p = gl_FragCoord.xy / iResolution.xy;
     vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;

        uv.x += (rand(iGlobalTime*uv.y)-.5)*rasternoise;
     float aspect = iResolution.x / iResolution.y;
        vec4 C=render( uv );
        vec4 selectedColor = vec4(0.0,0.0,0.0,1.0);
         if(length(C.rg)>0.2) {
             selectedColor.rgb = vec3(1.0,0.0,0.0);
         }
         if(length(C.rb)>0.4) {
             selectedColor.rgb = vec3(1.0,0.5,0.0);
         }
         if(length(C.gb)>0.6) {
             selectedColor.rgb = vec3(1.0,1.0,0.0);
         }
         if(length(C.rb)>0.8) {
             selectedColor.rgb = vec3(1.0,1.0,0.5);
         }
         if(length(C.rg)>0.9) {
             selectedColor.rgb = vec3(1.0,1.0,1.0);
         }
         C = selectedColor * rotato + C * (1. - rotato);
        gl_FragColor =  C ;
    
}
