
function player_(){
	this.pos = vec3.create();
	this.fire_cooldown = 0;
	this.color = 0;
	this.model = drawables["player"];
	this.rot = quat.create();
	this.rote = vec3.create(); // euler
	this.rotv = vec3.create(); // vel
	this.glow = 0.0;
	this.size = 1.0;
	this.fire_cooldown = 0;
	
	this.ammo = 250;
	
	this.rote[0] = -Math.PI / 2.0;
	this.rote[1] = 0.1;
	this.rote[2] = 0.0;

	this.rspd = 0; // Rotational speed;
	this.r = 0; // Spin
	
	this.velx = 0;
	this.vely = 0;
	
	this.alive = 1;
}

var SPIN_RATE = 0.0035;
var MOVE_RATE = 0.005;
var ROT_OFFSET = 1.5707963267948966192313216916398;
var CHEESE_RATE = 16.0;

player_.prototype.tick = function(){
	if(this.fire_cooldown) this.fire_cooldown--;
	if(movekeys[0]){
		if(this.ammo > 0 && this.fire_cooldown == 0){
			this.fire_cooldown = 6;
			var bp = vec3.create();
			vec3.copy(bp, this.pos);
			bp[0] = Math.cos(-this.r + ROT_OFFSET) * MOVE_RATE * CHEESE_RATE + this.velx;
			bp[1] = Math.sin(-this.r + ROT_OFFSET) * MOVE_RATE * CHEESE_RATE + this.vely;

			
			var b = new bullet(this.pos, bp, 1, .65, [1,1,1,1]);
			
			glevel.bullets.push(b);
			
			/*
			bp[0] = -((canvas.width / 2) - curx);
			bp[1] = (canvas.height / 2) - cury;
			bp[2] = 0;
			vec3.normalize(bp, bp);
			bp[0] += Math.random() * .1 - .05;
			bp[1] += Math.random() * .1 - .05;
			vec3.normalize(bp, bp);
			
			var b = new bullet(this.pos, bp, 1, .65, this.color);
			glevel.bullets.push(b);/**/
			
			this.ammo -= 1;
			//if(this.ammo <= 0) alert("NO AMMO OGM");
			
			//TODO:   GAMEOVER.
			
		}
	}
	
	var dir = 0;
	if(movekeys[1]) dir += SPIN_RATE;
	if(movekeys[3]) dir -= SPIN_RATE;

	if(Math.abs(this.rspd + dir) <= Math.PI / 20) this.rspd += dir;
	if(movekeys[2]){
		if(Math.abs(this.rspd) < SPIN_RATE) this.rspd = 0; // Get rid of rounding errors.
		if(this.rspd > 0) this.rspd -= SPIN_RATE;
		if(this.rspd < 0) this.rspd += SPIN_RATE;
	}
	this.r += this.rspd;
	
	if(movekeys[0]){
		this.velx -= Math.cos(-this.r + ROT_OFFSET) * MOVE_RATE;
		this.vely -= Math.sin(-this.r + ROT_OFFSET) * MOVE_RATE;
		//console.log(this.pos);
	}

	this.pos[0] += this.velx;
	this.pos[1] += this.vely;
	
	if(this.pos[0] < -food_dist) this.pos[0] += food_dist * 2;
	if(this.pos[0] >  food_dist) this.pos[0] -= food_dist * 2;
	if(this.pos[1] < -food_dist) this.pos[1] += food_dist * 2;
	if(this.pos[1] >  food_dist) this.pos[1] -= food_dist * 2;
	
	this.rspd *= .98;
	this.velx *= .99;
	this.vely *= .99;
	
	g_cam.lamps[0].pos = [this.pos[0] + 0,	 this.pos[1] + 0,	this.pos[2] + 5.5];
	g_cam.lamps[1].pos = [this.pos[0] + 0,	 this.pos[1] + 10,	this.pos[2] + 5.5];
	g_cam.lamps[2].pos = [this.pos[0] + 512, this.pos[1] + 512,	this.pos[2] + 512];
	g_cam.lamps[3].pos = [this.pos[0] + 0,	 this.pos[1] + -10,	this.pos[2] + 5.5];
	
	if(this.ammo == 0){
		if(this.alive){
			this.alive = 0;
			if(glevel.score > 400){
				var b = new badger("models/badgerhat.png", rand_array(goodending));
				badgers.push(b);
			}else{
				var b = new badger("models/badgerastro.png", rand_array(badending));
				badgers.push(b);
				
			}
		}
	}
	
}



player_.prototype.render = function(){
	//this.model.color = [1.0, 1.0, 1.0, 1.0];
	
	this.rote[2] -= 0.01;
	this.rot = quat.create();
	quat.rotateX(this.rot, this.rot, this.rote[0]);
	
	quat.rotateY(this.rot, this.rot, this.r);

	
	quat.rotateZ(this.rot, this.rot, this.rote[2]);
	quat.rotateY(this.rot, this.rot, this.rote[1]);
	
	//console.log(this.r);

	
	this.model.render(this.pos, this.rot, [1,1,1]);
}