var wall_model = null;

function movewall(spos, epos, rate, color){
	if(wall_model == null) wall_model = drawables["movewall"];
	this.spos = vec3.clone(spos);
	this.pos  = vec3.clone(spos);
	this.epos = vec3.clone(epos);
	this.rate = rate;
	this.size = 1.5;
	this.os = 0;
	this.color = color;
	this.rot = quat.create();
}

movewall.prototype.tick = function(){
	if(this.color == player.color) this.os += this.rate * .25;
	else this.os += this.rate;
	vec3.lerp(this.pos, this.spos, this.epos, Math.sin(this.os) * .5 + .5);
}

movewall.prototype.render = function(){
	if(wall_model == null){
		console.log("movewall no model?");
		return;
	}
	if(this.color){
		wall_model.color = [1,1,1,1];
	}else{
		wall_model.color = [.2,.2,.2,1];
	}
	wall_model.render(this.pos, this.rot, [1,1,1]);
}

movewall.prototype.hit = function(b){
	
}

movewall.prototype.move = function(){
	
}