"use strict";



function enemy(pos,name,color){
	this.pos = pos;
	this.name = name;
	this.color = color; // 0 black, 1 white
	this.model = [drawables["robot_body"], drawables["robot_head"]];

	this.rot = quat.create();
	this.seen = 0;
	this.spd = .225;
	var t = glevel.getz(this.pos[0], this.pos[1]);
	if(t) this.pos[2] = t[0];
	this.hp = 5;
	
	this.rotdir = Math.random() * Math.PI * 2;
	this.wiggle = 0;
	this.glow = 0; // For when hit, etc..
	this.size = 1.0;
}

enemy.prototype.render = function(){
	if(this.model[0] == null) return;
	if(this.model[1] == null) return;
	if(this.color){
		this.model[0].color = [1.0,1.0-this.glow,1.0-this.glow,1.0];
		this.model[1].color = [1.0,1.0-this.glow,1.0-this.glow,1.0];
	}else{
		this.model[0].color = [.2+this.glow,.2,.2,1.0];
		this.model[1].color = [.2+this.glow,.2,.2,1.0];
	}

	this.glow *= .5;
	quat.rotateZ(this.rot, no_rot, this.rotdir);
	this.model[1].render(this.pos, this.rot, [1,1,1]);
	quat.rotateZ(this.rot, this.rot, Math.sin(this.wiggle) * .5);
	this.model[0].render(this.pos, this.rot, [1,1,1]);
}

enemy.prototype.tick = function(){
	
	if(vec3.dist(this.pos, player.pos) < 16)
	if(glevel.raycast(this.pos, player.pos, .5)){
		this.seen = 1;
	}
	if(this.seen > .005){
		
		var v = vec3.create();
		vec3.sub(v, this.pos, player.pos);
		vec3.normalize(v,v);
		
		this.rotdir = Math.atan2(v[1], v[0]);
		var mult = 1.0;
		if(this.color == player.color) mult = .25;
		v[0] *= -this.spd * mult;
		v[1] *= -this.spd * mult;
		v[2] *= -this.spd * mult;
		this.move(v);
		this.seen -= .002;
		this.wiggle += 0.157;
	}
	if(this.color){
		
	}else{
		
	}
	
	
	if(this.hp <= 0) return 1;
	return 0;
}

// Push itself at NP
enemy.prototype.move = function(np){
	var v = [this.pos[0] + np[0], this.pos[1], this.pos[2]];
	this.pos = glevel.move(this.pos, v, 0.5);
	v = [this.pos[0], this.pos[1] + np[1], this.pos[2]];
	this.pos = glevel.move(this.pos, v, 0.5);
}

enemy.prototype.hit = function(b){
	if(b.dmg){
		this.hp -= b.dmg
		this.glow = 1.0;
		this.seen = 1.0;
		player.color = this.color;
	}else console.log("??????");
}


