"use strict";
///////////////////////////////////////////////
//
//  Copyright 2016 David Gross
//  Not for distribution of modification of any kind without explicit written permission!
//
//  Food related class stuff for the Cheese Harrier
//




var cracker_score = [0, 5, 15, 25, 40, 50, 40, 25, 15, 5, 0];
var fruit_score = [0, -5, -15, -25, -40, -50];

function calc_score(ar, i){
	if(i >= ar.length) i = ar.length - 1;
	return ar[i];
}

var CRACKER_SIZE = [2,2,2];

function food(isfruit){
	this.fruit = isfruit;
	this.cheesy = 0; // Delicious, unless fruit, gross.
	this.size = .25;
	
	this.pos = vec3.create();
	this.velx = 0;
	this.vely = 0;
	this.rot = quat.create();
	this.spin();
	
	this.model = drawables["cracker"];
	if(this.fruit) this.model = drawables["cherry"];
	
	this.cheesemodel = drawables["cheesecracker"];
	if(this.fruit) this.cheesemodel = drawables["cheesecherry"];
}

food.prototype.tick = function(){
	
	vec3.add(this.pos, this.pos, [this.velx, this.vely, 0]);
	// Just loop the world around, lazily, and slowly.
	if(this.pos[0] - player.pos[0] < -food_dist) this.pos[0] += food_dist * 2;
	if(this.pos[0] - player.pos[0] >  food_dist) this.pos[0] -= food_dist * 2;
	if(this.pos[1] - player.pos[1] < -food_dist) this.pos[1] += food_dist * 2;
	if(this.pos[1] - player.pos[1] >  food_dist) this.pos[1] -= food_dist * 2;
	
	
	quat.rotateX(this.rot, this.rot, this.rotd[0]);
	quat.rotateY(this.rot, this.rot, this.rotd[1]);
	quat.rotateZ(this.rot, this.rot, this.rotd[2]);

	//this.rot = vec3.add(this.rot, this.rotd);
}

food.prototype.render = function(){
	if(vec3.dist(this.pos, player.pos) < 15.0) this.model.render(this.pos, this.rot, CRACKER_SIZE);
	
	if(this.cheesy){
		gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
		gl.enable(gl.BLEND);
		gl.disable(gl.DEPTH_TEST);
		this.cheesemodel.color[3] = Math.pow(this.cheesy / 5, .5);
		this.cheesemodel.render(this.pos, this.rot, CRACKER_SIZE);
		gl.enable(gl.DEPTH_TEST);
	}
}

food.prototype.hit = function(b){
	if(b.dmg){
		this.hp -= b.dmg
		this.glow = 1.0;
		this.seen = 1.0;
		this.cheesy += 1;
		
		if((!glevel.badger_fifd || Math.random() > .85) && !this.fruit && this.cheesy == 5){
			glevel.badger_fifd = 1;
			var b = new badger("models/badgerhappy.png", rand_array(fifdtxt));
			badgers.push(b);
		}
		if((!glevel.badger_seven || Math.random() > .6) && !this.fruit && this.cheesy == 7){
			glevel.badger_seven = 1;
			var b = new badger("models/badgerfull.png", rand_array(seventxt));
			badgers.push(b);
		}
		if((!glevel.badger_fruit || Math.random() > .95) && this.fruit){
			glevel.badger_fruit = 1;
			var b = new badger("models/badgerfull.png", rand_array(fruittxt));
			badgers.push(b);
		}
	}else console.log("??????");
}

food.prototype.score = function(){
	if(this.fruit) return calc_score(fruit_score, this.cheesy);
	return calc_score(cracker_score, this.cheesy);
}

food.prototype.spin = function(){
		this.rotd = [
					Math.random() * .05 - .025,
					Math.random() * .05 - .025,
					Math.random() * .05 - .025];
}
// Check against cheese.