import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Connection {
	
	final private Socket socket;
	final private JSONParser parser;
	private PrintWriter out;
	private BufferedReader in;
	
	public Connection() {
		
		socket = new Socket();
		parser = new JSONParser();
		
		try {
			socket.connect(new InetSocketAddress("127.0.0.1", 54321));
			out = new PrintWriter(socket.getOutputStream(), true);
			in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			
			out.println("NAME Exanyr");
			
			String s;
			while ((s = in.readLine()) != null) {
				final JSONObject msg = (JSONObject) parser.parse(s);
				final String type = (String) msg.get("messagetype");
				
				if (type.equals("stateupdate")) {
					final JSONObject gamestate = (JSONObject) msg.get("gamestate");
					
					final JSONObject you = (JSONObject) gamestate.get("you");
					double energy, id, rotation, velocityX, velocityY, x, y;
					energy = Double.valueOf(you.get("energy").toString());
					id = Double.valueOf(you.get("id").toString());
					rotation = Double.valueOf(you.get("rotation").toString());
					velocityX = Double.valueOf(you.get("velocityX").toString());
					velocityY = Double.valueOf(you.get("velocityY").toString());
					x = (double) Double.valueOf(you.get("x").toString());
					y = (double) Double.valueOf(you.get("y").toString());
					
					final JSONArray others = (JSONArray) gamestate.get("others");
					if (!others.isEmpty()) {
						for (Object o : others) {
							final JSONObject other = (JSONObject) o;
							final double oenergy, oid, orotation, ovelocityX, ovelocityY, ox, oy;
							oenergy = Double.valueOf(other.get("energy").toString());
							oid = Double.valueOf(other.get("id").toString());
							orotation = Double.valueOf(other.get("rotation").toString());
							ovelocityX = Double.valueOf(other.get("velocityX").toString());
							ovelocityY = Double.valueOf(other.get("velocityY").toString());
							ox = (double) Double.valueOf(other.get("x").toString());
							oy = (double) Double.valueOf(other.get("y").toString());
							
							double dz = Math.hypot(Math.abs(x-ox), Math.abs(y-oy)) / 0.05;
							double dx = dz * ovelocityX;
							double dy = dz * ovelocityY;
							
							final double ang = Math.toDegrees(Math.atan2(oy + dy - y, ox + dx - x));
							final double sunAng = Math.toDegrees(Math.atan2(0 - y, 0 - x));
							if ((ang - rotation > 0 && ang - rotation < 180)|| (ang + 360 - rotation > 0 && ang + 360 - rotation < 180)) {
								action(Action.RIGHT);
							}
							else if ((rotation - ang > 20 && rotation - ang < 180) || (rotation + 360 - ang > 20 && rotation + 360 - ang < 180)) {
								action(Action.LEFT);
							}
							else if ((rotation - sunAng < 20 && rotation - sunAng > 0) || (rotation + 360 - sunAng < 180 && rotation + 360 - sunAng > 20)) {
								action(Action.RIGHT);
							}
							else {
								action(Action.MISSILE);
								
							}
 						}
					}
					
					final JSONArray missiles = (JSONArray) gamestate.get("missiles");
					if (!missiles.isEmpty()) {
						for (Object o : missiles) {
							JSONObject missile = (JSONObject) o;
						}
					}
				}
				else if (type.equals("dead")) {
					System.out.println("DEAD");
				}
				else if (type.equals("endofround")) {
					System.out.println("END OF ROUND");
				}
				
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void action(Action action) {
		out.println(action);
	}
	
	public static void main(String[] args) {
		new Connection();
	}
	
}
