﻿using System;
using System.IO;
using System.Net.Sockets;

namespace g23pax {
   public class Entry {
      public class Connection {
         public Action<GameState.Decision> SendDecision { get; private set; }

         public Func<GameState> ReceiveState { get; private set; }

         public Connection(string name, string host = "127.0.0.1", int port = 54321) {
            var cli = new TcpClient();
            cli.NoDelay = true;
            cli.Connect(host, port);
            var sw = new StreamWriter(cli.GetStream());
            var rdr = new StreamReader(cli.GetStream());

            var Send = new Action<string>(s => {
               try {
                  sw.Write(s + "\n");
                  sw.Flush();
               }
               catch (Exception x) {
                  Console.WriteLine(x);
               }
            });

            SendDecision = d => {
               if (d != GameState.Decision.None)
                  Send(
                     d == GameState.Decision.A
                        ? "ACCELERATE"
                        : d == GameState.Decision.L
                           ? "LEFT"
                           : d == GameState.Decision.R
                              ? "RIGHT"
                              : d == GameState.Decision.M
                                 ? "MISSILE"
                                 : d == GameState.Decision.Mine
                                    ? "MINE"
                                    : "");
            };

            ReceiveState = () => {
               var start = DateTime.Now;
               var line = rdr.ReadLine();
               return TurnonmeParser.Parse(line);
            };

            Send("NAME " + name);
         }
      }

      private static void Main(string[] args) {
         string host = "88.92.103.246";
         host = "127.0.0.1";
         int port = 54321;
         var g23 = new G_23_pax();
         var c = new Connection("G[23]pax", host, port);
         GameState state;
         while (true) {
            c.SendDecision(g23.PaxilonHydrochlorate(c.ReceiveState()));
         }
      }
   }
}

