#!/usr/bin/python           # This is server.py file

import socket               # Import socket module
import json
import math
import sys
from random import random
from time import sleep

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)         # Create a socket object
host = "127.0.0.1" 	 # Get local machine name
port = 54321                # Reserve a port for your service.

#s.settimeout(0.4)
s.connect((host, port))
s.send(b"NAME Leech\n")


while True:
	line = ""
	characters_to_read=-1
	while (characters_to_read < 0):
     		try:
			data = s.recv(4096)
			characters_to_read = data.index("\n")
			line = line + data[0:characters_to_read]  # removing the newline
		except:
			if data == "":
				print "closed?"
				sys.exit()
			line = line + data
			characters_to_read=-1

	if "gamestate" in line:

		try:
			packet = json.loads(line)
			gamestate = packet['gamestate']
			me = gamestate['you']
			others = gamestate['others']
			bestEnemyEnergy=0

			for enemy in others:
				if enemy['energy'] > bestEnemyEnergy:
					myEnemy=enemy
					bestEnemyEnergy=enemy['energy']

			distanceX = myEnemy['x']-me['x']
			distanceY = myEnemy['y']-me['y']

			distance = math.sqrt(math.pow(distanceX,2)+math.pow(distanceY,2))

			print distance

			rounds=distance/0.04

			print rounds

			EnemyX=myEnemy['x']
			EnemyY=myEnemy['y']
			EnemyVeloX=myEnemy['velocityX']
			EnemyVeloY=myEnemy['velocityY']

			while rounds > 0:

				EnemyAngle=math.atan2(EnemyY,EnemyX)
				EnemyDistance=math.hypot(EnemyX,EnemyY)

				EnemyForce = EnemyDistance/myEnemy['energy']

				EnemyVeloX = EnemyVeloX - math.cos(EnemyAngle) * EnemyForce
				EnemyVeloY = EnemyVeloY - math.sin(EnemyAngle) * EnemyForce

				EnemyX = EnemyX + EnemyVeloX
				EnemyY = EnemyY + EnemyVeloY

				rounds = rounds -1


			mydirectionX = math.cos(me['rotation']*math.pi/180)
			mydirectionY = math.sin(me['rotation']*math.pi/180)
			myDirection = math.hypot(mydirectionX,mydirectionY)

			targetdistanceX= EnemyX-me['x']
			targetdistanceY= EnemyY-me['y']

			targetdistance=math.hypot(targetdistanceX,targetdistanceY)

			targetvectorX=targetdistanceX/targetdistance
			targetvectorY=targetdistanceY/targetdistance

			phi0 = mydirectionX*targetvectorX+mydirectionY*targetvectorY

			phi=math.acos(phi0)/math.pi*180

			if phi < 5:
				s.send(b"MISSILE\n")

			else:
				lr = mydirectionX * targetvectorY - mydirectionY * targetvectorX

				if lr < 0 :
					s.send(b"LEFT\n")
				else:
					s.send(b"RIGHT\n")

		except:
			print "."



s.close                     # Close the socket when done
