#include "Ship.h"

Ship::Ship(const QJsonObject &jsonObject)
	: AbstractGameObject(jsonObject)
{
}

void Ship::step()
{
	if (energy().isEmpty())
	{
		return;
	}

	const auto& distanceToSun = position().distanceTo(Position::sun());
	if (distanceToSun < 0.1)
	{
		setAlive(false);
		return;
	}

	const auto& angleToSun = position().angleTo(Position::sun());
	const auto& gravityPull = distanceToSun / energy().value();
	velocity() += Velocity(qCos(angleToSun.asRadians()) * gravityPull, qSin(angleToSun.asRadians()) * gravityPull);

	// Ship max velocity is handeled different from missiles, so..
	static constexpr Velocity minVelocity(-0.05, -0.05);
	static constexpr Velocity maxVelocity(0.05, 0.05);
	velocity().limitWithin(minVelocity, maxVelocity);

	position() += velocity();
}
