#pragma once

#include "Angle.h"

namespace C
{
	namespace Missile
	{
		constexpr auto MAX_SPEED = 0.05;

		constexpr auto NORMAL_COST = 10;
		constexpr auto SEEKING_COST = 15;
		constexpr auto MINE_COST = 20;

		constexpr auto DAMAGE = 50;
	}

	namespace Ship
	{
		constexpr auto ACCELERATION_FORCE = 0.001;
		constexpr auto ACCELERATION_COST = 2;

		constexpr auto ROTATE_AMOUNT = Angle::fromDegrees(10);
		constexpr auto ROTATE_COST = 1;
	}

	namespace World
	{
		constexpr auto WIDTH = 2.;
		constexpr auto HEIGHT = 2.;

		constexpr auto SUN_X = 0.;
		constexpr auto SUN_Y = 0.;
	}
}
